/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotModelDesignerMultipleDataSources;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Model;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Service;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryInfoSetService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.TemplateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBuilderUtils;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.util.CastUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeneralPageTemplate<T extends PcUiBotPageDefine>
implements TemplateService<T> {
    private static final Logger log = LoggerFactory.getLogger(GeneralPageTemplate.class);
    public static final String generalPageTemplate = "general-page-template";
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    protected PcRuleService pcRuleService;
    @Autowired
    protected MobileDesignerConfigRepository mobileDesignerConfigRepository;
    @Autowired
    protected MockV2Service mockV2Service;
    @Resource(name="defaultThreadPool")
    protected ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    protected QueryInfoSetService queryInfoSetService;

    public String supportKey() {
        return generalPageTemplate;
    }

    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, T mainAction, List<T> pageDefines) {
        UiBotModel dynamicForm = UiBotModel.emptyUiBotModel();
        dynamicForm.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        long start = System.currentTimeMillis();
        QueryResultSet queryResultSet = this.BuildDataSource(executeContext, mainAction, dynamicForm, apiRequest);
        if (null != queryResultSet && queryResultSet.getMainQueryResult() != null && mainAction.getPageInfo() != null && queryResultSet.getMainQueryResult().isHasNext()) {
            mainAction.setUseHasNext(Boolean.valueOf(true));
        }
        Long firstBacklogId = executeContext.getFirstBacklogId();
        log.debug("[{}]\u8bfb\u53d6\u6570\u636e\uff0ccost\uff1a{} ms", (Object)firstBacklogId, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.BuildLayout(apiRequest, executeContext, queryResultSet, mainAction, pageDefines, dynamicForm);
        log.debug("[{}]\u521b\u5efa\u5e03\u5c40\uff0ccost\uff1a{} ms", (Object)firstBacklogId, (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.BuildRule(apiRequest, executeContext, mainAction, dynamicForm, queryResultSet);
        this.BuildStyle(executeContext, dynamicForm);
        log.debug("[{}]\u521b\u5efa\u89c4\u5219\uff0ccost\uff1a{} ms", (Object)firstBacklogId, (Object)(System.currentTimeMillis() - start));
        this.BuildPageInfo(executeContext, mainAction, dynamicForm);
        this.BuildPageData(dynamicForm, queryResultSet);
        start = System.currentTimeMillis();
        this.BuildActions(executeContext, mainAction, dynamicForm);
        PcUiBotBuilderUtils.BuildVariables((UiBotModel)dynamicForm);
        log.debug("[{}]\u521b\u5efa\u63d0\u4ea4\uff0ccost\uff1a{} ms", (Object)firstBacklogId, (Object)(System.currentTimeMillis() - start));
        if (dynamicForm.getFinished() != null && dynamicForm.getFinished().booleanValue() && !CollectionUtils.isEmpty((Collection)dynamicForm.getRules()) && !TaskStringUtil.isBizApproval((String)executeContext.getPattern(), (String)executeContext.getCategory())) {
            this.filterEditRules(dynamicForm.getRules());
        }
        return dynamicForm;
    }

    protected void BuildPageData(UiBotModel dynamicForm, QueryResultSet queryResultSet) {
        if (queryResultSet != null && queryResultSet.getMainQueryResult() != null && StringUtils.hasText((String)queryResultSet.getMainQueryResult().getDataSourceName())) {
            Map result = queryResultSet.getPageData();
            for (String key : result.keySet()) {
                if (dynamicForm.getPageData().containsKey((Object)key)) continue;
                dynamicForm.getPageData().put((Object)key, result.get(key));
            }
            dynamicForm.setPageDataIndex((UiBotPageData)JsonUtil.objectToJavaObject((Object)queryResultSet.getPageDataIndex(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
            dynamicForm.setPageDataKeys((UiBotPageData)JsonUtil.objectToJavaObject((Object)queryResultSet.getPageDataKeys(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    protected void BuildPageInfo(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm) {
    }

    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        if (pageDefine == null) {
            return null;
        }
        PcUiBotExecuteContext pageDefineContext = pageDefine.getExecuteContext();
        if (Boolean.TRUE.equals(pageDefine.getEnableBackEndPaging()) && Objects.nonNull(pageDefineContext)) {
            pageDefineContext.setFromAdsc(Boolean.valueOf(true));
        }
        if (Objects.nonNull(pageDefineContext) && Boolean.TRUE.equals(pageDefineContext.getFromAdsc()) && Objects.isNull(pageDefine.getPageInfo())) {
            PcUiBotPageInfo pageInfo = new PcUiBotPageInfo();
            pageInfo.setPageNo(Integer.valueOf(1));
            pageInfo.setPageSize(Integer.valueOf(50));
            pageDefine.setPageInfo(pageInfo);
        }
        QueryResultSet queryResultSet = this.queryByPagedefineWithMetaData(pageDefineContext, pageDefine, apiRequest);
        this.filterQueryResultSet(queryResultSet, pageDefine);
        this.appendFixedParameters(queryResultSet, pageDefine);
        return queryResultSet;
    }

    private void filterQueryResultSet(QueryResultSet queryResultSet, T pageDefine) {
        if (queryResultSet == null) {
            return;
        }
        List queryResults = queryResultSet.getQueryResults();
        if (CollectionUtils.isEmpty((Collection)queryResults)) {
            return;
        }
        PcUiBotTmDataFilter dataFilter = pageDefine.getDataFilter();
        if (dataFilter == null) {
            return;
        }
        List apiCondition = dataFilter.getApiCondition();
        if (CollectionUtils.isEmpty((Collection)apiCondition)) {
            return;
        }
        HashMap filterMap = new HashMap();
        apiCondition.forEach(r -> {
            String conName = r.getName();
            if (conName.contains(".")) {
                String[] conNames = conName.split("\\.");
                filterMap.put(conNames[1], StringUtil.valueOf((Object)r.getValue()));
            } else {
                filterMap.put(r.getName(), StringUtil.valueOf((Object)r.getValue()));
            }
        });
        for (QueryResult queryResult : queryResults) {
            List data = queryResult.getData();
            if (CollectionUtils.isEmpty((Collection)data)) continue;
            data = data.stream().filter(r -> filterMap.keySet().stream().allMatch(key -> {
                String value = (String)filterMap.get(key);
                if (!r.containsKey(key)) {
                    return true;
                }
                if ("true".equals(value)) {
                    return Objects.equals(r.get(key), true);
                }
                if ("false".equals(value)) {
                    return Objects.equals(r.get(key), false);
                }
                return Objects.equals(r.get(key), value);
            })).collect(Collectors.toList());
            queryResult.setData(data);
            queryResult.setTotalResults(Integer.valueOf(data.size()));
        }
    }

    public QueryResultSet queryByPagedefineWithMetaData(PcUiBotExecuteContext executeContext, T pageDefine, ApiRequest apiRequest) {
        MockV2Model mockV2Model;
        if (executeContext == null || pageDefine.getDataSourceSet() == null) {
            return QueryResultSet.empty();
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("dataSourceSetDTO", pageDefine.getDataSourceSet());
        PcUiBotExecuteContext pcUiBotExecuteContext = (PcUiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, PcUiBotExecuteContext.class);
        if ("project-detail-mobile".equals(executeContext.getPageCode())) {
            pcUiBotExecuteContext.setPageCode("project-detail");
        } else {
            pcUiBotExecuteContext.setPageCode("task-detail");
        }
        body.put("executeContext", pcUiBotExecuteContext);
        body.put("parameter", pageDefine.getParameter());
        body.put("settings", pageDefine.getSettings());
        if (pageDefine.getPageInfo() != null) {
            body.put("pageInfo", pageDefine.getPageInfo());
        }
        if (pageDefine.getSortInfo() != null && !pageDefine.getSortInfo().isEmpty()) {
            body.put("sortInfo", pageDefine.getSortInfo());
        }
        if (pageDefine.getSearchInfo() != null && !pageDefine.getSearchInfo().isEmpty()) {
            body.put("searchInfo", pageDefine.getSearchInfo());
        }
        if (executeContext.getTmActivityId().contains("multi_speed_task") && ObjectUtils.isNotEmpty((Object)(mockV2Model = this.mockV2Service.getMockV2Model("multi_speed_task")))) {
            return mockV2Model.getData();
        }
        if ((executeContext.getTmActivityId().contains("lcdp_task") || executeContext.getTmActivityId().contains("mAthenaDesigner_task")) && !"A20240409174845_lcdp_task_0004".equalsIgnoreCase(executeContext.getTmActivityId()) && ObjectUtils.isNotEmpty((Object)(mockV2Model = this.mockV2Service.getMockV2Model("lcdp_task")))) {
            return mockV2Model.getData();
        }
        String dataSourceName = AppRequestContext.getContextEntity().getDataSourceName();
        if (StringUtil.isNotEmpty((CharSequence)dataSourceName)) {
            UiBotModelDesignerMultipleDataSources.handleDataSourceParas((PcUiBotDataSourceSetDTO)pageDefine.getDataSourceSet(), (ApiRequest)apiRequest);
        }
        return this.digiwinAtdmProxyService.queryWithMetaData(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), JsonUtil.javaObjectToJsonString(body), executeContext.getAuthoredUser().getTenantId());
    }

    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, List<T> pageDefines, UiBotModel dynamicForm) {
        this.queryInfoSetService.buildLayoutDsl(executeContext, queryResultSet, pageDefine);
    }

    protected void BuildRule(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm, QueryResultSet queryResultSet) {
    }

    protected void BuildStyle(PcUiBotExecuteContext executeContext, UiBotModel dynamicForm) {
    }

    protected void BuildActions(PcUiBotExecuteContext executeContext, T pageDefine, UiBotModel dynamicForm) {
        if (this.requireRenderActions(pageDefine, dynamicForm) && !CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions())) {
            dynamicForm.setActions((List)JsonUtil.objectToJavaObject((Object)pageDefine.getSubmitActions(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private boolean requireRenderActions(T pageDefine, UiBotModel dynamicForm) {
        PcUiBotDataSourceSetDTO dataSourceSetDTO = pageDefine.getDataSourceSet();
        if (null == dataSourceSetDTO || CollectionUtils.isEmpty((Collection)dataSourceSetDTO.getDataSourceList())) {
            return true;
        }
        UiBotPageData pageData = dynamicForm.getPageData();
        if (CollectionUtils.isEmpty((Map)pageData)) {
            return false;
        }
        for (PcUiBotDataSourceDTO dataSourceDTO : dataSourceSetDTO.getDataSourceList()) {
            Object dataObj = pageData.get(dataSourceDTO.getName());
            if (null == dataObj) continue;
            if (!(dataObj instanceof Collection)) {
                return true;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)dataObj))) continue;
            return true;
        }
        return false;
    }

    public void filterEditRules(List<UiBotRule> rules) {
        rules.removeIf(rule -> Objects.equals("EDIT", rule.getScope()));
    }

    protected void appendFixedParameters(QueryResultSet queryResultSet, T pageDefine) {
        if (queryResultSet == null) {
            return;
        }
        this.appendFixedParameters(queryResultSet.getPageData(), pageDefine);
    }

    protected void appendFixedParameters(Map<String, Object> pageData, T pageDefine) {
        if (CollectionUtils.isEmpty(pageData)) {
            return;
        }
        this.appendEditTypeParam(pageData, pageDefine);
    }

    protected void appendEditTypeParam(Map<String, Object> pageData, T pageDefine) {
        List submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty((Collection)submitActions)) {
            return;
        }
        boolean noneCombineSubmitAction = submitActions.stream().noneMatch(submitAction -> "COMBINE".equals(submitAction.getType()));
        if (noneCombineSubmitAction) {
            return;
        }
        for (Object rowData : pageData.values()) {
            if (rowData instanceof List) {
                List rowDataList = (List)CastUtils.cast((Object)rowData);
                for (Map rowDataMap : rowDataList) {
                    rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
                }
                continue;
            }
            if (!(rowData instanceof Map)) continue;
            Map rowDataMap = (Map)CastUtils.cast((Object)rowData);
            rowDataMap.putAll(PcUiBotActivityConstants.EDIT_TYPE_MAP);
        }
    }

    protected QueryResultSet queryByActivityQueryDTO(PcUiBotExecuteContext executeContext, PcUiBotDataSourceSetDTO dataSourceSet, Map<String, Object> parameter, PcUiBotPageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (dataSourceSet == null) {
            return QueryResultSet.empty();
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("dataSourceSetDTO", dataSourceSet);
        body.put("executeContext", executeContext);
        body.put("parameter", parameter);
        if (pageInfo != null) {
            body.put("pageInfo", pageInfo);
        }
        if (sortInfo != null && sortInfo.size() > 0) {
            body.put("sortInfo", sortInfo);
        }
        if (searchInfo != null && searchInfo.size() > 0) {
            body.put("searchInfo", searchInfo);
        }
        return this.digiwinAtdmProxyService.queryByActivityQueryDTO(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), JsonUtil.javaObjectToJsonString(body), executeContext.getTenantId());
    }

    protected PcUiBotTaskPageDefine handleDefaultPageDefine(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        for (PcUiBotTaskPageDefine temp : pageDefines) {
            Integer total = this.queryDataSize(executeContext, temp);
            if (total == null || total <= 0) continue;
            temp.setIsDefault(Boolean.valueOf(true));
            temp.setRowSize(total);
            return temp;
        }
        return mainAction;
    }

    protected PcUiBotTaskPageDefine handleDefaultPageDefineByFilter(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine mainAction, List<PcUiBotTaskPageDefine> pageDefines) {
        for (PcUiBotTaskPageDefine temp : pageDefines) {
            PcUiBotPageDefine t = (PcUiBotPageDefine)JsonUtil.objectToJavaObject((Object)temp, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            QueryResultSet queryResultSet = this.queryByPagedefineWithMetaData(executeContext, t, apiRequest);
            this.filterQueryResultSet(queryResultSet, t);
            int total = Optional.ofNullable(queryResultSet).map(QueryResultSet::getQueryResults).filter(e -> !CollectionUtils.isEmpty((Collection)e)).map(queryResults -> (QueryResult)queryResults.get(0)).map(QueryResult::getData).map(data -> data.size()).orElse(0);
            if (total <= 0) continue;
            temp.setIsDefault(Boolean.valueOf(true));
            temp.setRowSize(Integer.valueOf(total));
            return temp;
        }
        return mainAction;
    }

    protected Integer queryDataSize(PcUiBotExecuteContext executeContext, PcUiBotTaskPageDefine pageDefine) {
        if (pageDefine == null) {
            return 0;
        }
        Map body = (Map)JsonUtil.objectToJavaObject((Object)pageDefine, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        body.put("executeContext", executeContext);
        return this.digiwinAtdmProxyService.getDataSize(executeContext.getLocale(), executeContext.getAuthoredUser().getToken(), body, executeContext.getTenantId());
    }

    public UiBotModel createPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, T mainAction, List<T> pageDefines) {
        return null;
    }
}

