/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAttachmentConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAttachmentConfigInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmActivity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataProcess;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataState;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmQueryAction;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PcUiBotAttachmentUtil {
    public static boolean isPageCodeEnableAttachment(String pageCode) {
        return "task-detail-mobile".equals(pageCode) || "project-detail-mobile".equals(pageCode) || "basic-data-mobile".equals(pageCode);
    }

    public static void addDefaultAttachmentDataSourceProcess(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        if (tmActivity.getAttachment() == null) {
            return;
        }
        for (Map.Entry stringTmQueryActionEntry : tmActivity.getDataSources().entrySet()) {
            PcUiBotTmQueryAction tmQueryAction = (PcUiBotTmQueryAction)stringTmQueryActionEntry.getValue();
            ArrayList allProcessors = tmQueryAction.getDataProcessors();
            if (allProcessors == null) {
                allProcessors = new ArrayList();
                tmQueryAction.setDataProcessors(allProcessors);
            }
            Optional processInTmActivityOpt = PcUiBotAttachmentUtil.getAlreadyExistAttachmentProcessorConfig((List)tmActivity.getDataProcessors());
            Optional processInTmQueryActionOpt = PcUiBotAttachmentUtil.getAlreadyExistAttachmentProcessorConfig((List)tmQueryAction.getDataProcessors());
            if (processInTmActivityOpt.isPresent() && processInTmQueryActionOpt.isPresent()) {
                PcUiBotAttachmentConfigInfo attachmentConfigInfo = (PcUiBotAttachmentConfigInfo)((PcUiBotTmDataProcess)processInTmQueryActionOpt.get()).getParas();
                if (null == attachmentConfigInfo) {
                    attachmentConfigInfo = tmActivity.getAttachment();
                }
                PcUiBotAttachmentConfigInfo availableAttachmentConfigInfo = PcUiBotAttachmentUtil.getAvailableAttachmentConfigInfo((PcUiBotAttachmentConfigInfo)attachmentConfigInfo);
                PcUiBotAttachmentConfigInfo attachConfigInfoCopy = new PcUiBotAttachmentConfigInfo();
                if (null != availableAttachmentConfigInfo) {
                    attachConfigInfoCopy = (PcUiBotAttachmentConfigInfo)JsonUtil.objectToJavaObject((Object)availableAttachmentConfigInfo, PcUiBotAttachmentConfigInfo.class);
                }
                PcUiBotAttachmentUtil.encodeDmcAccountPwd((List)attachConfigInfoCopy.getConfigs());
                ((PcUiBotTmDataProcess)processInTmQueryActionOpt.get()).setParas((Object)attachConfigInfoCopy);
                continue;
            }
            if (processInTmActivityOpt.isPresent()) continue;
            PcUiBotAttachmentUtil.addAttachmentDataSourceProcess((PcUiBotExecuteContext)executeContext, (PcUiBotTmActivity)tmActivity, allProcessors);
        }
    }

    private static void encodeDmcAccountPwd(List<PcUiBotAttachmentConfig> attachmentConfigList) {
        if (!CollectionUtils.isEmpty(attachmentConfigList)) {
            for (PcUiBotAttachmentConfig attachmentConfig : attachmentConfigList) {
                if (null == attachmentConfig) continue;
                PcUiBotAttachmentUtil.encodeDmcAccountPwd((PcUiBotAttachmentConfig.DmcAccount)attachmentConfig.getDmcAccount());
            }
        }
    }

    private static void encodeDmcAccountPwd(PcUiBotAttachmentConfig.DmcAccount dmcAccount) {
        if (null == dmcAccount || dmcAccount.isPasswordAlreadyEncoded() || StringUtils.isBlank((CharSequence)dmcAccount.getPassword())) {
            return;
        }
        dmcAccount.setPassword(PcUiBotAttachmentUtil.encode((String)dmcAccount.getPassword()));
        dmcAccount.setPasswordAlreadyEncoded(true);
    }

    private static String encode(String text) {
        byte[] textByte = new byte[]{};
        try {
            textByte = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return Base64.getEncoder().encodeToString(textByte);
    }

    public static void appendEffectAfterSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity) {
        if (null == tmActivity.getPages()) {
            return;
        }
        List submitActions = null;
        if (!CollectionUtils.isEmpty((Collection)tmActivity.getPages().getDataStates())) {
            submitActions = ((PcUiBotTmDataState)tmActivity.getPages().getDataStates().get(0)).getSubmitActions();
        }
        if (CollectionUtils.isEmpty(submitActions)) {
            submitActions = tmActivity.getPages().getSubmitActions();
        }
        PcUiBotAttachmentUtil.appendEffectAfterSubmitAction((PcUiBotExecuteContext)executeContext, (PcUiBotAttachmentConfigInfo)tmActivity.getAttachment(), (List)submitActions);
    }

    public static void appendEffectAfterSubmitAction(PcUiBotExecuteContext executeContext, PcUiBotAttachmentConfigInfo attachmentConfigInfoParam, List<PcUiBotTmAction> submitActions) {
        if (CollectionUtils.isEmpty(submitActions)) {
            return;
        }
        for (PcUiBotTmAction submitAction : submitActions) {
            if (CollectionUtils.isEmpty((Collection)submitAction.getCombineActions())) continue;
            PcUiBotAttachmentUtil.appendEffectAfterSubmitAction((PcUiBotExecuteContext)executeContext, (PcUiBotAttachmentConfigInfo)attachmentConfigInfoParam, (List)submitAction.getCombineActions());
        }
        PcUiBotAttachmentConfigInfo attachmentConfigInfo = PcUiBotAttachmentUtil.getAvailableAttachmentConfigInfo((PcUiBotExecuteContext)executeContext, (PcUiBotAttachmentConfigInfo)attachmentConfigInfoParam);
        if (null == attachmentConfigInfo || BooleanUtils.isFalse((Boolean)attachmentConfigInfo.getEnable()) || CollectionUtils.isEmpty((Collection)attachmentConfigInfo.getConfigs())) {
            return;
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String submitVariableName = null;
        for (PcUiBotAttachmentConfig attachmentConfig : attachmentConfigInfo.getConfigs()) {
            PcUiBotAttachmentConfig.EffectAfterSubmit effectAfterSubmit = attachmentConfig.getEffectAfterSubmit();
            if (null == effectAfterSubmit) continue;
            submitVariableName = effectAfterSubmit.getSubmitVariableName();
            List applyToSubmitActionIds = effectAfterSubmit.getApplyToSubmitActionId();
            if (!StringUtils.isNotBlank((CharSequence)submitVariableName) || CollectionUtils.isEmpty((Collection)applyToSubmitActionIds)) continue;
            for (String applyToSubmitActionId : applyToSubmitActionIds) {
                List submitActionIdList = map.computeIfAbsent(applyToSubmitActionId, key -> new ArrayList());
                submitActionIdList.add(attachmentConfig.getTargetSchema());
            }
        }
        for (PcUiBotTmAction submitAction : submitActions) {
            List targetSchemaList = (List)map.get(submitAction.getActionId());
            if (CollectionUtils.isEmpty((Collection)targetSchemaList)) continue;
            PcUiBotTmAction effectAfterSubmitAction = null;
            if (null != submitAction.getAttachActions()) {
                effectAfterSubmitAction = submitAction.getAttachActions().stream().filter(attachAction -> StringUtils.equals((CharSequence)"upload-or-save-attachment", (CharSequence)attachAction.getActionId())).findFirst().orElse(null);
            } else {
                submitAction.setAttachActions(new ArrayList());
            }
            if (null == effectAfterSubmitAction) {
                effectAfterSubmitAction = PcUiBotAttachmentUtil.createEffectAfterSubmitAction();
                submitAction.getAttachActions().add(effectAfterSubmitAction);
            }
            if (null == effectAfterSubmitAction.getExtendParas()) {
                effectAfterSubmitAction.setExtendParas(new HashMap());
                effectAfterSubmitAction.getExtendParas().put("submitVariableName", submitVariableName);
                effectAfterSubmitAction.getExtendParas().put("targetSchemaList", targetSchemaList);
                continue;
            }
            effectAfterSubmitAction.getExtendParas().put("submitVariableName", submitVariableName);
            List targetSchemaListTmp = (List)effectAfterSubmitAction.getExtendParas().get("targetSchemaList");
            if (null == targetSchemaListTmp) {
                targetSchemaListTmp = targetSchemaList;
                effectAfterSubmitAction.getExtendParas().put("targetSchemaList", targetSchemaListTmp);
                continue;
            }
            targetSchemaListTmp.addAll(targetSchemaList);
        }
    }

    private static Optional<PcUiBotTmDataProcess> getAlreadyExistAttachmentProcessorConfig(List<PcUiBotTmDataProcess> tmDataProcesses) {
        if (CollectionUtils.isEmpty(tmDataProcesses)) {
            return Optional.empty();
        }
        Optional<PcUiBotTmDataProcess> attachmentProcessorOptional = tmDataProcesses.stream().filter(processor -> StringUtils.equals((CharSequence)processor.getServiceName(), (CharSequence)"attachmentDataService")).findAny();
        return attachmentProcessorOptional;
    }

    public static void addAttachmentDataSourceProcess(PcUiBotExecuteContext executeContext, PcUiBotTmActivity tmActivity, List<PcUiBotTmDataProcess> allProcessors) {
        PcUiBotAttachmentConfigInfo attachmentConfigInfo = PcUiBotAttachmentUtil.getAvailableAttachmentConfigInfo((PcUiBotExecuteContext)executeContext, (PcUiBotAttachmentConfigInfo)tmActivity.getAttachment());
        if (null == attachmentConfigInfo || BooleanUtils.isFalse((Boolean)attachmentConfigInfo.getEnable()) || CollectionUtils.isEmpty((Collection)attachmentConfigInfo.getConfigs())) {
            return;
        }
        PcUiBotTmDataProcess attachmentProcessor = new PcUiBotTmDataProcess();
        attachmentProcessor.setType("service");
        attachmentProcessor.setServiceName("attachmentDataService");
        attachmentProcessor.setActivePoint("executeCompleted");
        PcUiBotAttachmentConfigInfo attachConfigInfoCopy = (PcUiBotAttachmentConfigInfo)JsonUtil.objectToJavaObject((Object)attachmentConfigInfo, PcUiBotAttachmentConfigInfo.class);
        PcUiBotAttachmentUtil.encodeDmcAccountPwd((List)attachConfigInfoCopy.getConfigs());
        attachmentProcessor.setParas((Object)attachConfigInfoCopy);
        allProcessors.add(attachmentProcessor);
    }

    private static PcUiBotAttachmentConfigInfo getAvailableAttachmentConfigInfo(PcUiBotExecuteContext executeContext, PcUiBotAttachmentConfigInfo attachmentConfigInfo) {
        String pageCode = executeContext.getPageCode();
        if (!PcUiBotAttachmentUtil.isPageCodeEnableAttachment((String)pageCode)) {
            return null;
        }
        return PcUiBotAttachmentUtil.getAvailableAttachmentConfigInfo((PcUiBotAttachmentConfigInfo)attachmentConfigInfo);
    }

    private static PcUiBotAttachmentConfigInfo getAvailableAttachmentConfigInfo(PcUiBotAttachmentConfigInfo attachmentConfigInfo) {
        if (null == attachmentConfigInfo || BooleanUtils.isFalse((Boolean)attachmentConfigInfo.getEnable())) {
            return null;
        }
        PcUiBotAttachmentConfigInfo attachmentConfigInfoCopy = new PcUiBotAttachmentConfigInfo();
        attachmentConfigInfoCopy.setEnable(Boolean.TRUE);
        ArrayList enabledAttachmentConfigs = Lists.newArrayList();
        for (PcUiBotAttachmentConfig attachmentConfig : attachmentConfigInfo.getConfigs()) {
            if (null == attachmentConfig || !BooleanUtils.isTrue((Boolean)attachmentConfig.getEnable())) continue;
            enabledAttachmentConfigs.add(attachmentConfig);
        }
        for (int idx = 0; idx < enabledAttachmentConfigs.size(); ++idx) {
            PcUiBotAttachmentConfig attachmentConfig;
            attachmentConfig = (PcUiBotAttachmentConfig)enabledAttachmentConfigs.get(idx);
            if (!StringUtils.isBlank((CharSequence)attachmentConfig.getTargetSchema())) continue;
            attachmentConfig.setTargetSchema("attachment" + idx);
        }
        attachmentConfigInfoCopy.setConfigs((List)enabledAttachmentConfigs);
        return attachmentConfigInfoCopy;
    }

    public static boolean isPageCodeAllowEdit(String pageCode, DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        boolean pageCodeIsTaskDetail = StringUtils.equals((CharSequence)"task-detail-mobile", (CharSequence)pageCode) || StringUtils.equals((CharSequence)"basic-data-mobile", (CharSequence)pageCode) || StringUtils.equals((CharSequence)"edit-page-mobile", (CharSequence)pageCode);
        return pageCodeIsTaskDetail;
    }

    public static PcUiBotAttachmentConfigInfo toAttachment(Object param) {
        if (null == param) {
            return new PcUiBotAttachmentConfigInfo();
        }
        if (param instanceof PcUiBotAttachmentConfigInfo) {
            return (PcUiBotAttachmentConfigInfo)param;
        }
        return (PcUiBotAttachmentConfigInfo)JsonUtil.objectToJavaObject((Object)param, PcUiBotAttachmentConfigInfo.class);
    }

    private static PcUiBotTmAction createEffectAfterSubmitAction() {
        PcUiBotTmAction action = new PcUiBotTmAction();
        action.setDispatch(false);
        action.setDispatch(false);
        action.setTitle("\u4e0a\u4f20\u4fdd\u5b58/\u5220\u9664\u9644\u4ef6");
        action.setType("UIBOT");
        action.setActionId("upload-or-save-attachment");
        action.setServiceName("upload-or-save-attachment");
        action.setExtendParas(new HashMap());
        action.getExtendParas().put("targetSchemaList", new ArrayList());
        return action;
    }
}

