/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.impl.DigiwinPcUiBotProxyServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="digiwinPcUiBotProxyService")
public class DigiwinPcUiBotProxyServiceImpl
implements DigiwinPcUiBotProxyService {
    private static final Logger log = LoggerFactory.getLogger(DigiwinPcUiBotProxyServiceImpl.class);
    @Autowired
    private HttpService httpService;

    public UiBotModel getTaskTemplateShowByBacklogId(String locale, String iamUserToken, String tenantId, String backlogId, String tmTaskId, String tmActivityId, ApiRawData apiRawData) {
        ResponseEntity responseEntity;
        HttpStatus statusCode;
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/template/task/show/" + tmTaskId + "/" + tmActivityId + "/" + backlogId;
        1 responseType = new /* Unavailable Anonymous Inner Class!! */;
        String proxyToken = "";
        boolean isTeamTask = apiRawData.getBooleanValue("isTeamTask");
        if (apiRawData != null) {
            if (apiRawData.containsKey((Object)"digi-proxy-token")) {
                proxyToken = apiRawData.getString("digi-proxy-token");
            }
            if (apiRawData.getBooleanValue("isTeamTask")) {
                url = url + "?isShared=" + isTeamTask;
            }
        }
        if ((statusCode = (responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId, proxyToken), (ParameterizedTypeReference)responseType)).getStatusCode()).is2xxSuccessful()) {
            Map map = (Map)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
            if (map != null) {
                map.remove("hooks");
            }
            UiBotModel uiBotModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)map, UiBotModel.class);
            if (isTeamTask && !CollectionUtils.isEmpty((Collection)uiBotModel.getActions())) {
                uiBotModel.setActions(null);
            }
            UiBotPageData uiBotPageData = (UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class);
            uiBotModel.setRawUiBotPageData(uiBotPageData);
            return uiBotModel;
        }
        throw new ServiceException(((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
    }

    public UiBotModel getProjectTemplateShowByType(String projectType, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/template/preset-activity/show/" + projectType;
        2 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public UiBotModel simpleShow(String tmActivityId, Map<String, Object> params, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/template/simple/show";
        HashMap<String, Object> bodyPayload = new HashMap<String, Object>();
        bodyPayload.put("tmActivityId", tmActivityId);
        bodyPayload.putAll(params);
        3 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(bodyPayload), (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public UiBotModel showUibotManualTask(String tmActivityId, String iamUserToken, String tenantId, String locale, ApiRawData apiRawData) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/template/task/show/__uibot__/uibotManualTask/" + tmActivityId;
        4 responseType = new /* Unavailable Anonymous Inner Class!! */;
        String proxyToken = "";
        boolean isTeamTask = apiRawData.getBooleanValue("isTeamTask");
        if (apiRawData != null) {
            if (apiRawData.containsKey((Object)"digi-proxy-token")) {
                proxyToken = apiRawData.getString("digi-proxy-token");
            }
            if (apiRawData.getBooleanValue("isTeamTask")) {
                url = url + "?isShared=" + isTeamTask;
            }
        }
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId, proxyToken), new HashMap(), (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public List<Map<String, Object>> getProjectDetailByProjectId(String locale, String iamUserToken, String tenantId, String projectId, String tmTaskId, String tmActivityId) {
        5 responseType;
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/project/detail/" + tmTaskId + "/" + tmActivityId + "/" + projectId;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)(responseType = new /* Unavailable Anonymous Inner Class!! */));
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (List)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : Collections.emptyList();
    }

    public UiBotModel actionShow(String locale, String iamUserToken, String bodyPayload) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/action/show";
        6 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken), bodyPayload, (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public UiBotModel actionShowByProxyToken(String locale, String tenantId, String proxyToken, String iamUserToken, String bodyPayload) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/action/show";
        7 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId, proxyToken), bodyPayload, (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public Map<String, Object> getActionShowParameter(String locale, String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1" + "/data/query/action";
        8 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(locale, iamUserToken), JsonUtil.javaObjectToJsonString(params), (ParameterizedTypeReference)responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        return statusCode.is2xxSuccessful() ? (Map)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse() : new HashMap<String, Object>();
    }

    public UiBotModel conditionShow(String locale, String iamUserToken, String tenantId, String reportId) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/template/statement/condition/show/" + reportId;
        9 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public UiBotModel basicDataTaskShow(String tmActivityId, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/bot" + "/template/basic-data/show/" + tmActivityId;
        10 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("webplatform", locale, iamUserToken, tenantId), new HashMap(), (ParameterizedTypeReference)responseType);
        return this.getUiBotModelReturn(responseEntity);
    }

    public AgileDataIntermediateDsl getAgileReportShow(String snapshotId, Map<String, String> requestParam, String iamUserToken, String tenantId, String locale) {
        String url = AppContext.getApiUrlSetting().getUibotUrl() + "/api/ai/v1/agile/report" + "/show/" + snapshotId;
        if (!CollectionUtils.isEmpty(requestParam)) {
            StringBuilder queryString = new StringBuilder();
            queryString.append("?");
            for (String requestKey : requestParam.keySet()) {
                queryString.append(requestKey).append("=").append(requestParam.get(requestKey));
            }
            url = url + queryString.toString();
        }
        11 responseType = new /* Unavailable Anonymous Inner Class!! */;
        ResponseEntity responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId), new HashMap(), (ParameterizedTypeReference)responseType);
        return this.getAgileDataIntermediateDslReturn(responseEntity);
    }

    private UiBotModel getUiBotModelReturn(ResponseEntity<DigiwinAthenaApiResponse<UiBotModel>> responseEntity) {
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            UiBotModel uiBotModel = (UiBotModel)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
            if (ObjectUtil.isNotEmpty((Object)uiBotModel) && MobileRenderMetaData.RENDER_VERSION_2.equals(AppRequestContext.getContextEntity().getRenderVersion())) {
                UiBotPageData uiBotPageData = (UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class);
                uiBotModel.setRawUiBotPageData(uiBotPageData);
            }
            return uiBotModel;
        }
        return UiBotModel.emptyUiBotModel();
    }

    private AgileDataIntermediateDsl getAgileDataIntermediateDslReturn(ResponseEntity<DigiwinAthenaApiResponse<AgileDataIntermediateDsl>> responseEntity) {
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            AgileDataIntermediateDsl intermediateDsl = (AgileDataIntermediateDsl)((DigiwinAthenaApiResponse)responseEntity.getBody()).getResponse();
            if (ObjectUtil.isNotEmpty((Object)intermediateDsl) && MobileRenderMetaData.RENDER_VERSION_2.equals(AppRequestContext.getContextEntity().getRenderVersion())) {
                UiBotPageData uiBotPageData = (UiBotPageData)JsonUtil.objectToJavaObject((Object)intermediateDsl.getPageData(), UiBotPageData.class);
                intermediateDsl.setRawUiBotPageData(uiBotPageData);
            }
            return intermediateDsl;
        }
        return new AgileDataIntermediateDsl().setErrorMessage(((DigiwinAthenaApiResponse)responseEntity.getBody()).getErrorMessage());
    }
}

