/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import cn.hutool.core.util.StrUtil;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.floating.FloatingLayer;
import com.digiwin.mobile.mobileuibot.core.component.floating.FloatingLayerData;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBTaskCard;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild.UiBotModelBuildZTBCarCodeStrategy;
import com.digiwin.mobile.mobileuibot.task.model.TaskExtraParameter;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/ztb"})
public class ZhilinkZTBController {
    private static final Logger log = LoggerFactory.getLogger(ZhilinkZTBController.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private UiBotModelBuildZTBCarCodeStrategy uiBotModelBuildZTBCarCodeStrategy;
    @Autowired
    private TaskService taskService;
    @Autowired
    private PageTaskRelationService pageTaskRelationService;
    @Autowired
    private PageSettingService pageSettingService;
    @Autowired
    private ActivityFilterService activityFilterService;

    @PostMapping(value={"/cargo/information"})
    public ApiResponse<Map<String, Object>> getCargoInformation(@RequestBody ApiRequest apiRequest) throws IOException {
        String qtyLabel;
        String itemUnit;
        String itemQty;
        String itemName;
        String itemNo;
        List dataList;
        Integer total;
        Boolean hasNext;
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        Integer pageNo = null == apiRequest.getPageNum() ? 1 : apiRequest.getPageNum();
        Integer pageSize = null == apiRequest.getPageSize() ? 10 : apiRequest.getPageSize();
        HashMap<String, String> parameter = new HashMap<String, String>();
        String taskNo = (String)rawData.get("task_no");
        String transportNo = (String)rawData.get("transport_no");
        if (rawData.get("type") != null && "isTransport".equalsIgnoreCase((String)rawData.get("type"))) {
            Map cargoInformation = this.digiwinEspProxyService.getTransportCargoInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo, pageNo, pageSize, Boolean.valueOf(true));
            hasNext = (Boolean)cargoInformation.get("has_next");
            total = (Integer)cargoInformation.get("total_results");
            dataList = (List)cargoInformation.get("cargo_information");
            itemNo = "item_no";
            itemName = "item_name";
            String itemSpec = "item_spec";
            itemQty = "transport_qty";
            itemUnit = "unit_name";
            qtyLabel = "\u88c5\u8f66\u6570\u91cf";
        } else {
            parameter.put("task_no", taskNo);
            parameter.put("is_filter_load_car", (String)rawData.get("isLoadCar"));
            Map asnBodyMaps = this.digiwinEspProxyService.getAsnBody(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), pageNo, pageSize, Boolean.valueOf(true), parameter);
            dataList = (List)asnBodyMaps.get("delivery_detail");
            hasNext = (Boolean)asnBodyMaps.get("has_next");
            total = (Integer)asnBodyMaps.get("total_results");
            itemNo = "item_no";
            itemName = "item_name";
            String itemSpec = "item_spec";
            itemQty = "delivery_qty";
            itemUnit = "unit_name";
            qtyLabel = "\u6570\u91cf";
        }
        HashMap<String, Object> resultData = new HashMap<String, Object>(3);
        resultData.put("total", total);
        resultData.put("hasNext", hasNext);
        ArrayList resultdataList = new ArrayList(dataList.size());
        resultData.put("dataList", resultdataList);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        dataList.forEach(delivery -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            resultdataList.add(map);
            map.put("dataId", String.valueOf(delivery.get(itemNo)));
            map.put("title", delivery.get(itemName));
            ArrayList content = new ArrayList();
            map.put("content", content);
            HashMap<String, Object> qtyMap = new HashMap<String, Object>();
            qtyMap.put("label", this.localeService.getLanguageValue(locale, qtyLabel));
            Double deliveryQtyDouble = 0.0;
            if (delivery.get(itemQty) != null) {
                deliveryQtyDouble = Double.parseDouble(delivery.get(itemQty).toString());
            }
            String qty = deliveryQtyDouble.toString() + (delivery.get(itemUnit) == null ? "" : (String)delivery.get(itemUnit));
            qtyMap.put("value", qty);
            qtyMap.put("valueStyleType", 1);
            content.add(qtyMap);
            HashMap<String, String> detail = new HashMap<String, String>(5);
            if (StringUtils.hasLength((String)taskNo)) {
                detail.put("task_no", taskNo);
                detail.put("item_no", (String)delivery.get("item_no"));
                detail.put("delivery_no", (String)delivery.get("delivery_no"));
                detail.put("delivery_seq", (String)delivery.get("delivery_seq"));
                detail.put("delivery_qty", (String)delivery.get("delivery_qty"));
            }
            map.put("detail", detail);
        });
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value={"/vehicle/information"})
    public ApiResponse<Map<String, Object>> getVehicleInformation(@RequestBody ApiRequest apiRequest) {
        HashMap resultData = new HashMap();
        String locale = apiRequest.getLocale();
        String queryCondition = apiRequest.getQueryCondition();
        String taskNo = (String)apiRequest.getRawData().get((Object)"task_no");
        Boolean isLoadCar = (Boolean)apiRequest.getRawData().get((Object)"is_load_car");
        List vehicleList = this.digiwinEspProxyService.getVehicleInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), taskNo, isLoadCar, queryCondition);
        if (CollectionUtils.isEmpty((Collection)vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        ArrayList dataList = new ArrayList();
        resultData.put("dataList", dataList);
        if (CollectionUtils.isEmpty((Collection)vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        for (Map vehicle : vehicleList) {
            HashMap map = new HashMap();
            dataList.add(map);
            map.put("title", vehicle.get("license_plate_no"));
            map.put("dataId", String.valueOf(vehicle.get("vehicle_info_id")));
            ArrayList content = new ArrayList();
            map.put("content", content);
            HashMap<String, String> vehicleTypeMap = new HashMap<String, String>();
            vehicleTypeMap.put("label", this.localeService.getLanguageValue(locale, "\u8f66\u8f86\u7c7b\u578b"));
            vehicleTypeMap.put("value", (String)vehicle.get("vehicle_type"));
            content.add(vehicleTypeMap);
            HashMap<String, String> vehicleLengthMap = new HashMap<String, String>();
            vehicleLengthMap.put("label", this.localeService.getLanguageValue(locale, "\u8f7d\u8d27\u957f\u5ea6"));
            vehicleLengthMap.put("value", (String)vehicle.get("vehicle_length"));
            content.add(vehicleLengthMap);
            HashMap detail = new HashMap();
            detail.put("license_plate_no", vehicle.get("license_plate_no"));
            detail.put("vehicle_type", vehicle.get("vehicle_type"));
            detail.put("vehicle_length", vehicle.get("vehicle_length"));
            map.put("detail", detail);
        }
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value={"/vehicle/list"})
    public ApiResponse<Map<String, Object>> carListGet(@RequestBody ApiRequest apiRequest) {
        HashMap resultData = new HashMap();
        String locale = apiRequest.getLocale();
        List vehicleList = this.digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, null);
        if (CollectionUtils.isEmpty((Collection)vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        ArrayList dataList = new ArrayList();
        resultData.put("dataList", dataList);
        if (CollectionUtils.isEmpty((Collection)vehicleList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        for (Map vehicle : vehicleList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if ("true".equals(StringUtil.valueOf(vehicle.get("is_default")))) {
                dataList.add(0, map);
            } else {
                dataList.add(map);
            }
            ArrayList<Field> content = new ArrayList<Field>();
            map.put("content", content);
            Field licensePlateNoField = Field.createLabelValueLeftField((String)"", (String)StringUtil.valueOf(vehicle.get("license_plate_no")));
            Action editAction = new Action();
            editAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u66f4\u65b0\u8f66\u8f86\u4fe1\u606f"));
            editAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_CAR_MESSAGE.name());
            editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            HashMap<String, String> editRawData = new HashMap<String, String>(1);
            editRawData.put("editId", StringUtil.valueOf(vehicle.get("vehicle_info_id")));
            editAction.setRawData(editRawData);
            licensePlateNoField.setAction(editAction);
            content.add(licensePlateNoField);
            content.add(Field.createLabelValueLeftField((String)this.localeService.getLanguageValue(locale, "\u8f66\u8f86\u7c7b\u578b"), (String)StringUtil.valueOf(vehicle.get("vehicle_type"))));
            content.add(Field.createLabelValueLeftField((String)this.localeService.getLanguageValue(locale, "\u8f7d\u8d27\u957f\u5ea6"), (String)StringUtil.valueOf(vehicle.get("vehicle_length"))));
            String picFileId = StringUtil.valueOf(vehicle.get("pic_file_id"));
            map.put("fileId", picFileId);
            if (StringUtils.hasLength((String)picFileId)) {
                ShareInfo shareInfo = this.digiwinDmcProxyService.shareFile(picFileId, "srm-loading");
                map.put("picUrl", shareInfo.getUrl());
            }
            Button carCodeButton = new Button();
            Action action = new Action();
            action.setType(ActionTypeEnum.POP_PROMPT_REQUEST.getValue());
            action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/ztb/vehicle/qrCode");
            HashMap carCodeRawData = new HashMap(1);
            editRawData.put("editId", StringUtil.valueOf(vehicle.get("vehicle_info_id")));
            action.setRawData(carCodeRawData);
            carCodeButton.setAction(action);
            map.put("carCodeButton", carCodeButton);
            map.put("isDefault", vehicle.get("is_default"));
        }
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value={"/electronicFence/list"})
    public ApiResponse<Map<String, Object>> electronicFenceListGet(@RequestBody ApiRequest apiRequest) {
        HashMap resultData = new HashMap();
        String locale = apiRequest.getLocale();
        List electronicFenceFactoryList = this.digiwinEspProxyService.getElectronicFenceFactoryList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, null);
        if (CollectionUtils.isEmpty((Collection)electronicFenceFactoryList)) {
            return ApiResponse.buildOK().setData(resultData);
        }
        ArrayList dataList = new ArrayList();
        resultData.put("dataList", dataList);
        for (Map electronicFence : electronicFenceFactoryList) {
            HashMap map = new HashMap();
            dataList.add(map);
            ArrayList<Field> content = new ArrayList<Field>();
            map.put("content", content);
            content.add(Field.createLabelValueLeftField((String)"", (String)StringUtil.valueOf(electronicFence.get("factory_name"))));
            content.add(Field.createLabelValueLeftField((String)this.localeService.getLanguageValue(locale, "\u533a\u57df\u534a\u5f84"), (String)(StringUtil.valueOf(electronicFence.get("radius")) + "KM")));
            Action editAction = new Action();
            editAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7f16\u8f91"));
            editAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_ELECTRONIC_FENCE_DETAIL.name());
            editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            HashMap<String, String> editRawData = new HashMap<String, String>(4);
            editRawData.put("factory_id", StringUtil.valueOf(electronicFence.get("factory_id")));
            editRawData.put("factory_name", StringUtil.valueOf(electronicFence.get("factory_name")));
            editRawData.put("radius", StringUtil.valueOf(electronicFence.get("radius")));
            editRawData.put("start_flag", StringUtil.valueOf(electronicFence.get("start_flag")));
            editAction.setRawData(editRawData);
            map.put("cardAction", editAction);
        }
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value={"/vehicle/qrCode"})
    public ApiResponse<Map<String, Object>> driverQrCode(@RequestBody ApiRequest apiRequest) {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        String editId = apiRequest.getRawData().getString("editId") == null ? "" : apiRequest.getRawData().getString("editId");
        HashMap<String, String> params = new HashMap<String, String>(1);
        if (StringUtils.hasLength((String)editId)) {
            params.put("vehicle_info_id", editId);
        }
        List driverVehicles = this.digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        GraphicDisplay graphicDisplay = this.uiBotModelBuildZTBCarCodeStrategy.createGraphicDisplay(editId, driverVehicles);
        QrCode qrCode = this.uiBotModelBuildZTBCarCodeStrategy.createQrCode(apiRequest.getLocale(), editId, driverVehicles);
        resultData.put("carMessage", graphicDisplay);
        resultData.put("qrCode", qrCode);
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value={"/vehicle/show"})
    public ApiResponse<Map<String, Object>> driverCodeShow(@RequestBody ApiRequest apiRequest) {
        HashMap<String, Boolean> resultData = new HashMap<String, Boolean>();
        resultData.put("carCodeShow", false);
        resultData.put("vehicleShow", false);
        resultData.put("electronicFenceShow", false);
        return ApiResponse.buildOK().setData(resultData);
    }

    @PostMapping(value={"/task/card/float"})
    public ApiResponse<Map<String, Object>> getFloatTaskCard(@RequestBody ApiRequest apiRequest) throws IOException {
        HashMap<String, FloatingLayer> dataMap = new HashMap<String, FloatingLayer>();
        List myBacklogs = this.taskService.getZtbFloatTaskCard(apiRequest);
        if (CollectionUtils.isEmpty((Collection)myBacklogs)) {
            return ApiResponse.buildOK().setData(dataMap);
        }
        String tenantVersion = this.activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List pageTaskRelationList = this.activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);
        List departures = myBacklogs.stream().filter(r -> Integer.valueOf(0).equals(r.getTaskCardType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(departures)) {
            dataMap.put("action", null);
            dataMap.put("data", this.buildZtbDepartureTaskCardFloat(apiRequest.getLocale(), departures, 0, pageTaskRelationList));
            return ApiResponse.buildOK().setData(dataMap);
        }
        List transitList = myBacklogs.stream().filter(r -> Integer.valueOf(1).equals(r.getTaskCardType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(transitList)) {
            return ApiResponse.buildOK().setData(dataMap);
        }
        dataMap.put("action", null);
        dataMap.put("data", this.buildZtbDepartureTaskCardFloat(apiRequest.getLocale(), transitList, 1, pageTaskRelationList));
        return ApiResponse.buildOK().setData(dataMap);
    }

    @PostMapping(value={"/task/card/saveDriverPosition"})
    public ApiResponse<Map<String, Object>> saveDriverPosition(@RequestBody ApiRequest apiRequest) throws IOException {
        HashMap<String, Boolean> dataMap = new HashMap<String, Boolean>();
        ApiRawData rawData = apiRequest.getRawData();
        Map position = (Map)rawData.get((Object)"positionMap");
        this.digiwinEspProxyService.saveDriverPosition(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), position);
        long flag = this.taskService.getZtbTransportTaskCardCount(apiRequest);
        dataMap.put("positionFlag", flag > 0L);
        return ApiResponse.buildOK().setData(dataMap);
    }

    private Action<Map<String, Object>> buildZtbTaskDetailAction(ZTBTaskCard card, List<PageTaskRelation> pageTaskRelationList) {
        Action action = new Action();
        String jumpPageId = pageTaskRelationList.stream().filter(pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(card.getTmTaskId(), card.getTmActivityId())).map(PageTaskRelation::getPageId).findFirst().orElse("");
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setDataId(StringUtil.valueOf((Object)card.getBacklogId()));
        action.setJumpPageId(jumpPageId);
        HashMap<String, String> rawData = new HashMap<String, String>();
        rawData.put("digi-proxy-token", card.getProxyToken());
        action.setRawData(rawData);
        action.setExtraParameter((ApiExtraParameter)new TaskExtraParameter(card.getAppCode(), card.getTmActivityId(), card.getTmCategory(), card.getTmPattern(), card.getTmTaskId()));
        return action;
    }

    private FloatingLayer buildZtbDepartureTaskCardFloat(String locale, List<ZTBTaskCard> departures, int taskCardType, List<PageTaskRelation> pageTaskRelationList) {
        ArrayList cardList = new ArrayList();
        FloatingLayer floatingLayer = new FloatingLayer().setDefaultSelect(Integer.valueOf(0)).setShowLength(Integer.valueOf(3)).setShowCloseButton(Boolean.valueOf(true)).setCardList(cardList);
        departures.forEach(card -> {
            DigiwinTransportResponse transportMainInfo = card.getTransport();
            FloatingLayerData layerData = new FloatingLayerData().setSubject(this.localeService.getLanguageValue(locale, "\u5f85\u529e")).setTitle(card.getName()).setSubTitle(this.localeService.getLanguageValue(locale, "\u9879\u76ee") + "\uff1a" + card.getProjectName()).setTaskCardType(card.getTaskCardType());
            String[] address = this.getAddress(locale, card.getSummary());
            layerData.setStartAddress(address[0]).setEndAddress(address[1]).setSendOrReceiveTitle("").setCompleteAddress(transportMainInfo.getReceiptAddress()).setAddressMap(null).setMapIcon(Integer.valueOf(58948)).setContactName(transportMainInfo.getReceiverName());
            if (StringUtils.hasLength((String)transportMainInfo.getReceiverMobile())) {
                layerData.setMobile(transportMainInfo.getReceiverMobile());
                layerData.setPhoneIcon(Integer.valueOf(58908));
            } else {
                layerData.setMobile("-");
            }
            if (taskCardType == 0) {
                layerData.setMainButtonList(this.createStartTrainButton(locale, card)).setSubButtonList(null);
            } else {
                List list = this.createTransportButton(locale, card, pageTaskRelationList);
                layerData.setMainButtonList((List)list.get(0)).setSubButtonList((List)list.get(1));
            }
            layerData.setAction(this.buildZtbTaskDetailAction(card, pageTaskRelationList));
            cardList.add(layerData);
        });
        return floatingLayer;
    }

    private List<List<BottomButtonDigiwinAthena>> createTransportButton(String locale, ZTBTaskCard card, List<PageTaskRelation> pageTaskRelationList) {
        PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT.name());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotLayout layout = (UiBotLayout)uiBotModel.getLayout().stream().filter(o -> "BOTTOM_BUTTON".equals(o.getType())).collect(Collectors.toList()).get(0);
        List bottomButtonList = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)layout.getSchema())), BottomButtonDigiwinAthena.class);
        bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
            Action action;
            String buttonName = bottomButtonDigiwinAthena.getName();
            if (StringUtils.hasLength((String)buttonName)) {
                bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(locale, buttonName));
            }
            if ((action = bottomButtonDigiwinAthena.getAction()) != null) {
                if (action.getConfirmPop() != null && StringUtils.hasLength((String)action.getConfirmPop().getContent())) {
                    action.getConfirmPop().setContent(this.localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                } else if (StringUtils.hasLength((String)action.getJumpPageTitle())) {
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                }
            }
            Map<String, String> buttonRawData = new HashMap<String, String>();
            if (action.getRawData() != null) {
                buttonRawData = (Map)action.getRawData();
            }
            buttonRawData.put("task_no", card.getTaskNo());
            buttonRawData.put("transport_no", card.getTransportNo());
            buttonRawData.put("digi-proxy-token", card.getProxyToken());
            UiBotAction uiBotAction = this.getSubmitAction(card.getPcUiBotModel(), "submit-data");
            if (null != uiBotAction) {
                buttonRawData.put("action", (String)uiBotAction);
                HashMap<String, Object> data = new HashMap<String, Object>();
                String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                data.put(actionDataScheme, card.getPcUiBotModel().getPageData().get((Object)actionDataScheme));
                buttonRawData.put("data", (String)((Object)data));
            }
            action.setRawData(buttonRawData);
            List children = bottomButtonDigiwinAthena.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                for (BottomButtonDigiwinAthena button : children) {
                    Action action1;
                    if (StringUtils.hasLength((String)button.getName())) {
                        button.setName(this.localeService.getLanguageValue(locale, button.getName()));
                    }
                    if (StringUtils.hasLength((String)button.getSubName())) {
                        button.setSubName(this.localeService.getLanguageValue(locale, button.getSubName()));
                    }
                    if ((action1 = button.getAction()) == null) continue;
                    if (StringUtils.hasLength((String)action1.getJumpPageTitle())) {
                        action1.setJumpPageTitle(this.localeService.getLanguageValue(locale, action1.getJumpPageTitle()));
                    }
                    if (StringUtils.hasLength((String)action1.getToastMsg())) {
                        action1.setToastMsg(this.localeService.getLanguageValue(locale, action1.getToastMsg()));
                    }
                    Map<String, String> childButtonRawData = new HashMap<String, String>();
                    if (action1.getRawData() != null) {
                        childButtonRawData = (Map)action1.getRawData();
                    }
                    childButtonRawData.put("task_no", card.getTaskNo());
                    childButtonRawData.put("transport_no", card.getTransportNo());
                    childButtonRawData.put("digi-proxy-token", card.getProxyToken());
                    if (StrUtil.equals((CharSequence)StrUtil.toString(childButtonRawData.get("action_id")), (CharSequence)"receive_scan")) {
                        QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg("TRANSPORT_RECEIVE");
                        qrCodeContentMsg.put("transport_no", card.getTransportNo());
                        QrCode qrCode = QrCode.create((QrCodeContentMsg)qrCodeContentMsg, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u626b\u7801\u8fd0\u5355\u4e8c\u7ef4\u7801"));
                        childButtonRawData.put("qrCode", (String)qrCode);
                    }
                    if (null != uiBotAction) {
                        childButtonRawData.put("action", (String)uiBotAction);
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                        data.put(actionDataScheme, card.getPcUiBotModel().getPageData().get((Object)actionDataScheme));
                        childButtonRawData.put("data", (String)((Object)data));
                    }
                    action1.setRawData(childButtonRawData);
                    if (!StringUtils.hasLength((String)action1.getRequestUrl())) continue;
                    action1.setRequestUrl(AppContext.getBaseUrl() + action1.getRequestUrl());
                }
            }
        });
        BottomButtonDigiwinAthena mainButton = new BottomButtonDigiwinAthena();
        mainButton.setName(this.localeService.getLanguageValue(locale, "\u5230\u8fbe"));
        mainButton.setType(BottomButtonStyleEnum.STRESS.getValue());
        mainButton.setAction(this.buildZtbTaskDetailAction(card, pageTaskRelationList));
        List<BottomButtonDigiwinAthena> mainButtons = Collections.singletonList(mainButton);
        List subButtons = bottomButtonList.stream().filter(button -> {
            Map rawData = (Map)button.getAction().getRawData();
            return "transfer".equals(StringUtil.valueOf(rawData.get("action_id"))) || "abnormal".equals(StringUtil.valueOf(rawData.get("action_id")));
        }).collect(Collectors.toList());
        ArrayList<List<BottomButtonDigiwinAthena>> list = new ArrayList<List<BottomButtonDigiwinAthena>>();
        list.add(mainButtons);
        list.add(subButtons);
        return list;
    }

    private List<BottomButtonDigiwinAthena> createStartTrainButton(String locale, ZTBTaskCard card) {
        PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_DEPARTURE.name());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotLayout layout = (UiBotLayout)uiBotModel.getLayout().stream().filter(o -> "BOTTOM_BUTTON".equals(o.getType())).collect(Collectors.toList()).get(0);
        List bottomButtonList = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)layout.getSchema())), BottomButtonDigiwinAthena.class);
        bottomButtonList.forEach(bottomButton -> {
            bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
            bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            Action action = bottomButton.getAction();
            if (action.getConfirmPop() != null) {
                ConfirmPop confirmPop = action.getConfirmPop();
                confirmPop.setContent(this.localeService.getLanguageValue(locale, confirmPop.getContent()));
            }
            action.setType(ActionTypeEnum.CALL_API.getValue());
            HashMap<String, Object> buttonRawData = new HashMap<String, Object>();
            buttonRawData.put("task_no", card.getTaskNo());
            buttonRawData.put("transport_no", card.getTransportNo());
            buttonRawData.put("biz_id", "ZTB");
            buttonRawData.put("digi-proxy-token", card.getProxyToken());
            buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_DEPARTURE.toString());
            UiBotAction uiBotAction = this.getSubmitAction(card.getPcUiBotModel(), "submit-data");
            if (null != uiBotAction) {
                buttonRawData.put("action", uiBotAction);
                HashMap<String, Object> data = new HashMap<String, Object>();
                String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                data.put(actionDataScheme, card.getPcUiBotModel().getPageData().get((Object)actionDataScheme));
                buttonRawData.put("data", data);
            }
            action.setRawData(buttonRawData);
            bottomButton.setAction(action);
        });
        return bottomButtonList;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<UiBotAction>();
        block0: for (UiBotLayout layout : layoutList) {
            List actions = layout.getActions();
            if (CollectionUtils.isEmpty((Collection)actions)) continue;
            for (UiBotAction action : actions) {
                if (!actionId.equalsIgnoreCase(action.getActionId())) continue;
                uiBotAction.set(action);
                break block0;
            }
        }
        return (UiBotAction)uiBotAction.get();
    }

    private String[] getAddress(String locale, String summary) {
        String[] address = new String[2];
        if (!StringUtils.hasLength((String)summary)) {
            return address;
        }
        String chStr = "\u7269\u6d41\u5730\u5740";
        String twStr = this.localeService.getLanguageValue(locale, chStr);
        String logistics = Arrays.stream(summary.split("<br>")).filter(s -> s.contains(chStr) || s.contains(twStr)).findFirst().orElse("");
        if (!StringUtils.hasLength((String)logistics)) {
            return address;
        }
        String[] split = logistics.split("\uff1a");
        if (split.length == 1) {
            return address;
        }
        String[] split1 = split[1].split("->");
        if (split1.length == 1) {
            return address;
        }
        return new String[]{split1[0].trim(), split1[1].trim()};
    }
}

