/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBCarCodeStrategy")
public class UiBotModelBuildZTBCarCodeStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        String editId = apiRequest.getRawData().getString("editId") == null ? "" : apiRequest.getRawData().getString("editId");
        HashMap<String, String> params = new HashMap<String, String>(1);
        if (StringUtils.hasLength((String)editId)) {
            params.put("vehicle_info_id", editId);
        }
        List driverVehicles = this.digiwinEspProxyService.getDriverVehicle(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        for (UiBotLayout layout : layoutList) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "GRAPHIC_DISPLAY": {
                    pageData.put((Object)schema, (Object)this.createGraphicDisplay(editId, driverVehicles));
                    break;
                }
                case "QR_CODE": {
                    pageData.put((Object)schema, (Object)this.createQrCode(apiRequest.getLocale(), editId, driverVehicles));
                    break;
                }
            }
        }
        return uiBotModel;
    }

    public GraphicDisplay createGraphicDisplay(String editId, List<Map<String, Object>> driverVehicles) {
        if (CollectionUtils.isEmpty(driverVehicles)) {
            return new GraphicDisplay();
        }
        Map<String, Object> vehicle = StringUtils.hasLength((String)editId) ? driverVehicles.get(0) : driverVehicles.stream().filter(v -> "true".equals(StringUtil.valueOf(v.get("is_default")))).findFirst().orElse(driverVehicles.get(0));
        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(StringUtil.valueOf((Object)vehicle.get("license_plate_no")));
        graphicDisplay.setStyle(Integer.valueOf(2));
        String picFileId = StringUtil.valueOf((Object)vehicle.get("pic_file_id"));
        if (StringUtils.hasLength((String)picFileId)) {
            ShareInfo shareInfo = this.digiwinDmcProxyService.shareFile(picFileId, "srm-loading");
            graphicDisplay.setPics(Collections.singletonList(new Pic().setPicUrl(shareInfo.getUrl())));
        }
        return graphicDisplay;
    }

    public QrCode createQrCode(String locale, String editId, List<Map<String, Object>> driverVehicles) {
        if (CollectionUtils.isEmpty(driverVehicles)) {
            return new QrCode();
        }
        QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg("DRIVER_CODE");
        if (StringUtils.hasLength((String)editId)) {
            qrCodeContentMsg.put("vehicle_info_id", StringUtil.valueOf((Object)driverVehicles.get(0).get("vehicle_info_id")));
        } else {
            Map<String, Object> map = driverVehicles.stream().filter(vehicle -> "true".equals(StringUtil.valueOf(vehicle.get("is_default")))).findFirst().orElse(driverVehicles.get(0));
            qrCodeContentMsg.put("vehicle_info_id", StringUtil.valueOf((Object)map.get("vehicle_info_id")));
        }
        return QrCode.create((QrCodeContentMsg)qrCodeContentMsg, (String)this.localeService.getLanguageValue(locale, "\u626b\u4e00\u626b\u4e0a\u9762\u7684\u4e8c\u7ef4\u7801\u56fe\u6848\uff0c\u6d3e\u5355\u7ed9\u6211"));
    }
}

