/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildZTBCarListStrategy")
public class UiBotModelBuildZTBCarListStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.doActually(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "BLANK_AREA": {
                    BlankArea blankArea = (BlankArea)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), BlankArea.class);
                    pageData.put((Object)schema, (Object)blankArea);
                    break;
                }
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MultiFunctionList.class);
                    pageData.put((Object)schema, (Object)multiFunctionList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), BottomButtonList.class);
                    bottomButtonList.initSetting(this.localeService, locale);
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

