/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBModificationReceiptScheduleStrategy")
public class UiBotModelBuildZTBModificationReceiptScheduleStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBModificationReceiptScheduleStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildModificationReceiptSchedule");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        ApiRawData apiRawData;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData2 = apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        String transportNo = "";
        String taskNo = "";
        String deliveryNo = "";
        List deliveryDetailList = (List)pcUiBotModel.getPageData().get((Object)"cargo_information");
        if (!CollectionUtils.isEmpty((Collection)deliveryDetailList)) {
            taskNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("task_no"));
            deliveryNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("delivery_no"));
            transportNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("transport_no"));
        }
        Map transportMainInfo = this.digiwinEspProxyService.getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        Map transportVehicleInfo = this.digiwinEspProxyService.getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "MESSAGE_BAR": {
                    MessageBar messageBar = (MessageBar)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MessageBar.class);
                    messageBar.setContent(this.localeService.getLanguageValue(locale, messageBar.getContent()));
                    pageData.put((Object)schema, (Object)messageBar);
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Card.class);
                    if ("carMessage".equalsIgnoreCase(schema) || "driverMeaasge".equalsIgnoreCase(schema)) {
                        card.detailMessage(transportVehicleInfo, card, this.localeService, locale);
                    }
                    pageData.put((Object)schema, (Object)card);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiboModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), UiBotModel.class);
                    if ("logisticsMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, (DigiwinTransportResponse)JsonUtil.objectToJavaObject((Object)transportMainInfo, DigiwinTransportResponse.class), customUiboModel, Boolean.valueOf(false));
                    } else if ("receiptPreparation".equalsIgnoreCase(schema)) {
                        CustomGroupContent content;
                        if (StringUtils.hasLength((String)((String)transportMainInfo.get("unloader_id")))) {
                            customGroup.setName(this.localeService.getLanguageValue(locale, customUiboModel.getName()));
                            customGroup.buildReceiptPreparation(customUiboModel, this.localeService, this.digiwinEspProxyService, apiRequest, transportMainInfo, transportNo, taskNo);
                            content = new CustomGroupContent();
                            content.setLayout(customUiboModel.getLayout());
                            content.setPageData(customUiboModel.getPageData());
                            customGroup.setContent(content);
                            customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                        } else {
                            content = new CustomGroupContent();
                            customGroup.setContent(content);
                        }
                    } else if ("platformMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildPlatformMessage(transportMainInfo, customUiboModel, apiRequest, this.localeService, deliveryNo);
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)buttonName)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        HashMap<String, Object> buttonRawData = new HashMap<String, Object>(3);
                        Action action = bottomButtonDigiwinAthena.getAction();
                        ConfirmPop confirmPop = action.getConfirmPop();
                        if (confirmPop != null) {
                            confirmPop.setContent(this.localeService.getLanguageValue(locale, confirmPop.getContent()));
                            buttonRawData.put("isCancel", true);
                        } else {
                            buttonRawData.put("isCancel", false);
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("page_id", apiRequest.getPageId());
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction((UiBotModel)pcUiBotModel, (String)"submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            HashMap<String, Object> data = new HashMap<String, Object>(1);
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

