/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbTransportReceiptStatusCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBReceiptConfirmationStrategy")
public class UiBotModelBuildZTBReceiptConfirmationStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBReceiptConfirmationStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build ReceiptConfirmation");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        ApiRawData apiRawData;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData2 = apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength((String)digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", (Object)digiwinAtmcBacklogDetail.getProxyToken());
        }
        Boolean hasReject = false;
        if (apiRawData.get((Object)"hasReject") != null && ((Boolean)apiRawData.get((Object)"hasReject")).booleanValue()) {
            hasReject = true;
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List buttons = uiBotModel.getAppbarButtonList();
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", (String)digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign((String)(digiwinAtmcBacklogDetail.getId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"TASK", (Integer)59096));
        }
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        String transportNo = "";
        String taskNo = "";
        List deliveryDetailList = (List)pcUiBotModel.getPageData().get((Object)"cargo_information");
        if (!CollectionUtils.isEmpty((Collection)deliveryDetailList)) {
            taskNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("task_no"));
            transportNo = String.valueOf(((Map)deliveryDetailList.get(0)).get("transport_no"));
        }
        Boolean hasNoUnLoding = false;
        Map transportMainInfo = this.digiwinEspProxyService.getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        Map transportVehicleInfo = this.digiwinEspProxyService.getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)locale, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail);
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "GRAPHIC_DISPLAY": {
                    pageData.put((Object)layout.getSchema(), (Object)GraphicDisplay.createNoSubTitle((ZTBDriverVehicle)((ZTBDriverVehicle)JsonUtil.objectToJavaObject((Object)transportVehicleInfo, ZTBDriverVehicle.class)), (Integer)1, (DigiwinDmcProxyService)this.digiwinDmcProxyService));
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Card.class);
                    if ("platformMessage".equalsIgnoreCase(schema)) {
                        card.detailPlatformMessage(transportMainInfo, card, this.localeService, locale);
                    }
                    pageData.put((Object)schema, (Object)card);
                    break;
                }
                case "CUSTOM_TABS": {
                    List counts = this.digiwinEspProxyService.getTransportReceiptStatusCount(iamUserToken, tenantId, locale, transportNo);
                    HashMap cargoInfoMaps = new HashMap(counts.size());
                    for (ZtbTransportReceiptStatusCount count : counts) {
                        HashMap<String, String> params = new HashMap<String, String>(2);
                        params.put("transport_no", transportNo);
                        params.put("receipt_status", count.getReceiptStatus());
                        List cargoUnloadings = this.digiwinEspProxyService.getTransportReceiptItemInfo(iamUserToken, tenantId, locale, params);
                        if (CollectionUtils.isEmpty((Collection)cargoUnloadings)) {
                            if ("0".equalsIgnoreCase(count.getReceiptStatus())) {
                                hasNoUnLoding = true;
                            }
                            cargoUnloadings = Collections.emptyList();
                        }
                        cargoInfoMaps.put(count.getReceiptStatus(), cargoUnloadings);
                    }
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomTabs.class);
                    customTabs.detailMessage(customTabs, cargoInfoMaps, counts, this.localeService, locale, hasReject);
                    pageData.put((Object)schema, (Object)customTabs);
                    break;
                }
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), MultiFunctionList.class);
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("transport_no", (Object)transportNo);
                    rawData.put("type", (Object)"isTransport");
                    multiFunctionList.setRawData(rawData);
                    pageData.put((Object)schema, (Object)multiFunctionList);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    if (hasNoUnLoding.booleanValue()) {
                        pageData.remove((Object)schema);
                        break;
                    }
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    HashMap buttonRawData = new HashMap(6);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        ConfirmPop confirmPop;
                        Action action;
                        String jumpPageTitle;
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)buttonName)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        if (StringUtils.hasLength((String)(jumpPageTitle = (action = bottomButtonDigiwinAthena.getAction()).getJumpPageTitle()))) {
                            action.setJumpPageTitle(this.localeService.getLanguageValue(locale, jumpPageTitle));
                        }
                        if ((confirmPop = action.getConfirmPop()) != null) {
                            confirmPop.setContent(this.localeService.getLanguageValue(locale, confirmPop.getContent()));
                            buttonRawData.put("page_id", action.getJumpPageId());
                        } else {
                            buttonRawData.put("page_id", apiRequest.getPageId());
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction((UiBotModel)pcUiBotModel, (String)"submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData((Object)buttonRawData);
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

