/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBScanReceiveOrderStrategy")
public class UiBotModelBuildZTBScanReceiveOrderStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBScanReceiveOrderStrategy.class);
    @Autowired
    private ZhilinkService zhilinkService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBScanReceiveOrder");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        String taskNo = (String)apiRequest.getRawData().get((Object)"task_no");
        String transportNo = (String)apiRequest.getRawData().get((Object)"transport_no");
        AsnHeaderResponse asnHeaderResponse = this.zhilinkService.getAsnHeaderByTaskNo(taskNo, apiRequest.getTenantId(), locale, apiRequest.getIamUserToken());
        stopWatch.start("Build ApcAbnormalReport Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    TitleBody titleBody = TitleBody.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u626b\u7801\u63a5\u5355"), null, new ArrayList());
                    pageData.put((Object)schema, (Object)titleBody);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_ONE".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, asnHeaderResponse, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class), Boolean.valueOf(false));
                    } else if ("CUSTOM_GROUP_TWO".equalsIgnoreCase(schema)) {
                        customGroup = this.buildBasicInfoGroup(locale, asnHeaderResponse, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class));
                    } else if ("CUSTOM_GROUP_THREE".equalsIgnoreCase(schema)) {
                        customGroup = this.buildDriverMessageGroup(locale, asnHeaderResponse, (UiBotModel)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), UiBotModel.class));
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    BottomButtonDigiwinAthena bottomButton = new BottomButtonDigiwinAthena();
                    bottomButton.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4"));
                    bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                    Action action = new Action();
                    action.setType(ActionTypeEnum.CALL_API.getValue());
                    HashMap<String, Object> buttonRawData = new HashMap<String, Object>();
                    buttonRawData.put("task_no", taskNo);
                    if (StringUtils.hasLength((String)transportNo)) {
                        buttonRawData.put("transport_no", transportNo);
                    }
                    buttonRawData.put("biz_id", "ZTB");
                    buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_SCAN_RECEIVE_ORDER.toString());
                    buttonRawData.put("action", apiRequest.getRawData().get((Object)"action"));
                    buttonRawData.put("data", apiRequest.getRawData().get((Object)"data"));
                    action.setRawData(buttonRawData);
                    bottomButton.setAction(action);
                    bottomButtonList.add(bottomButton);
                    pageData.put((Object)schema, bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        uiBotModel.setPageData(pageData);
        return uiBotModel;
    }

    private CustomGroup buildBasicInfoGroup(String locale, AsnHeaderResponse asnHeaderResponse, UiBotModel basicInfoUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List basicInfoLayouts = basicInfoUiBotModel.getLayout();
        UiBotPageData pageData = basicInfoUiBotModel.getPageData();
        UiBotPageData basicInfoPageData = new UiBotPageData();
        for (UiBotLayout basicInfoLayout : basicInfoLayouts) {
            String basicInfoSchema = basicInfoLayout.getSchema();
            Map schemaPageData = (Map)pageData.get((Object)basicInfoSchema);
            switch (basicInfoLayout.getType()) {
                case "FIELD": {
                    Field basicInfoField = new Field();
                    String value = "-";
                    if ("plan_arrival_date".equalsIgnoreCase(basicInfoSchema)) {
                        value = asnHeaderResponse.getPlanArrivalDate() != null ? String.valueOf(asnHeaderResponse.getPlanArrivalDate()) : value;
                        basicInfoField = Field.create((String)((String)basicInfoLayout.getmLabelText().get(locale)), (String)"LABEL", (String)value, (String)basicInfoSchema, (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue());
                    }
                    basicInfoPageData.put((Object)basicInfoSchema, (Object)basicInfoField);
                    break;
                }
            }
        }
        CustomGroupContent basicInfoContent = new CustomGroupContent();
        basicInfoContent.setLayout(basicInfoLayouts);
        basicInfoContent.setPageData(basicInfoPageData);
        customGroup.setContent(basicInfoContent);
        customGroup.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u65f6\u6548\u4fe1\u606f"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        return customGroup;
    }

    private CustomGroup buildDriverMessageGroup(String locale, AsnHeaderResponse asnHeaderResponse, UiBotModel driverMessageUiBotModel) {
        CustomGroup customGroup = new CustomGroup();
        List driverMessageLayouts = driverMessageUiBotModel.getLayout();
        UiBotPageData driverMessagePageData = new UiBotPageData();
        for (UiBotLayout driverMessageLayout : driverMessageLayouts) {
            String driverMessageSchema = driverMessageLayout.getSchema();
            switch (driverMessageLayout.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect driverMessage = this.zhilinkService.getDriverVehicle(driverMessageLayout, driverMessageUiBotModel.getPageData(), locale);
                    driverMessagePageData.put((Object)driverMessageSchema, (Object)driverMessage);
                    break;
                }
            }
        }
        CustomGroupContent driverMessageContent = new CustomGroupContent();
        driverMessageContent.setLayout(driverMessageLayouts);
        driverMessageContent.setPageData(driverMessagePageData);
        customGroup.setContent(driverMessageContent);
        return customGroup;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

