/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.recommend;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceDirectionEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceTitleStyleEnum;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.recommend.RecommendService;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendMobileConfig;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRule;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleParamsTypeEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleService;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsEnableModule;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsParam;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="recommendService")
public class RecommendServiceImpl
implements RecommendService {
    private static final Logger log = LoggerFactory.getLogger(RecommendServiceImpl.class);
    private static final String DASHBOARD_VERSION_V2 = "v2";
    @Autowired
    private RecommendRuleService recommendRuleService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private AppEntranceRecordService appEntranceRecordService;
    @Autowired
    private DashBoardService dshboardService;
    @Autowired
    private LocaleService localeService;

    public List<AppFunctionTouchable> getRecommendAppList(ApiRequest apiRequest) {
        List appModuleItemList;
        List launchableProjectAppList;
        String userId = apiRequest.getUserId();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        List<Object> appList = new ArrayList<AppFunctionTouchable>();
        boolean isv2 = Objects.equals(DASHBOARD_VERSION_V2, apiRequest.getDashboardVersion());
        DigiwinIamAnalyzedToken analyzedToken = this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List goodsCodes = this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (CollectionUtils.isEmpty((Collection)goodsCodes)) {
            return Collections.emptyList();
        }
        List commonAppIdList = this.appEntranceRecordService.getAppIdListByUserId(userId, analyzedToken.getTenantId());
        if (CollectionUtils.isEmpty((Collection)commonAppIdList)) {
            return appList;
        }
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(RecommendRuleCategoryEnum.GUESS_WHAT_YOU_WANT_TO_DO.getValue());
        list.add(RecommendRuleCategoryEnum.APP_SERVER_ENTRANCE.getValue());
        List recommendRules = this.recommendRuleService.findRuleByCategoryList(list);
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream().filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue())).sorted(Comparator.comparingInt(RecommendRule::getOrder)).collect(Collectors.toList());
        ArrayList notVerifyAppCodeList = new ArrayList();
        ArrayList hasRecommendPermissionAppList = new ArrayList();
        purchasedGoodsRecommendRules.forEach(pgrr -> {
            PurchasedGoodsParam param = (PurchasedGoodsParam)JsonUtil.objectToJavaObject((Object)pgrr.getParams(), PurchasedGoodsParam.class);
            if (null == param) {
                return;
            }
            String pgrrGoodsCode = param.getGoodsCode();
            boolean goodsPurchasedInFact = goodsCodes.stream().anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode) || "Athena".equalsIgnoreCase(pgrrGoodsCode));
            if (goodsPurchasedInFact && null != param.getEnableModules()) {
                param.getEnableModules().forEach(module -> {
                    module.convert();
                    Boolean valid = Optional.ofNullable(module.getValid()).orElse(false);
                    Boolean verify = Optional.ofNullable(module.getVerify()).orElse(true);
                    if (!valid.booleanValue()) {
                        return;
                    }
                    String moduleId = module.getModuleId();
                    if (isv2 && "BASIC_DATA_ENTRANCE".equals(moduleId)) {
                        return;
                    }
                    if ("Athena_LAUNCH_PROJECT".equals(moduleId)) {
                        return;
                    }
                    boolean moduleEnableInFact = true;
                    if (verify.booleanValue()) {
                        if ("APC".equals(pgrrGoodsCode)) {
                            if ("PERSONNEL_ONLINE".equals(module.getModuleId()) || "STAND_PRODUCTION_PROGRESS".equals(module.getModuleId())) {
                                moduleEnableInFact = this.isMatchWorkId(userId, pgrrGoodsCode, iamUserToken, module);
                            }
                        } else {
                            moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId, iamUserToken);
                        }
                    } else {
                        notVerifyAppCodeList.add(pgrrGoodsCode + "_" + moduleId);
                    }
                    if (moduleEnableInFact) {
                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
                        mobileConfig.initSetting(locale);
                        String requestUrl = mobileConfig.getAction().getRequestUrl();
                        if ("ChatFile".equalsIgnoreCase(mobileConfig.getName()) || "trmnana".equals(param.getGoodsCode())) {
                            requestUrl = requestUrl.replace("{tenantId}", analyzedToken.getTenantId()).replace("{tenantSid}", String.valueOf(analyzedToken.getTenantSid())).replace("{tenantName}", analyzedToken.getTenantName()).replace("{userId}", analyzedToken.getId()).replace("{userName}", analyzedToken.getName()).replace("{token}", iamUserToken).replace("{locale}", locale);
                        }
                        if (StringUtils.hasLength((String)requestUrl) && !requestUrl.startsWith("http")) {
                            requestUrl = AppContext.getBaseUrl() + requestUrl;
                        }
                        AppFunctionTouchable appTouchable = AppFunctionTouchable.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)mobileConfig.getName()), (Integer)mobileConfig.getIconData(), (String)mobileConfig.getIconColor(), (String)mobileConfig.getAction().getJumpPageId(), (String)mobileConfig.getAction().getJumpPageTitle(), (Integer)mobileConfig.getAction().getType(), (String)requestUrl, (String)mobileConfig.getImage(), (String)mobileConfig.getImageUrl());
                        AppEntranceAccessRecord accessRecord = mobileConfig.getAccessRecord();
                        if (accessRecord != null && accessRecord.getSendRecord() != null && accessRecord.getSendRecord().booleanValue()) {
                            accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
                            appTouchable.setAccessRecord(accessRecord);
                        }
                        appTouchable.setId(pgrrGoodsCode + "_" + moduleId);
                        hasRecommendPermissionAppList.add(appTouchable);
                    }
                });
            }
        });
        List copyCommonAppIdList = (List)JsonUtil.objectToJavaObject((Object)commonAppIdList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (!CollectionUtils.isEmpty(hasRecommendPermissionAppList)) {
            Map<String, AppFunctionTouchable> hasRecommendPermissionAppListMapById = hasRecommendPermissionAppList.stream().collect(Collectors.toMap(Button::getId, app -> app, (a, b) -> a));
            List newRecommendAppList = commonAppIdList.stream().filter(appId -> hasRecommendPermissionAppListMapById.containsKey(appId)).map(appId -> (AppFunctionTouchable)hasRecommendPermissionAppListMapById.get(appId)).collect(Collectors.toList());
            appList.addAll(newRecommendAppList);
            commonAppIdList.removeAll(hasRecommendPermissionAppListMapById.keySet());
        }
        if (!CollectionUtils.isEmpty((Collection)commonAppIdList) && !CollectionUtils.isEmpty((Collection)(launchableProjectAppList = this.projectService.getLaunchableProjectAppList(iamUserToken, userId, locale)))) {
            Map<String, AppFunctionTouchable> launchableProjectAppListMapById = launchableProjectAppList.stream().collect(Collectors.toMap(Button::getId, app -> app, (a, b) -> a));
            List newLaunchableProjectAppList = commonAppIdList.stream().filter(appId -> launchableProjectAppListMapById.containsKey(appId)).map(appId -> (AppFunctionTouchable)launchableProjectAppListMapById.get(appId)).collect(Collectors.toList());
            appList.addAll(newLaunchableProjectAppList);
            commonAppIdList.removeAll(launchableProjectAppListMapById.keySet());
        }
        if (!CollectionUtils.isEmpty((Collection)commonAppIdList) && isv2 && !CollectionUtils.isEmpty((Collection)(appModuleItemList = this.dshboardService.getDataEntryModuleList(apiRequest.getClientId(), iamUserToken, analyzedToken.getTenantId(), locale)))) {
            List dataEntryAppList = (List)JsonUtil.objectToJavaObject((Object)appModuleItemList, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map<String, AppFunctionTouchable> dataEntryAppMapById = dataEntryAppList.stream().collect(Collectors.toMap(Button::getId, app -> app, (a, b) -> a));
            List newDataEntryAppList = commonAppIdList.stream().filter(appId -> dataEntryAppMapById.containsKey(appId)).map(appId -> (AppFunctionTouchable)dataEntryAppMapById.get(appId)).collect(Collectors.toList());
            appList.addAll(newDataEntryAppList);
        }
        if ((appList = appList.stream().sorted(Comparator.comparingInt(item -> copyCommonAppIdList.indexOf(item.getId()))).collect(Collectors.toList())).size() > 4) {
            appList = appList.subList(0, 4);
        }
        return appList;
    }

    public List<AppEntrance> getAllAppEntrance(String iamUserToken, String userId, String locale) {
        DigiwinIamAnalyzedToken analyzedToken = this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List goodsCodes = this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (goodsCodes.isEmpty()) {
            return Collections.emptyList();
        }
        List recommendRules = this.recommendRuleService.findRuleByCategory(RecommendRuleCategoryEnum.APP_SERVER_ENTRANCE.getValue());
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream().filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue())).sorted(Comparator.comparingInt(RecommendRule::getOrder)).collect(Collectors.toList());
        AppEntrance appEntrance = new AppEntrance();
        ArrayList appList = new ArrayList();
        purchasedGoodsRecommendRules.forEach(pgrr -> {
            PurchasedGoodsParam param = (PurchasedGoodsParam)JsonUtil.objectToJavaObject((Object)pgrr.getParams(), PurchasedGoodsParam.class);
            if (null == param) {
                return;
            }
            appEntrance.setTitle(this.localeService.getLanguageValue(locale, param.getGoodsDisplayName()));
            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
            appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
            String pgrrGoodsCode = param.getGoodsCode();
            boolean goodsPurchasedInFact = goodsCodes.stream().anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode) || "Athena".equalsIgnoreCase(pgrrGoodsCode));
            if (goodsPurchasedInFact && null != param.getEnableModules()) {
                param.getEnableModules().forEach(module -> {
                    module.convert();
                    Boolean valid = Optional.ofNullable(module.getValid()).orElse(false);
                    Boolean verify = Optional.ofNullable(module.getVerify()).orElse(true);
                    if (!valid.booleanValue()) {
                        return;
                    }
                    String moduleId = module.getModuleId();
                    boolean moduleEnableInFact = true;
                    if (verify.booleanValue()) {
                        if ("APC".equals(pgrrGoodsCode)) {
                            if ("PERSONNEL_ONLINE".equals(module.getModuleId()) || "STAND_PRODUCTION_PROGRESS".equals(module.getModuleId())) {
                                moduleEnableInFact = this.isMatchWorkId(userId, pgrrGoodsCode, iamUserToken, module);
                            }
                        } else {
                            moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId, iamUserToken);
                        }
                    }
                    if (moduleEnableInFact) {
                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
                        mobileConfig.initSetting(locale);
                        String requestUrl = mobileConfig.getAction().getRequestUrl();
                        if ("ChatFile".equalsIgnoreCase(mobileConfig.getName()) || "trmnana".equals(param.getGoodsCode())) {
                            requestUrl = requestUrl.replace("{tenantId}", analyzedToken.getTenantId()).replace("{tenantSid}", String.valueOf(analyzedToken.getTenantSid())).replace("{tenantName}", analyzedToken.getTenantName()).replace("{userId}", analyzedToken.getId()).replace("{userName}", analyzedToken.getName()).replace("{token}", iamUserToken).replace("{locale}", locale);
                        }
                        if (StringUtils.hasLength((String)requestUrl) && !requestUrl.startsWith("http")) {
                            requestUrl = AppContext.getBaseUrl() + requestUrl;
                        }
                        AppFunctionTouchable appTouchable = AppFunctionTouchable.create((String)mobileConfig.getName(), (Integer)mobileConfig.getIconData(), (String)mobileConfig.getIconColor(), (String)mobileConfig.getAction().getJumpPageId(), (String)mobileConfig.getAction().getJumpPageTitle(), (Integer)mobileConfig.getAction().getType(), (String)requestUrl, (String)mobileConfig.getImage(), (String)mobileConfig.getImageUrl());
                        appTouchable.getAction().setDataId(mobileConfig.getAction().getDataId());
                        AppEntranceAccessRecord accessRecord = mobileConfig.getAccessRecord();
                        if (accessRecord != null && accessRecord.getSendRecord() != null && accessRecord.getSendRecord().booleanValue()) {
                            accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
                            appTouchable.setAccessRecord(accessRecord);
                        }
                        appTouchable.setId(pgrrGoodsCode + "_" + moduleId);
                        appList.add(appTouchable);
                    }
                });
            }
        });
        if (CollectionUtils.isEmpty(appList)) {
            return Collections.emptyList();
        }
        appEntrance.setAppList(appList);
        return Collections.singletonList(appEntrance);
    }

    private boolean isMatchWorkId(String userId, String pgrrGoodsCode, String iamUserToken, PurchasedGoodsEnableModule module) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + pgrrGoodsCode);
        DigiwinIamUserAuthInfo userPermission = this.digiwinIamProxyService.getUserPermissionFunctional(iamUserToken, params);
        Boolean isMatchWorkId = false;
        Optional<List> optional = Optional.ofNullable(userPermission).map(DigiwinIamUserAuthInfo::getResult).map(DigiwinIamUserAuthResult::getPermissions);
        if (optional.isPresent() && userPermission != null && userPermission.getResult() != null) {
            isMatchWorkId = userPermission.getResult().getPermissions().stream().anyMatch(e -> e.getId().equals(module.getWorkId()) && "allow".equalsIgnoreCase(e.getEffect()));
        }
        return isMatchWorkId;
    }

    private List<RecommendRule> getRecommendRuleList(String iamUserToken) {
        DigiwinIamAnalyzedToken analyzedToken = this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List goodsCodes = this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (goodsCodes.isEmpty()) {
            return Collections.emptyList();
        }
        List recommendRules = this.recommendRuleService.findRuleByCategory(RecommendRuleCategoryEnum.GUESS_WHAT_YOU_WANT_TO_DO.getValue());
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream().filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue())).collect(Collectors.toList());
        return purchasedGoodsRecommendRules;
    }
}

