/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.sso.service;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigIwinCamResponse;
import com.digiwin.mobile.mobileuibot.proxy.cam.service.DigIwinCamProxyService;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoChannelSourceEnum;
import com.digiwin.mobile.mobileuibot.sso.model.ThirdPartyForParticipationRequestModel;
import com.digiwin.mobile.mobileuibot.sso.service.SsoService;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NanaSsoServiceImpl
implements SsoService {
    private static final Logger log = LoggerFactory.getLogger(NanaSsoServiceImpl.class);
    private static final String KEY = "550F743242C481975EDBDEDEE3498BAA";
    private static final String LINE_ACCESS_URL = "https://access.line.me/oauth2/v2.1/authorize?response_type=code&client_id={0}&scope=profile%20openid%20email&state={1}&redirect_uri={2}";
    @Autowired
    private DigIwinCamProxyService digIwinCamProxyService;

    public String getNanaLineRedirectUri() {
        return AppContext.getApiUrlSetting().getBaseHost() + "/mobile/v1/sso/line?channelSource=nana&sourceType=Line";
    }

    public String getSsoChannelSource() {
        return SsoChannelSourceEnum.NANA.getChannelSource();
    }

    public ApiResponse getSsoPcParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw) throws IOException {
        String url;
        String param = null;
        if (StringUtils.isBlank((CharSequence)model.getCode())) {
            String state;
            String redirect_uri = URLEncoder.encode(this.getNanaLineRedirectUri(), CharsetUtil.CHARSET_UTF_8.toString());
            if (StringUtils.isNotBlank((CharSequence)model.getQueryString())) {
                param = URLDecoder.decode(model.getQueryString(), CharsetUtil.CHARSET_UTF_8.toString());
                state = this.encrypt(param);
            } else {
                state = UUIDUtil.getUuid();
            }
            url = MessageFormat.format(LINE_ACCESS_URL, AppContext.getApiUrlSetting().getNanaLineClientId(), state, redirect_uri);
        } else {
            if (StringUtils.isNotBlank((CharSequence)model.getState())) {
                param = this.decrypt(model.getState());
            }
            Map lineCamInfo = this.queryLineCamInfo(model);
            String token = MapUtils.getString((Map)lineCamInfo, (Object)"token");
            String verifyUserId = MapUtils.getString((Map)lineCamInfo, (Object)"verifyUserId");
            url = StringUtils.isNotBlank((CharSequence)token) ? HttpUtil.urlWithForm((String)(AppContext.getApiUrlSetting().getAniaWebUrl() + "?token=" + token), (String)param, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false) : (StringUtils.isNotBlank((CharSequence)verifyUserId) ? HttpUtil.urlWithForm((String)(AppContext.getApiUrlSetting().getAniaWebUrl() + "/login/line-login?verifyUserId=" + verifyUserId), (String)param, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false) : HttpUtil.urlWithForm((String)(AppContext.getApiUrlSetting().getAniaWebUrl() + "/login/line-login"), (String)param, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false));
        }
        ApiResponse apiResponse = ApiResponse.buildOK().setData((Object)url);
        if (url != null) {
            response.sendRedirect(url);
        }
        return apiResponse;
    }

    private String encrypt(String param) {
        try {
            return AESUtil.encrypt((String)KEY, (String)param);
        }
        catch (Exception ex) {
            log.error("encrypt is error", (Throwable)ex);
            return UUIDUtil.getUuid();
        }
    }

    private String decrypt(String state) {
        try {
            return AESUtil.decrypt((String)KEY, (String)state);
        }
        catch (Exception ex) {
            log.error("decrypt is error", (Throwable)ex);
            return null;
        }
    }

    public ApiResponse getSsoMobileParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw) throws IOException {
        ApiResponse apiResponse;
        String url = AppContext.getApiUrlSetting().getWebUrl() + "?redirectUrl=nana";
        if (StringUtils.isNotBlank((CharSequence)model.getQueryString())) {
            url = url + "&queryString=" + model.getQueryString();
        }
        if ((apiResponse = ApiResponse.buildOK().setData((Object)url)) != null) {
            response.sendRedirect(url);
        }
        return apiResponse;
    }

    private String getLineCamInfo(ThirdPartyForParticipationRequestModel model, String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", model.getCode());
        params.put("appId", "Athena");
        params.put("redirectUri", this.getNanaLineRedirectUri());
        params.put("clientId", AppContext.getApiUrlSetting().getNanaLineClientId());
        params.put("clientSecret", AppContext.getApiUrlSetting().getNanaLineClientSecret());
        DigIwinCamResponse lineCamInfo = this.digIwinCamProxyService.getLineCamInfo(params);
        if (Objects.isNull(lineCamInfo)) {
            return url;
        }
        Map dataMap = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)lineCamInfo.getData()), Map.class);
        return HttpUtil.urlWithForm((String)url, (Map)dataMap, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)true);
    }

    private Map<String, Object> queryLineCamInfo(ThirdPartyForParticipationRequestModel model) {
        try {
            if (StringUtils.isNotBlank((CharSequence)model.getCode())) {
                HashMap<String, String> params = new HashMap<String, String>(5);
                params.put("code", model.getCode());
                params.put("appId", "Athena");
                params.put("redirectUri", this.getNanaLineRedirectUri());
                params.put("clientId", AppContext.getApiUrlSetting().getNanaLineClientId());
                params.put("clientSecret", AppContext.getApiUrlSetting().getNanaLineClientSecret());
                DigIwinCamResponse lineCamInfo = this.digIwinCamProxyService.getLineCamInfo(params);
                if (Objects.nonNull(lineCamInfo)) {
                    return JSONUtil.parseObj((Object)lineCamInfo.getData());
                }
            }
            return null;
        }
        catch (Exception e) {
            log.info("queryLineCamInfo is error");
            return null;
        }
    }
}

