/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.common;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TaskStringUtil {
    public static final String CUSTOM_PROJECT_CODE_EMPLOYEE_INDUCTION = "task_induction_firstDay";
    public static final String CUSTOM_TASK_CODE_EMPLOYEE_INDUCTION = "employeeInduction";
    public static final String CUSTOM_PROJECT_CODE_ATTENDANCE_CONFIRMATION = "attendance_confirmation";
    public static final String CUSTOM_TASK_CODE_EMPLOYEE_ATTENDANCE_CONFIRMATION = "employeeAttendanceConfirmation";
    public static final String CUSTOM_PROJECT_CODE_ZHILINK_PRINT = "print_task_userProject";
    public static final String CUSTOM_TASK_CODE_ZHILINK_PRINT = "snmPrintTask";
    public static final String CUSTOM_PROJECT_CODE_ZHILINK_PASTE = "print_task_userProject";
    public static final String CUSTOM_TASK_CODE_ZHILINK_PASTE = "snmPasteTask";
    public static final String CUSTOM_PROJECT_CODE_ZHILINK_CHECKOUT = "factory_task_userProject";
    public static final String CUSTOM_TASK_CODE_ZHILINK_CHECKOUT = "snmFactoryTask";
    public static final String LINK_SYMBOL = "_";
    public static final String CUSTOM_PROJECT_CODE_WORKING_HOUR_REPORT = "workshop_plan_syn_userproject";
    public static final String CUSTOM_TASK_CODE_WORKING_HOUR_REPORT = "apc_working_hour";
    public static final String CUSTOM_TASK_CODE_SUPPORT_HOUR_REPORT = "apc_hour_support";
    public static final String CUSTOM_PROJECT_CODE_PROJECT_SCHEDULE_REPORT = "workshop_plan_syn_userproject";
    public static final String CUSTOM_TASK_CODE_PROJECT_SCHEDULE_REPORT = "apc_project_schedule";
    public static final String CUSTOM_TASK_CODE_SUPPORT_NEEDS = "apc_support_needs";
    public static final String CUSTOM_PROJECT_CODE_SUPPORT_NEEDS = "workshop_plan_syn_userproject";
    public static final String CUSTOM_TASK_CODE_ABNORMAL_REPORT = "apc_abnormalReport";
    public static final String CUSTOM_PROJECT_CODE_ABNORMAL_REPORT = "workshop_plan_syn_userproject";
    public static final String CUSTOM_TASK_CODE_OUTSOURCE_REPORT = "outSourcingWorkReport";
    public static final String CUSTOM_PROJECT_CODE_OUTSOURCE_REPORT = "caCimAp_outSourcing_purchaseReport_userProject";
    public static final String CUSTOM_TASK_CODE_CLOUD_STEWARD_REPORT = "sch_manualAssignment";
    public static final String CUSTOM_PROJECT_CODE_CLOUD_STEWARD_REPORT = "systemCloudHouseKeeper_userProject";
    public static final String CUSTOM_TASK_CODE_MATERIAL_NOTICE = "ItemPickingNotice";
    public static final String CUSTOM_PROJECT_CODE_MATERIAL_NOTICE = "caCimAp_outSourcing_purchaseReport_userProject";
    public static final String CUSTOM_TASK_CODE_MERGE_WOK_HOUR = "apc_mergeWork";
    public static final String CUSTOM_PROJECT_CODE_MERGE_WOK_HOUR = "mergeWorkApplication_userproject";
    public static final String CUSTOM_TASK_CODE_PRODUCETION_PROGRESS_REPORT = "TBDS_ProductionProcessRecord";
    public static final String CUSTOM_PROJECT_CODE_PRODUCETION_PROGRESS_REPORT = "TBDS_sampleTrialProduction_userProject";
    public static final String CUSTOM_TASK_CODE_RECONILIATION_PROGRESS_NOTICE = "aacr_AccountReconciliationReport_Project";
    public static final String CUSTOM_PROJECT_CODE_RECONILIATION_PROGRESS_NOTICE = "aacr_AccountReconciliationReport_TaskCard";
    public static final String CUSTOM_TASK_CODE_SMART_ADJUST = "custom_task_code_smart_adjust";
    public static final String CUSTOM_TASK_TYPE_WORKING_HOUR_REPORT = "workshop_plan_syn_userproject_apc_working_hour";
    public static final String CUSTOM_TASK_TYPE_SUPPORT_HOUR_REPORT = "workshop_plan_syn_userproject_apc_hour_support";
    public static final String CUSTOM_TASK_TYPE_PROJECT_SCHEDULE_REPORT = "workshop_plan_syn_userproject_apc_project_schedule";
    public static final String CUSTOM_TASK_TYPE_SUPPORT_NEEDS = "apc_support_needs_workshop_plan_syn_userproject";
    public static final String CUSTOM_TASK_TYPE_ABNORMAL_REPORT = "apc_abnormalReport_workshop_plan_syn_userproject";
    public static final String CUSTOM_TASK_TYPE_OUTSOURCE_REPORT = "outSourcingWorkReport_caCimAp_outSourcing_purchaseReport_userProject";
    public static final String CUSTOM_TASK_TYPE_MATERIAL_NOTICE = "ItemPickingNotice_caCimAp_outSourcing_purchaseReport_userProject";
    public static final String CUSTOM_TASK_TYPE_MERGE_WOK_HOUR = "apc_mergeWork_mergeWorkApplication_userproject";
    public static final String CUSTOM_TASK_TYPE_PRODUCETION_PROGRESS_REPORT = "TBDS_ProductionProcessRecord_TBDS_sampleTrialProduction_userProject";
    public static final String CUSTOM_TASK_TYPE_RECONCILIATION_PROGRESS_NOTICE = "aacr_AccountReconciliationReport_Project_aacr_AccountReconciliationReport_TaskCard";
    public static final String TASK_TYPE_BIZ_APPROVAL = "BUSINESS_APPROVAL";
    public static final String TASK_TYPE_BIZ_REPORT = "BUSINESS_REPORT";
    public static final String TASK_TYPE_CUSTOM_REPORT = "CUSTOM_REPORT";
    public static final String TASK_TYPE_CUSTOM_PROCESS = "CUSTOM_PROCESS";
    public static final String TASK_TYPE_BIZ_ASSISTAN = "BUSINESS_ASSISTAN_ASSISTAN";
    public static final String TASK_TYPE_BIZ_PROCESS = "BUSINESS_PROCESS";
    public static final String TASK_TYPE_BUSINESS_REPLY = "BUSINESS_REPLY";
    public static final String TASK_TYPE_BIZ_DATA_ENTRY_DRIVEN = "BUSINESS_DATA_ENTRY_DRIVEN";
    public static final String CUSTOM_PATTERN_TASK = "CUSTOM";

    public static boolean isBizApproval(String tmPattern, String tmCategory) {
        Assert.notNull((Object)tmPattern, (String)"tmPattern must not null!");
        Assert.notNull((Object)tmCategory, (String)"tmCategory must not null!");
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("BUSINESS_APPROVAL");
    }

    public static boolean isBizReport(String tmPattern, String tmCategory) {
        Assert.notNull((Object)tmPattern, (String)"tmPattern must not null!");
        Assert.notNull((Object)tmCategory, (String)"tmCategory must not null!");
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("BUSINESS_REPORT");
    }

    public static boolean isBizProcess(String tmPattern, String tmCategory) {
        Assert.notNull((Object)tmPattern, (String)"tmPattern must not null!");
        Assert.notNull((Object)tmCategory, (String)"tmCategory must not null!");
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("BUSINESS_PROCESS");
    }

    public static boolean isCustomReport(String tmPattern, String tmCategory) {
        Assert.notNull((Object)tmPattern, (String)"tmPattern must not null!");
        Assert.notNull((Object)tmCategory, (String)"tmCategory must not null!");
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("CUSTOM_REPORT");
    }

    public static boolean isCustomProcess(String tmPattern, String tmCategory) {
        Assert.notNull((Object)tmPattern, (String)"tmPattern must not null!");
        Assert.notNull((Object)tmCategory, (String)"tmCategory must not null!");
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("CUSTOM_PROCESS");
    }

    public static boolean isBusinessReply(String tmPattern, String tmCategory) {
        Assert.notNull((Object)tmPattern, (String)"tmPattern must not null!");
        Assert.notNull((Object)tmCategory, (String)"tmCategory must not null!");
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("BUSINESS_REPLY");
    }

    public static boolean isBizDataEntryDriven(String tmPattern, String tmCategory) {
        if (!StringUtils.hasLength((String)tmPattern) || !StringUtils.hasLength((String)tmCategory)) {
            return false;
        }
        return (tmPattern + "_" + tmCategory).equalsIgnoreCase("BUSINESS_DATA_ENTRY_DRIVEN");
    }

    public static boolean isBizSmartAdjust(String tmActivityId) {
        if (!StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmActivityId.endsWith("_task_manual") || tmActivityId.endsWith("_task_approve");
    }

    public static boolean isProjectCreateOfModelDriven(String tmActivityId) {
        if (!StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmActivityId.startsWith("StartNode_");
    }

    public static boolean isSscEmployeeInduction(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("task_induction_firstDay") && tmActivityId.contains("employeeInduction");
    }

    public static boolean isApcSupportNeedsStrategy(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("workshop_plan_syn_userproject") && tmActivityId.contains("apc_support_needs");
    }

    public static boolean isApcAbnoralReport(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("workshop_plan_syn_userproject") && tmActivityId.contains("apc_abnormalReport");
    }

    public static boolean isOutSourceReport(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("caCimAp_outSourcing_purchaseReport_userProject") && tmActivityId.contains("outSourcingWorkReport");
    }

    public static boolean isMaterialNotice(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("caCimAp_outSourcing_purchaseReport_userProject") && tmActivityId.contains("ItemPickingNotice");
    }

    public static boolean isMergeWorkHour(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("mergeWorkApplication_userproject") && tmActivityId.contains("apc_mergeWork");
    }

    public static boolean isReconiliationProgressNotice(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("aacr_AccountReconciliationReport_Project") && tmActivityId.contains("aacr_AccountReconciliationReport_TaskCard");
    }

    public static boolean isSscAttendanceConfirmation(String tmTaskId, String tmActivityId) {
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("attendance_confirmation") && tmActivityId.contains("employeeAttendanceConfirmation");
    }

    public static boolean isZhilinkBarCodePrint(String tmTaskId, String tmActivityId) {
        if (ObjectUtils.isEmpty((Object)tmTaskId) || ObjectUtils.isEmpty((Object)tmActivityId)) {
            return false;
        }
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("print_task_userProject") && tmActivityId.contains("snmPrintTask");
    }

    public static boolean isZhilinkBarCodePaste(String tmTaskId, String tmActivityId) {
        if (ObjectUtils.isEmpty((Object)tmTaskId) || ObjectUtils.isEmpty((Object)tmActivityId)) {
            return false;
        }
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("print_task_userProject") && tmActivityId.contains("snmPasteTask");
    }

    public static boolean isZhilinkBarCodeCheckout(String tmTaskId, String tmActivityId) {
        if (ObjectUtils.isEmpty((Object)tmTaskId) || ObjectUtils.isEmpty((Object)tmActivityId)) {
            return false;
        }
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("factory_task_userProject") && tmActivityId.contains("snmFactoryTask");
    }

    public static boolean isWorkingHourReport(String tmTaskId, String tmActivityId) {
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("workshop_plan_syn_userproject") && tmActivityId.contains("apc_working_hour");
    }

    public static boolean isSupportHourReport(String tmTaskId, String tmActivityId) {
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("workshop_plan_syn_userproject") && tmActivityId.contains("apc_hour_support");
    }

    public static boolean isProjectScheduleReport(String tmTaskId, String tmActivityId) {
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        return tmTaskId.contains("workshop_plan_syn_userproject") && tmActivityId.contains("apc_project_schedule");
    }

    public static boolean isZtbDepartureTaskCard(String tmTaskId, String tmActivityId) {
        return " freightage_start_user".contains(tmTaskId) && "freightage_departure".contains(tmActivityId);
    }

    public static boolean isZtbTransportTaskCard(String tmTaskId, String tmActivityId) {
        return " freightage_start_user".contains(tmTaskId) && "freightage_transport_loading".contains(tmActivityId);
    }

    public static boolean isZtbDepartureOfTransportTaskCard(String tmTaskId, String tmActivityId) {
        return TaskStringUtil.isZtbDepartureTaskCard((String)tmTaskId, (String)tmActivityId) || TaskStringUtil.isZtbTransportTaskCard((String)tmTaskId, (String)tmActivityId);
    }

    public static boolean isPccTask(String tmTaskId, String tmActivityId) {
        Assert.notNull((Object)tmTaskId, (String)"tmTaskId must not null!");
        Assert.notNull((Object)tmActivityId, (String)"tmActivityId must not null!");
        boolean isPccFlowEngineManualReportTask = "manualAssignment".equals(tmActivityId) && "task_Assignment".equals(tmTaskId);
        boolean isPccTaskEngineManualReportTask = ("manual_DTD_Assignment".equals(tmActivityId) || "uc_manual_DTD_Assignment".equals(tmActivityId)) && "projectCenterConsole_userProject".equals(tmTaskId);
        return isPccFlowEngineManualReportTask || isPccTaskEngineManualReportTask;
    }

    public static boolean isNeedSubName(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        return "APPROVAL".equals(digiwinAtmcBacklog.getTmCategory());
    }

    public static String getTaskStateText(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        if (BooleanUtils.isNotTrue((Boolean)digiwinAtmcBacklog.getReassign()) && StringUtils.hasLength((String)digiwinAtmcBacklog.getApprovalState())) {
            return digiwinAtmcBacklog.getApprovalState();
        }
        return "";
    }

    public static String getDataChangeStatusText(DigiwinAtmcBacklog digiwinAtmcBacklog, LocaleService localeService, String locale) {
        if (BooleanUtils.isTrue((Boolean)digiwinAtmcBacklog.getDataChangeRead())) {
            return localeService.getLanguageValue(locale, "\u5df2\u53d8\u66f4");
        }
        if (BooleanUtils.isTrue((Boolean)digiwinAtmcBacklog.getChanged())) {
            return localeService.getLanguageValue(locale, "\u53d8\u66f4\u4e2d");
        }
        return "";
    }

    public static String getTaskBuildTypeByDetailPatternCategory(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        boolean isPccTaskEngineManualReportTask;
        if (TaskStringUtil.isSscEmployeeInduction((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "task_induction_firstDay_employeeInduction";
        }
        if (TaskStringUtil.isSscAttendanceConfirmation((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "attendance_confirmation_employeeAttendanceConfirmation";
        }
        if (TaskStringUtil.isZhilinkBarCodePrint((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "print_task_userProject_snmPrintTask";
        }
        if (TaskStringUtil.isZhilinkBarCodePaste((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "print_task_userProject_snmPasteTask";
        }
        if (TaskStringUtil.isZhilinkBarCodeCheckout((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "factory_task_userProject_snmFactoryTask";
        }
        if (TaskStringUtil.isWorkingHourReport((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "workshop_plan_syn_userproject_apc_working_hour";
        }
        if (TaskStringUtil.isSupportHourReport((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "workshop_plan_syn_userproject_apc_hour_support";
        }
        if (TaskStringUtil.isProjectScheduleReport((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "workshop_plan_syn_userproject_apc_project_schedule";
        }
        if (TaskStringUtil.isApcSupportNeedsStrategy((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "apc_support_needs_workshop_plan_syn_userproject";
        }
        if (TaskStringUtil.isApcAbnoralReport((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "apc_abnormalReport_workshop_plan_syn_userproject";
        }
        if (TaskStringUtil.isOutSourceReport((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "outSourcingWorkReport_caCimAp_outSourcing_purchaseReport_userProject";
        }
        if (TaskStringUtil.isMaterialNotice((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "ItemPickingNotice_caCimAp_outSourcing_purchaseReport_userProject";
        }
        if (TaskStringUtil.isMergeWorkHour((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "apc_mergeWork_mergeWorkApplication_userproject";
        }
        if (TaskStringUtil.isProductionProgressReport((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "TBDS_ProductionProcessRecord_TBDS_sampleTrialProduction_userProject";
        }
        if (TaskStringUtil.isReconiliationProgressNotice((String)digiwinAtmcBacklogDetail.getTmTaskId(), (String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "aacr_AccountReconciliationReport_Project_aacr_AccountReconciliationReport_TaskCard";
        }
        if (TaskStringUtil.isBizSmartAdjust((String)digiwinAtmcBacklogDetail.getTmActivityId())) {
            return "custom_task_code_smart_adjust";
        }
        boolean isPccFlowEngineManualReportTask = "manualAssignment".equals(digiwinAtmcBacklogDetail.getTmActivityId()) && "task_Assignment".equals(digiwinAtmcBacklogDetail.getTmTaskId());
        boolean bl = isPccTaskEngineManualReportTask = ("manual_DTD_Assignment".equals(digiwinAtmcBacklogDetail.getTmActivityId()) || "uc_manual_DTD_Assignment".equals(digiwinAtmcBacklogDetail.getTmActivityId())) && "projectCenterConsole_userProject".equals(digiwinAtmcBacklogDetail.getTmTaskId());
        if (isPccFlowEngineManualReportTask || isPccTaskEngineManualReportTask) {
            return "BUSINESS_REPORT";
        }
        String tmPattern = Optional.ofNullable(digiwinAtmcBacklogDetail).map(DigiwinAtmcBacklogDetail::getTmPattern).orElse("");
        String tmCategory = Optional.ofNullable(digiwinAtmcBacklogDetail).map(DigiwinAtmcBacklogDetail::getTmCategory).orElse("");
        if (TaskStringUtil.matchPatternIsCustom((String)tmPattern)) {
            return "CUSTOM";
        }
        return tmPattern + "_" + tmCategory;
    }

    private static boolean isProductionProgressReport(String tmTaskId, String tmActivityId) {
        if (!StringUtils.hasLength((String)tmTaskId) || !StringUtils.hasLength((String)tmActivityId)) {
            return false;
        }
        return tmTaskId.contains("TBDS_sampleTrialProduction_userProject") && tmActivityId.contains("TBDS_ProductionProcessRecord");
    }

    private static boolean matchPatternIsCustom(String tmPattern) {
        return "CUSTOM".equals(tmPattern);
    }

    public static String getTaskInNotificationSummaryContent(String locale, long count) {
        String content = "";
        content = count > 0L ? String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9996\u9875\u4efb\u52a1\u63d0\u793a\u903e\u671f"), count) : LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9996\u9875\u4efb\u52a1\u63d0\u793a");
        return content;
    }

    public static String getTaskTimeHintText(String locale, String taskEndTimeString) {
        long hintNumber;
        String hintUnit;
        LocalDateTime taskEndTime = DateTimeUtil.parseUseDefaultPattern((String)taskEndTimeString);
        LocalDateTime now = LocalDateTime.now();
        Duration duration = Duration.between(now, taskEndTime);
        String hintType = !duration.isNegative() || duration.isZero() ? LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5012\u8ba1\u65f6") : LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f");
        long durationSeconds = duration.abs().getSeconds();
        if (durationSeconds >= 60L && durationSeconds < 3600L) {
            hintUnit = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5206\u949f");
            hintNumber = durationSeconds / 60L;
        } else if (durationSeconds >= 3600L && durationSeconds < 86400L) {
            hintUnit = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5c0f\u65f6");
            hintNumber = duration.abs().toHours();
        } else {
            hintUnit = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5929");
            LocalDate nowDate = now.toLocalDate();
            LocalDate taskEndDate = taskEndTime.toLocalDate();
            hintNumber = Math.abs(nowDate.toEpochDay() - taskEndDate.toEpochDay());
        }
        return LocaleUtil.getMobileTextWithUnit((String)locale, (String)hintType, (String)String.valueOf(hintNumber), (String)hintUnit, (boolean)false, (String)"");
    }

    public static String getTaskDateDistanceText(String startDateInDefaultPattern, String endDateInDefaultPattern) {
        if (!DateTimeUtil.isDateUseDefaultPattern((String)startDateInDefaultPattern) || !DateTimeUtil.isDateUseDefaultPattern((String)endDateInDefaultPattern)) {
            return "";
        }
        return DateTimeUtil.getDateDistanceFromStartToEnd((String)startDateInDefaultPattern, (String)endDateInDefaultPattern);
    }
}

