/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.filter;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterCategoryEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterParamOpEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterRepository;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskFilterService")
public class TaskFilterServiceImpl
implements TaskFilterService {
    private static final Logger logger = LoggerFactory.getLogger(TaskFilterServiceImpl.class);
    @Autowired
    private TaskFilterRepository taskFilterRepository;

    public boolean isSupportedTaskByDigiwinAtmcBacklog(DigiwinAtmcBacklog digiwinAtmcBacklog, List<TaskFilter> filterList) {
        boolean filterCalculateResult = this.calculateFilterResult(filterList, digiwinAtmcBacklog);
        boolean backlogtypeSupported = digiwinAtmcBacklog.getBacklogtypeSupported();
        return filterCalculateResult && backlogtypeSupported;
    }

    public boolean isSupportedTaskByDigiwinAtmcBacklogDetail(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<TaskFilter> filterList) {
        DigiwinAtmcBacklog backlog = new DigiwinAtmcBacklog();
        backlog.setTmPattern(digiwinAtmcBacklogDetail.getTmPattern());
        backlog.setTmCategory(digiwinAtmcBacklogDetail.getTmCategory());
        backlog.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
        backlog.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue());
        return this.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList);
    }

    public boolean isSupportedTaskByDigiwinAtmcTask(DigiwinAtmcTask digiwinAtmcTask, List<TaskFilter> filterList) {
        DigiwinAtmcBacklog backlog = new DigiwinAtmcBacklog();
        backlog.setTmPattern(digiwinAtmcTask.getTmPattern());
        backlog.setTmCategory(digiwinAtmcTask.getTmCategory());
        backlog.setTmTaskId(digiwinAtmcTask.getTmTaskId());
        backlog.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue());
        return this.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList);
    }

    public boolean isCanlderTaskByDigiwinAtmcBacklog(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        return digiwinAtmcBacklog.getType().equals(DigiwinAtmcBacklogTypeEnum.CALENDAR.getValue()) || digiwinAtmcBacklog.getType().equals(DigiwinAtmcBacklogTypeEnum.TEAM_CALENDAR.getValue());
    }

    private boolean calculateFilterResult(List<TaskFilter> taskFilterList, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        List equalFilterList = taskFilterList.stream().filter(taskFilter -> TaskFilterParamOpEnum.EQUALS.getValue().equals(taskFilter.getParamOp())).collect(Collectors.toList());
        List noEqualFilterList = taskFilterList.stream().filter(taskFilter -> TaskFilterParamOpEnum.NOT_EQUALS.getValue().equals(taskFilter.getParamOp())).collect(Collectors.toList());
        return this.matchWithFilter(equalFilterList, digiwinAtmcBacklog) && !this.matchWithFilter(noEqualFilterList, digiwinAtmcBacklog);
    }

    private boolean matchWithFilter(List<TaskFilter> taskFilterList, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        return taskFilterList.stream().anyMatch(taskFilter -> {
            boolean isMatch = false;
            TaskFilterCategoryEnum categoryEnum = TaskFilterCategoryEnum.getEnumByName((String)taskFilter.getCategory());
            if (null == categoryEnum) {
                return isMatch;
            }
            switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$task$filter$TaskFilterCategoryEnum[categoryEnum.ordinal()]) {
                case 1: {
                    isMatch = taskFilter.matchInPatternAndCategory(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory());
                    break;
                }
                case 2: {
                    isMatch = taskFilter.matchInTaskId(digiwinAtmcBacklog.getTmTaskId());
                    break;
                }
                case 3: {
                    isMatch = taskFilter.matchInTaskIdAndActivityId(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId());
                    break;
                }
            }
            return isMatch;
        });
    }
}

