/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivity;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineActivity;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEngineTaskCode;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="projectPccNotStartedStrategy")
public class ProjectPccNotStartedStrategy
implements UiBotModelBuildStrategy {
    public static final String MAINTENANCE_PROJECT_DTD = "maintenanceProject_DTD";
    @Autowired
    private LocaleService localeService;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return this.getUiBotModel(pageSetting, apiRequest);
    }

    @NotNull
    private UiBotModel getUiBotModel(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        String tmTaskId = String.valueOf(rawData.get((Object)"tmTaskId"));
        boolean isShare = Boolean.parseBoolean(String.valueOf(rawData.get((Object)"isShare")));
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        List emptyLayout = uiBotModel.getLayout();
        UiBotPageData emptyPageData = uiBotModel.getPageData();
        String titleBodySchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(titleBodySchema, "TITLE_BODY"));
        String blankAreaSchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(blankAreaSchema, "BLANK_AREA"));
        emptyPageData.put((Object)blankAreaSchema, (Object)BlankArea.create((Integer)326, (Double)1.0));
        String emptySchema = UUIDUtil.getUuid();
        emptyLayout.add(new UiBotLayout(emptySchema, "EMPTY"));
        emptyPageData.put((Object)emptySchema, (Object)Empty.create((String)this.localeService.getLanguageValue(apiRequest.getLocale(), "\u6b64\u4e13\u6848\u5c1a\u672a\u542f\u52a8\uff0c\u5efa\u8bae\u53bbPC\u7aef\u7ef4\u62a4"), (boolean)true, (Integer)10, (Integer)1000, (Integer)240, (Integer)240, (String)"#D2D2E6", (String)"IMAGE_TASK_FINISH"));
        if (StringUtils.isEmpty((CharSequence)tmTaskId)) {
            return uiBotModel;
        }
        DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = null;
        DigiwinAtmcPanel atmcPanel = null;
        List batchReassignUsers = Collections.emptyList();
        UiBotModel pcUiBotModel = null;
        PccApiDataWrapper pccProjectInfo = null;
        try {
            String finalTmActivityId;
            String finalTmTaskId;
            CompletableFuture<List> listCompletableFuture;
            List projectDetailDataStateList;
            String tmActivityId = "";
            boolean pccProjectTypeIsNew = "projectCenterConsole_userProject".equalsIgnoreCase(tmTaskId);
            if (!pccProjectTypeIsNew) {
                CompletableFuture<DigiwinAtmcPanel> digiwinAtmcPanelCompletableFuture = CompletableFuture.supplyAsync(() -> this.digiwinAtmcProxyService.getTaskPanel(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId()), (Executor)this.threadPoolTaskExecutor);
                atmcPanel = digiwinAtmcPanelCompletableFuture.get();
            } else {
                CompletableFuture<DigiwinAtmcEnginePanelInfo> digiwinAtmcEnginePanelInfoCompletableFuture = CompletableFuture.supplyAsync(() -> this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(apiRequest.getDataId() + "", apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale()), (Executor)this.threadPoolTaskExecutor);
                atmcEnginePanelInfo = digiwinAtmcEnginePanelInfoCompletableFuture.get();
            }
            if (!pccProjectTypeIsNew) {
                if (null != atmcPanel) {
                    tmTaskId = atmcPanel.getTask().getTmTaskId();
                    Optional<DigiwinAtmcActivity> optActivity = atmcPanel.getActivities().stream().filter(atmcActivity -> "progressTrack".equalsIgnoreCase(atmcActivity.getId())).findFirst();
                    if (!optActivity.isPresent()) {
                        return UiBotModel.emptyUiBotModel();
                    }
                    tmActivityId = optActivity.get().getId();
                }
            } else if (null != atmcEnginePanelInfo) {
                tmTaskId = atmcEnginePanelInfo.getTask().getTmTaskId();
                List activityList = atmcEnginePanelInfo.getRoute().getSelectRoute().getActivities();
                ArrayList taskCodes = new ArrayList();
                for (DigiwinAtmcEngineActivity activity : activityList) {
                    if (activity == null || activity.getTaskCodes() == null) continue;
                    taskCodes.addAll(activity.getTaskCodes());
                }
                Optional<DigiwinAtmcEngineTaskCode> taskCodeOptional = taskCodes.stream().filter(taskCode -> MAINTENANCE_PROJECT_DTD.equalsIgnoreCase(taskCode.getId())).findFirst();
                if (!taskCodeOptional.isPresent()) {
                    return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
                }
                tmActivityId = taskCodeOptional.get().getId();
                atmcPanel = new DigiwinAtmcPanel();
                atmcPanel.setTask(atmcEnginePanelInfo.getTask());
            }
            if (StringUtils.isNotBlank((CharSequence)tmTaskId) && !CollectionUtils.isEmpty((Collection)(projectDetailDataStateList = (listCompletableFuture = CompletableFuture.supplyAsync(() -> this.lambda$getUiBotModel$4(apiRequest, finalTmTaskId = tmTaskId, finalTmActivityId = tmActivityId), (Executor)this.threadPoolTaskExecutor)).get()))) {
                Map projectDetailDataState = (Map)projectDetailDataStateList.get(0);
                CompletableFuture<UiBotModel> pcUiBotModelCompletableFuture = CompletableFuture.supplyAsync(() -> this.digiwinPcUiBotProxyService.actionShow(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)projectDetailDataState)), (Executor)this.threadPoolTaskExecutor);
                pcUiBotModel = pcUiBotModelCompletableFuture.get();
                HashMap<String, Object> bodyPayloadMap = new HashMap<String, Object>(4);
                String actionId = "project.info.get";
                bodyPayloadMap.put("actionId", actionId);
                bodyPayloadMap.put("businessUnit", pcUiBotModel.getExecuteContext().get((Object)"businessUnit"));
                Map taskWithBacklogData = (Map)pcUiBotModel.getExecuteContext().get((Object)"taskWithBacklogData");
                Map bpmData = (Map)taskWithBacklogData.get("bpmData");
                List projectDataList = (List)bpmData.get("project_data");
                HashMap<String, List> parameter = new HashMap<String, List>(1);
                parameter.put("project_info", projectDataList);
                bodyPayloadMap.put("parameter", parameter);
                CompletableFuture<PccApiDataWrapper> pccApiDataWrapperCompletableFuture = CompletableFuture.supplyAsync(() -> this.digiwinAtdmProxyService.dataQueryByActionProjectInfo(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)bodyPayloadMap), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor);
                pccProjectInfo = pccApiDataWrapperCompletableFuture.get();
            }
            if (atmcEnginePanelInfo != null && ObjectUtils.isNotEmpty((Object)atmcEnginePanelInfo.getTask())) {
                DigiwinAtmcEnginePanelInfo finalAtmcEnginePanelInfo = atmcEnginePanelInfo;
                CompletableFuture<List> digiwinAtmcReassignUser = CompletableFuture.supplyAsync(() -> this.digiwinAtmcProxyService.batchGetProjectReassignUsers(finalAtmcEnginePanelInfo.getTask(), apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId()), (Executor)this.threadPoolTaskExecutor);
                batchReassignUsers = digiwinAtmcReassignUser.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (atmcEnginePanelInfo != null && atmcEnginePanelInfo.getReassign() != null && !isShare) {
            List buttons = uiBotModel.getAppbarButtonList();
            atmcEnginePanelInfo.getReassign().put("reassignUsers", batchReassignUsers);
            HashMap<String, String> buttonActionRawData = new HashMap<String, String>(atmcEnginePanelInfo.getReassign());
            buttonActionRawData.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", (String)atmcEnginePanelInfo.getTask());
            buttonActionRawData.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());
            buttons.add(Button.createApprovalReassign((String)(apiRequest.getDataId() + ""), buttonActionRawData, (String)apiRequest.getLocale(), (String)"PROJECT", (Integer)58926));
            HashMap<String, String> rawDataInAppbarButton = new HashMap<String, String>(atmcEnginePanelInfo.getReassign());
            rawDataInAppbarButton.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            rawDataInAppbarButton.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());
            buttons.add(Button.createProjectShareWithOthers((String)apiRequest.getDataId(), (Map)((Map)JsonUtil.objectToJavaObject(rawDataInAppbarButton, Map.class)), (String)apiRequest.getLocale(), (LocaleService)this.localeService));
        }
        List layouts = uiBotModel.getLayout();
        if (ObjectUtils.isNotEmpty(pccProjectInfo) && pccProjectInfo != null && !CollectionUtils.isEmpty((Collection)pccProjectInfo.getProjectInfoList())) {
            for (UiBotLayout layout : layouts) {
                if (!"TITLE_BODY".equals(layout.getType())) continue;
                if (!ObjectUtils.isNotEmpty((Object)atmcPanel)) break;
                TitleBody titleBody = TitleBody.create((ApiRequest)apiRequest, (PageSetting)pageSetting, (UiBotModel)pcUiBotModel, (PccProjectInfo)((PccProjectInfo)pccProjectInfo.getProjectInfoList().get(0)), (DigiwinAtmcPanel)atmcPanel, (PageDescBuilderFactory)this.pageDescBuilderFactory);
                uiBotModel.getPageData().put((Object)layout.getSchema(), (Object)titleBody);
                break;
            }
        }
        return uiBotModel;
    }

    private /* synthetic */ List lambda$getUiBotModel$4(ApiRequest apiRequest, String finalTmTaskId, String finalTmActivityId) {
        return this.digiwinPcUiBotProxyService.getProjectDetailByProjectId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId(), finalTmTaskId, finalTmActivityId);
    }
}

