/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildApcAbnormalReportDetailStrategy")
public class TaskDetailBuildApcAbnormalReportDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcAbnormalReportDetailStrategy.class);
    @Autowired
    private RuleService ruleService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        Map businessUnit;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel pcUiBotModel = (UiBotModel)JsonUtil.objectToJavaObject(rawData.get("pcUiBotModel"), UiBotModel.class);
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)locale);
        }
        List woOpReportAbnormalList = (List)rawData.get("wo_op_report_abnormal");
        UiBotExecuteContext executeContext = (UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)apiRequest.getRawData().get((Object)"executeContext"), UiBotExecuteContext.class);
        if (null == executeContext) {
            executeContext = pcUiBotModel.getExecuteContext();
        }
        if ((businessUnit = (Map)apiRequest.getRawData().get((Object)"businessUnit")).isEmpty()) {
            businessUnit = (Map)executeContext.get((Object)"businessUnit");
        }
        List ruleList = this.ruleService.findByRulePathAndPageId("wo_op_report_data", apiRequest.getPageId());
        List pcButtonLayout = pcUiBotModel.getLayout();
        List pcButtonActions = pcUiBotModel.getLayout().stream().filter(layout -> "apc_project_schedule-task-detail-waitting".equals(layout.getType())).findFirst().map(UiBotLayout::getActions).orElse(Collections.emptyList());
        stopWatch.start("Build ApcAbnormalReport Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        List uiBotRuleList = pcUiBotModel.getRules();
        Boolean abnormalReturns = this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "abnormalAllowsUploadingAttachments");
        for (UiBotLayout layout2 : uiBotLayouts) {
            String fieldSchema = layout2.getSchema();
            Optional<UiBotRule> ruleOptional = uiBotRuleList.stream().filter(uiBotRule -> "wo_op_report_data".equalsIgnoreCase(uiBotRule.getPath()) && fieldSchema.equalsIgnoreCase(uiBotRule.getSchema())).findFirst();
            UiBotRule uiBotRule2 = ruleOptional.isPresent() ? ruleOptional.get() : null;
            switch (layout2.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = InputWindowSingleSelect.create((UiBotLayout)layout2, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/abnormalReport/abnormalReasonlist"), (String)locale, (Map)rawData, (List)ruleList);
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)inputWindowSingleSelect);
                    break;
                }
                case "INPUT_MULTI": {
                    InputMultiText inputMultiText = new InputMultiText();
                    inputMultiText.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165"));
                    inputMultiText.setRequired(Boolean.valueOf(false));
                    inputMultiText.setText("");
                    inputMultiText.setTitle(this.localeService.getLanguageValue(locale, "\u5f02\u5e38\u539f\u56e0\u63cf\u8ff0"));
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)inputMultiText);
                    break;
                }
                case "ATTACHMENT": {
                    UiBotLayout uiBotLayout = new UiBotLayout();
                    Boolean isFind = false;
                    block13: for (UiBotLayout pcLayout : pcButtonLayout) {
                        if ("wo_op_report_data".equalsIgnoreCase(pcLayout.getId())) {
                            block14: for (UiBotTableColumnDefinition definition : pcLayout.getColumnDefs()) {
                                if (isFind.booleanValue()) break block13;
                                for (UiBotTableColumn tableColumn : definition.getColumns()) {
                                    if (!tableColumn.getSchema().equalsIgnoreCase(layout2.getSchema())) continue;
                                    uiBotLayout = (UiBotLayout)JsonUtil.objectToJavaObject((Object)tableColumn, UiBotLayout.class);
                                    isFind = true;
                                    continue block14;
                                }
                            }
                            break;
                        }
                        if (!isFind.booleanValue()) continue;
                        break;
                    }
                    Attachment attachment = Attachment.create((UiBotLayout)uiBotLayout, (UiBotRule)uiBotRule2);
                    attachment.setMaxSize(Long.valueOf(0x1400000L));
                    attachment.setLimit(Integer.valueOf(10));
                    attachment.setHidden(Boolean.valueOf(!ObjectUtils.isNotEmpty((Object)abnormalReturns) || !BooleanUtils.isTrue((Boolean)abnormalReturns)));
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)attachment);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
                    HashMap<String, Object> abnormalReportRawData = new HashMap<String, Object>();
                    abnormalReportRawData.put("iamUserToken", apiRequest.getIamUserToken());
                    abnormalReportRawData.put("locale", apiRequest.getLocale());
                    abnormalReportRawData.put("clientId", apiRequest.getClientId());
                    UiBotAction pcUiBotAction = new UiBotAction();
                    HashMap<String, Object> extendFields = new HashMap<String, Object>();
                    if (pcButtonActions.size() > 0) {
                        pcUiBotAction = pcButtonActions.stream().filter(item -> item.getType().equalsIgnoreCase("apc_ProgressToAbnormal")).findFirst().orElse(null);
                        HashMap<String, List> submitWoOpReportData = new HashMap<String, List>();
                        submitWoOpReportData.put("wo_op_report_data", woOpReportAbnormalList);
                        abnormalReportRawData.put("data", submitWoOpReportData);
                        HashMap<String, Object> woOpReportDataParameter = new HashMap<String, Object>();
                        woOpReportDataParameter.put("process_category", "2");
                        for (Map map : woOpReportAbnormalList) {
                            map.put("process_category", "2");
                        }
                        woOpReportDataParameter.put("wo_op_report_data", woOpReportAbnormalList);
                        extendFields.put("parameter", woOpReportDataParameter);
                        extendFields.put("actionId", "wo.op.report.progress.info.process");
                    } else {
                        pcButtonActions = pcButtonLayout.stream().filter(item -> item.getSchema() != null && item.getSchema().equalsIgnoreCase("customData")).findFirst().orElse(new UiBotLayout()).getActions();
                        pcUiBotAction = pcButtonActions.stream().filter(item -> item.getId().equalsIgnoreCase("submit-abnormal")).findFirst().orElse(null);
                        HashMap<String, List> submitWoOpReportAbnormal = new HashMap<String, List>();
                        submitWoOpReportAbnormal.put("wo_op_report_abnormal", woOpReportAbnormalList);
                        abnormalReportRawData.put("data", submitWoOpReportAbnormal);
                        HashMap<String, List> abnormalReportParameter = new HashMap<String, List>();
                        abnormalReportParameter.put("wo_op_report_abnormal", woOpReportAbnormalList);
                        extendFields.put("parameter", abnormalReportParameter);
                        extendFields.put("actionId", "bm.wrsc.wo.op.report.abnormal.create");
                    }
                    extendFields.put("businessUnit", businessUnit);
                    extendFields.put("executeContext", executeContext);
                    abnormalReportRawData.put("action", pcUiBotAction);
                    abnormalReportRawData.put("extendFields", extendFields);
                    BottomButtonDigiwinAthena abnormalReportSubmitButton = BottomButtonDigiwinAthena.createAbnormalReportSubmitButton((String)locale, abnormalReportRawData);
                    ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)abnormalReportSubmitButton, (String)apiRequest.getRefreshPageId());
                    bottomButtonList.add(abnormalReportSubmitButton);
                    uiBotModel.getPageData().put((Object)fieldSchema, bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        String data = FileUtil.readText((String)"static/mobile_athena_apc_abnormal_report_detail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

