/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildApcTeamDispatchAbnormalReportDetailStrategy")
public class UiBotModelBuildApcTeamDispatchAbnormalReportDetailStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        boolean isGetDataByApi = (Boolean)MapUtil.getOrDefault((Map)rawData, (String)"isGetDataByApi", (Object)true);
        List reportData = isGetDataByApi ? this.digiwinEspProxyService.getWoOpReportWaitProcessAbnormalInfo(iamUserToken, tenantId, locale, (Map)rawData) : (List)MapUtil.getOrDefault((Map)rawData, (String)"wo_op_report_abnormal", Collections.emptyList());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        ArrayList<UiBotLayout> newLayouts = new ArrayList<UiBotLayout>();
        if (CollectionUtils.isEmpty((Collection)reportData) || CollectionUtils.isEmpty(Collections.singleton(((Map)reportData.get(0)).get("wait_process_abnormal_detail")))) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        Boolean abnormalReturns = this.digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "abnormalAllowsUploadingAttachments");
        List waitProcessAbnormalDetailList = (List)((Map)reportData.get(0)).get("wait_process_abnormal_detail");
        if (CollectionUtils.isEmpty((Collection)waitProcessAbnormalDetailList)) {
            return UiBotModel.emptyUibotModel((String)locale);
        }
        for (Map waitProcessAbnormalDetail : waitProcessAbnormalDetailList) {
            List abnormalDetails = (List)waitProcessAbnormalDetail.get("abnormal_detail");
            if (CollectionUtils.isEmpty((Collection)abnormalDetails)) continue;
            for (Map abnormalDetail : abnormalDetails) {
                String schema = UUIDUtil.getUuid();
                newLayouts.add(new UiBotLayout(schema, "CARD"));
                if (CollectionUtils.isEmpty((Map)abnormalDetail)) continue;
                Card card = new Card();
                card.setTitle((String)MapUtil.getOrDefault((Map)abnormalDetail, (String)"abnormal_reason_name", (Object)""));
                LinkedList<CardContent> contentList = new LinkedList<CardContent>();
                contentList.add(this.buildCardContent(this.localeService.getLanguageValue(locale, "\u5f02\u5e38\u5355\u53f7"), abnormalDetail.get("abnormal_doc_no")));
                contentList.add(this.buildCardContent(this.localeService.getLanguageValue(locale, "\u5f02\u5e38\u63cf\u8ff0"), abnormalDetail.get("abnormal_reason_description")));
                String processPersonNameListStr = "";
                List personDetails = (List)abnormalDetail.get("process_person_detail");
                if (!CollectionUtils.isEmpty((Collection)personDetails)) {
                    List processPersonNameList = personDetails.stream().map(e -> (String)e.get("process_person_name")).collect(Collectors.toList());
                    processPersonNameListStr = StringUtils.join(processPersonNameList, (String)"\u3001");
                }
                contentList.add(this.buildCardContent(this.localeService.getLanguageValue(locale, "\u5904\u7406\u4eba"), (Object)processPersonNameListStr));
                if (BooleanUtils.isTrue((Boolean)abnormalReturns)) {
                    CardContent attachmentCardContent = new CardContent();
                    Map attachments = (Map)abnormalDetail.get("abnormal_reason_attachment");
                    if (!CollectionUtils.isEmpty((Map)attachments) && !CollectionUtils.isEmpty((Collection)((Collection)attachments.get("data")))) {
                        Attachment attachment = Attachment.createAbnormalReasonAttachment((Map)attachments, (String)this.localeService.getLanguageValue(locale, "\u5f02\u5e38\u9644\u4ef6"));
                        attachmentCardContent.setFile(attachment);
                    } else {
                        attachmentCardContent = this.buildCardContent(this.localeService.getLanguageValue(locale, "\u5f02\u5e38\u9644\u4ef6"), (Object)"-");
                    }
                    contentList.add(attachmentCardContent);
                }
                card.setContent(contentList);
                pageData.put((Object)schema, (Object)card);
            }
        }
        newLayouts.add(new UiBotLayout("bottomButtons", "BOTTOM_BUTTON"));
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale);
        pageData.put((Object)"bottomButtons", Collections.singletonList(cancelButton));
        uiBotModel.setLayout(newLayouts);
        return uiBotModel;
    }

    private CardContent buildCardContent(String name, Object value) {
        return new CardContent(name, Objects.isNull(value) ? "-" : String.valueOf(value), Boolean.valueOf(false), Integer.valueOf(1));
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

