/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.TargetDatetime;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildApcWorkShopOnlineCancelDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineCancelDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApcWorkShopOnlineCancelDetailStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Apc WorkShopOnline Cancel Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        Map data = (Map)rawData.get("data");
        stopWatch.start("Build ApcWorkShopOnline Cancel Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case "FIELD": {
                    if ("plan_qty".equals(fieldSchema)) {
                        String value = "-";
                        Double planQty = 0.0;
                        if (data.get(fieldSchema) != null) {
                            planQty = data.get(fieldSchema) instanceof Integer ? Double.valueOf(((Integer)data.get(fieldSchema)).doubleValue()) : (Double)data.get(fieldSchema);
                            DecimalFormat df = new DecimalFormat("0.######");
                            value = df.format(planQty);
                        }
                        uiBotModel.getPageData().put((Object)fieldSchema, (Object)Field.createZtbField((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (Integer)FieldValueStyleTypeEnum.VALUE_BLACK.getValue(), (String)value, (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue()));
                        break;
                    }
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)Field.createZtbField((String)this.localeService.getLanguageValue(locale, layout.getLabel()), (Integer)FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), (Integer)FieldValueStyleTypeEnum.VALUE_BLACK.getValue(), (String)ModuleUtils.emptyValueToHyphen(data.get(fieldSchema)), (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue()));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)uiBotModel.getPageData().get((Object)fieldSchema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)bottomButton.getName()));
                        if (!bottomButton.getIsCheckButton().booleanValue()) continue;
                        Action action = bottomButton.getAction();
                        rawData.put("isAPC", true);
                        rawData.put("pageId", apiRequest.getPageId());
                        action.setRawData((Object)rawData);
                    }
                    uiBotModel.getPageData().put((Object)fieldSchema, (Object)buttons);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private RelationRule buildRelationRule() {
        RelationRule relationRule = new RelationRule();
        ArrayList<CommonRule> ruleList = new ArrayList<CommonRule>(1);
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule.setTargetSchema("plan_complete_date");
        ArrayList<TargetDatetime> targetDatetime = new ArrayList<TargetDatetime>(1);
        TargetDatetime datetime = new TargetDatetime();
        datetime.setLinkageSchema("plan_start_date");
        datetime.setDatetimeType(Integer.valueOf(5));
        targetDatetime.add(datetime);
        commonRule.setTargetDatetime(targetDatetime);
        ruleList.add(commonRule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

