/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildReconciliationProgressNoticeDetailStrategy")
public class TaskDetailBuildReconciliationProgressNoticeDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressNoticeDetailStrategy.class);
    private static final String ALREADY_NOTICE = "1";
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress Notice Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        Map arDataDetail = (Map)apiRawData.get((Object)"ar_data_detail");
        List arDataList = this.digiwinEspProxyService.getAacrArdateInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, this.buildgetAacrArdateReq(arDataDetail));
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = new CustomTabs();
                    Map nameMap = this.buildNameMap(locale);
                    Map<String, List<Map>> arDataMapByDocType = arDataList.stream().collect(Collectors.groupingBy(e -> (String)e.get("doc_type")));
                    List<Map> notBillingQtyList = arDataMapByDocType.get("cs");
                    customTabs.add((Object)this.buildCustomTab(notBillingQtyList, nameMap, apiRawData, this.localeService.getLanguageValue(locale, "\u8f85\u5bfc"), arDataDetail.get("not_billing_qty"), locale));
                    List<Map> notSettlementQtyList = arDataMapByDocType.get("aacr");
                    customTabs.add((Object)this.buildCustomTab(notSettlementQtyList, nameMap, apiRawData, this.localeService.getLanguageValue(locale, "\u5ba2\u5236"), arDataDetail.get("not_settlement_qty"), locale));
                    List<Map> notApplicationBusinessQtyList = arDataMapByDocType.get("ps");
                    customTabs.add((Object)this.buildCustomTab(notApplicationBusinessQtyList, nameMap, apiRawData, this.localeService.getLanguageValue(locale, "\u5de5\u7a0b"), arDataDetail.get("not_application_business_qty"), locale));
                    pageData.put((Object)schema, (Object)customTabs);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private CustomTab buildCustomTab(List<Map<String, Object>> dataList, Map<String, String> nameMap, ApiRawData apiRawData, String tabName, Object hour, String locale) {
        if (CollectionUtils.isEmpty(dataList)) {
            return this.buidlEmptyTab(tabName, nameMap, locale);
        }
        List<CustomTabContentContainer> customTabContentContainerList = new ArrayList();
        for (Map<String, Object> data : dataList) {
            LinkedList<CardContent> contentList = new LinkedList<CardContent>();
            contentList.add(this.buildCardContent(nameMap.get("laborHours"), (Object)this.buildHour(data, nameMap, "labor_hours")));
            contentList.add(this.buildCardContent(nameMap.get("processWorkHours"), (Object)this.buildHour(data, nameMap, "process_work_hours")));
            Double processWorkHours = (Double)MapUtil.getOrDefault(data, (String)"process_work_hours", (Object)0.0);
            Double processHours = (Double)MapUtil.getOrDefault(data, (String)"process_hours", (Object)0.0);
            BigDecimal bigDecimal = BigDecimal.valueOf(processWorkHours).subtract(BigDecimal.valueOf(processHours));
            String waitHour = bigDecimal.compareTo(BigDecimal.ZERO) < 0 ? "0" : bigDecimal.toString();
            contentList.add(this.buildCardContent(nameMap.get("waitHour"), (Object)(this.handleHour(waitHour) + nameMap.get("hour"))));
            String acceptedDate = null;
            acceptedDate = Objects.isNull(data.get("accepted_date")) || StringUtils.isEmpty((CharSequence)((String)data.get("accepted_date"))) ? this.handleAcceptedDate(data.get("plan_complete_set_date")) : this.handleAcceptedDate(data.get("accepted_date"));
            contentList.add(this.buildCardContent(nameMap.get("acceptedDate"), (Object)acceptedDate));
            contentList.add(this.buildCardContent(nameMap.get("localCurrPrice"), data.get("local_curr_price")));
            contentList.add(this.buildCardContent(nameMap.get("reasonCodeName"), data.get("reason_code_name")));
            Picture picture = this.buildPicture(data, nameMap);
            if (!Objects.isNull(picture)) {
                contentList.add(new CardContent("", picture));
            }
            String arNo = (String)MapUtil.getOrDefault(data, (String)"ar_no", (Object)"");
            String subTitle = !ALREADY_NOTICE.equals(String.valueOf(data.get("billing_code"))) ? nameMap.get("waitNotice") : nameMap.get("alreadyNotice");
            List buttonList = this.buildButtonList(data, nameMap, apiRawData, locale);
            Card arDataDetailCard = Card.create((String)arNo, (String)subTitle, contentList, (List)buttonList, (String)"#F8F8FC");
            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setContentCmptType("CARD");
            customTabContentContainer.setData((Object)arDataDetailCard);
            customTabContentContainerList.add(customTabContentContainer);
        }
        customTabContentContainerList = this.sortCustomTabContentContainerListByDate(customTabContentContainerList, nameMap);
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName + "(" + this.handleHour(String.valueOf(hour)) + nameMap.get("hour") + ")");
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        customTab.setContent(customTabContentContainerList);
        customTab.setIsSelected(Boolean.valueOf(true));
        return customTab;
    }

    private Picture buildPicture(Map<String, Object> data, Map<String, String> nameMap) {
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>(3);
        if (!Objects.isNull(data.get("contract_attachment")) && StringUtils.isNotEmpty((CharSequence)((String)data.get("contract_attachment")))) {
            AttachmentFile contractAttachment = new AttachmentFile();
            contractAttachment.setPreviewUrl((String)data.get("contract_attachment"));
            fileList.add(contractAttachment);
        }
        if (!Objects.isNull(data.get("delivery_attachment")) && StringUtils.isNotEmpty((CharSequence)((String)data.get("delivery_attachment")))) {
            AttachmentFile deliveryAttachment = new AttachmentFile();
            deliveryAttachment.setPreviewUrl((String)data.get("delivery_attachment"));
            fileList.add(deliveryAttachment);
        }
        if (!Objects.isNull(data.get("project_attachment")) && StringUtils.isNotEmpty((CharSequence)((String)data.get("project_attachment")))) {
            AttachmentFile projectAttachment = new AttachmentFile();
            projectAttachment.setPreviewUrl((String)data.get("project_attachment"));
            fileList.add(projectAttachment);
        }
        if (CollectionUtils.isEmpty(fileList)) {
            return null;
        }
        Picture picture = new Picture();
        picture.setTitle(nameMap.get("attachemnt"));
        picture.setFileList(fileList);
        picture.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setUsePreviewUrl(Boolean.valueOf(true));
        picture.setRows(Integer.valueOf(1));
        return picture;
    }

    private List<Button> buildButtonList(Map<String, Object> data, Map<String, String> nameMap, ApiRawData apiRawData, String locale) {
        HashMap<String, Object> rawData;
        ArrayList<Button> buttonList = new ArrayList<Button>();
        if (!ALREADY_NOTICE.equals(String.valueOf(data.get("billing_code")))) {
            Action noticePayAction = new Action();
            noticePayAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_CALL_PAYMENT.toString());
            noticePayAction.setJumpPageTitle(this.localeService.getLanguageValue(locale, "\u901a\u77e5\u8bf7\u6b3e"));
            noticePayAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            noticePayAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
            rawData = new HashMap();
            rawData.put("ar_data", data);
            rawData.put("buttonType", "noticePay");
            rawData.put("refreshDataId", apiRawData.get((Object)"refreshDataId"));
            noticePayAction.setRawData(rawData);
            buttonList.add(Button.createButton((String)nameMap.get("noticeAccount"), (String)UUIDUtil.getUuid(), (Integer)BottomButtonStyleEnum.DETAIL_NORMAL.getValue(), (Action)noticePayAction));
        }
        Action progressReportAction = new Action();
        progressReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_REPORT.toString());
        progressReportAction.setJumpPageTitle(nameMap.get("progressReport"));
        progressReportAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        progressReportAction.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
        rawData = new HashMap<String, Object>();
        rawData.put("ar_data", data);
        rawData.put("refreshDataId", apiRawData.get((Object)"refreshDataId"));
        progressReportAction.setRawData(rawData);
        buttonList.add(Button.createButton((String)nameMap.get("progressReport"), (String)UUIDUtil.getUuid(), (Integer)BottomButtonStyleEnum.DETAIL_STRESS.getValue(), (Action)progressReportAction));
        return buttonList;
    }

    private Map<String, Object> buildgetAacrArdateReq(Map<String, Object> arDataDetail) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        JSONObject woReportData = new JSONObject();
        woReportData.put("customer_no", arDataDetail.get("customer_no"));
        woReportData.put("status", (Object)"0");
        JSONArray array = new JSONArray();
        array.add((Object)woReportData);
        requestMap.put("query_condition", array);
        return requestMap;
    }

    private List<CustomTabContentContainer> sortCustomTabContentContainerListByDate(List<CustomTabContentContainer> customTabContentContainerList, Map<String, String> nameMap) {
        List customTabContentContainerDateNotExistList = customTabContentContainerList.stream().filter(e -> {
            Card card = (Card)e.getData();
            CardContent cardContent01 = card.getContent().stream().filter(item -> ((String)nameMap.get("acceptedDate")).equals(item.getLabel())).findFirst().get();
            return StringUtils.isEmpty((CharSequence)cardContent01.getValue());
        }).collect(Collectors.toList());
        List<CustomTabContentContainer> customTabContentContainerDateExistList = customTabContentContainerList.stream().filter(e -> {
            Card card = (Card)e.getData();
            CardContent cardContent01 = card.getContent().stream().filter(item -> ((String)nameMap.get("acceptedDate")).equals(item.getLabel())).findFirst().get();
            return StringUtils.isNotEmpty((CharSequence)cardContent01.getValue());
        }).collect(Collectors.toList());
        customTabContentContainerDateExistList = customTabContentContainerDateExistList.stream().sorted((o1, o2) -> {
            Card card01 = (Card)o1.getData();
            String date01 = card01.getContent().stream().filter(e -> ((String)nameMap.get("acceptedDate")).equals(e.getLabel())).findFirst().get().getValue();
            Card card02 = (Card)o2.getData();
            String date02 = card02.getContent().stream().filter(e -> ((String)nameMap.get("acceptedDate")).equals(e.getLabel())).findFirst().get().getValue();
            LocalDate o1SDate = DateTimeUtil.parseLocalDateUseDefaultPattern((String)date01);
            LocalDate o2SDate = DateTimeUtil.parseLocalDateUseDefaultPattern((String)date02);
            return o1SDate.compareTo(o2SDate);
        }).collect(Collectors.toList());
        customTabContentContainerDateExistList.addAll(customTabContentContainerDateNotExistList);
        return customTabContentContainerDateExistList;
    }

    private String handleAcceptedDate(Object acceptedDate) {
        if (Objects.isNull(acceptedDate) || StringUtils.isEmpty((CharSequence)((String)acceptedDate))) {
            return "";
        }
        String acceptedDateStr = String.valueOf(acceptedDate);
        acceptedDateStr = acceptedDateStr.substring(0, 10).replaceAll("/", "-");
        return acceptedDateStr;
    }

    private Map<String, String> buildNameMap(String locale) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        String laborHours = this.localeService.getLanguageValue(locale, "\u8ba1\u4ef7");
        nameMap.put("laborHours", laborHours);
        String processWorkHours = this.localeService.getLanguageValue(locale, "\u5df2\u9a8c");
        nameMap.put("processWorkHours", processWorkHours);
        String waitHour = this.localeService.getLanguageValue(locale, "\u5f85\u8bf7");
        nameMap.put("waitHour", waitHour);
        String acceptedDate = this.localeService.getLanguageValue(locale, "\u9a8c\u6536\u65e5");
        nameMap.put("acceptedDate", acceptedDate);
        String localCurrPrice = this.localeService.getLanguageValue(locale, "\u6700\u8fd1\u5355\u4ef7");
        nameMap.put("localCurrPrice", localCurrPrice);
        String reasonCodeName = this.localeService.getLanguageValue(locale, "\u72b6\u51b5");
        nameMap.put("reasonCodeName", reasonCodeName);
        String attachemnt = this.localeService.getLanguageValue(locale, "\u9644\u4ef6");
        nameMap.put("attachemnt", attachemnt);
        String noticeAccount = this.localeService.getLanguageValue(locale, "\u901a\u77e5\u8bf7\u6b3e");
        nameMap.put("noticeAccount", noticeAccount);
        String progressReport = this.localeService.getLanguageValue(locale, "\u8fdb\u5ea6\u56de\u62a5");
        nameMap.put("progressReport", progressReport);
        String alreadyNotice = this.localeService.getLanguageValue(locale, "\u5df2\u901a\u77e5");
        nameMap.put("alreadyNotice", alreadyNotice);
        String waitNotice = this.localeService.getLanguageValue(locale, "\u5f85\u901a\u77e5");
        nameMap.put("waitNotice", waitNotice);
        String hour = this.localeService.getLanguageValue(locale, "\u5c0f\u65f6");
        nameMap.put("hour", hour);
        return nameMap;
    }

    private CustomTab buidlEmptyTab(String name, Map<String, String> nameMap, String locale) {
        String tabName = name + "(0" + nameMap.get("hour") + ")";
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(Integer.valueOf(2));
        customTab.setAlignmentType(Integer.valueOf(1));
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        customTabContentContainer.setData((Object)Empty.create((String)this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e")));
        customTabContentContainer.setContentCmptType("EMPTY");
        customTab.setContent(Collections.singletonList(customTabContentContainer));
        return customTab;
    }

    private String buildHour(Map<String, Object> arData, Map<String, String> nameMap, String labelName) {
        String value = this.handleHour(String.valueOf(MapUtil.getOrDefault(arData, (String)labelName, (Object)"0")));
        String hour = value + nameMap.get("hour");
        return hour;
    }

    private String handleHour(String hour) {
        if (StringUtils.isEmpty((CharSequence)hour)) {
            return "0";
        }
        return new BigDecimal(hour).stripTrailingZeros().toPlainString();
    }

    private CardContent buildCardContent(String name, Object value) {
        return new CardContent(name, Objects.isNull(value) ? "-" : String.valueOf(value), Boolean.valueOf(false), Integer.valueOf(1));
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

