/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildReplaceReportTaskExecutorDetailStrategy")
public class TaskDetailBuildReplaceReportTaskExecutorDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReplaceReportTaskExecutorDetailStrategy.class);
    private static final String ESP_EMPLOYEE_INFO_PROCESS = "esp_employee.info.process";
    private static final String EMPLOYEE_INFO_PROCESS = "employee.info.process";
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Replace Report Executor Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        List uiBotLayouts = uiBotModel.getLayout();
        List actionSubmitParamList = apiRequest.getSubmitParam();
        if (!CollectionUtils.isEmpty((Collection)actionSubmitParamList)) {
            Optional<ActionSubmitParam> totalWorkHoursActionOpt;
            InputNumeric workHours;
            Optional<ActionSubmitParam> workHoursOpt = actionSubmitParamList.stream().filter(e -> "work_hours".equalsIgnoreCase(e.getSchema())).findFirst();
            if (workHoursOpt.isPresent() && !CollectionUtils.isEmpty((Map)(workHours = (InputNumeric)JsonUtil.objectToJavaObject((Object)workHoursOpt.get().getParams(), InputNumeric.class)).getRawData())) {
                apiRawData.put("executorInfoByGroupList", workHours.getRawData().get("groupSubmitParamList"));
            }
            if ((totalWorkHoursActionOpt = actionSubmitParamList.stream().filter(e -> "total_work_hours".equalsIgnoreCase(e.getSchema())).findFirst()).isPresent()) {
                InputNumeric totalWorkHoursInputNumeric = (InputNumeric)JsonUtil.objectToJavaObject((Object)totalWorkHoursActionOpt.get().getParams(), InputNumeric.class);
                apiRawData.put("totalWorkHours", (Object)totalWorkHoursInputNumeric.getText());
            }
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                    this.handleCustomGroup(customGroup, apiRawData, locale);
                    uiBotModel.getPageData().put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton((String)locale));
                    BottomButtonDigiwinAthena confirmeButton = new BottomButtonDigiwinAthena();
                    confirmeButton.setName(this.localeService.getLanguageValue(locale, "\u4e0b\u4e00\u6b65"));
                    Action buttonAction = new Action();
                    buttonAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPLACE_REPORT_TASK_DETAIL.toString());
                    buttonAction.setJumpPageTitle(this.localeService.getLanguageValue(locale, "\u6267\u884c\u4eba\u6e05\u5355"));
                    buttonAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    buttonAction.setRawData((Object)apiRawData);
                    confirmeButton.setAction(buttonAction);
                    confirmeButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                    bottomButtonList.add(confirmeButton);
                    uiBotModel.getPageData().put((Object)schema, bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private void handleCustomGroup(CustomGroup customGroup, ApiRawData apiRawData, String locale) {
        CustomGroupContent customGroupContent = customGroup.getContent();
        List customGroupUiBotLayouts = customGroupContent.getLayout();
        for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayouts) {
            String customGroupSchema = customGroupUiBotLayout.getSchema();
            switch (customGroupUiBotLayout.getType()) {
                case "WINDOW_MULTI_SELECT": {
                    InputWindowMultiSelect inputWindowMultiSelect = this.buildInputWindowMultiSelect(customGroupUiBotLayout, apiRawData, customGroupSchema, locale);
                    customGroupContent.getPageData().put((Object)customGroupSchema, (Object)inputWindowMultiSelect);
                }
            }
        }
    }

    private InputWindowMultiSelect buildInputWindowMultiSelect(UiBotLayout uiBotLayout, ApiRawData apiRawData, String schema, String locale) {
        Map rawDataMap = this.buildEmployeeDataSourceList();
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setTitle(this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        inputWindowMultiSelect.setRawData(rawDataMap);
        inputWindowMultiSelect.setType("WINDOW_SINGLE_SELECT");
        inputWindowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowMultiSelect.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9"));
        List groupSubmitParamList = (List)JsonUtil.objectToJavaObject((Object)apiRawData.get((Object)"executorInfoByGroupList"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (!CollectionUtils.isEmpty((Collection)groupSubmitParamList)) {
            List iputWindowSingleSelectList = groupSubmitParamList.stream().flatMap(Collection::stream).filter(e -> "WINDOW_SINGLE_SELECT".equalsIgnoreCase(e.getType())).map(e -> {
                InputWindowSingleSelect iputWindowSingleSelect = (InputWindowSingleSelect)JsonUtil.objectToJavaObject((Object)e.getParams(), InputWindowSingleSelect.class);
                return iputWindowSingleSelect;
            }).collect(Collectors.toList());
            inputWindowMultiSelect.setSelectIdList(iputWindowSingleSelectList.stream().map(InputWindowSingleSelect::getSelectId).collect(Collectors.toList()));
            inputWindowMultiSelect.setTextList(iputWindowSingleSelectList.stream().map(InputWindowSingleSelect::getTitle).collect(Collectors.toList()));
        }
        return inputWindowMultiSelect;
    }

    private Map<String, Object> buildEmployeeDataSourceList() {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId(ESP_EMPLOYEE_INFO_PROCESS);
        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setCategory("ESP");
        pcUiBotQueryAction.setActionId(ESP_EMPLOYEE_INFO_PROCESS);
        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotActionServiceId.setName(EMPLOYEE_INFO_PROCESS);
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);
        HashMap<String, String> projectMemberInfoMap = new HashMap<String, String>(1);
        projectMemberInfoMap.put("project_no", "");
        HashMap parasMap = new HashMap(1);
        parasMap.put("project_member_info", Collections.singletonList(projectMemberInfoMap));
        pcUiBotQueryAction.setParas(parasMap);
        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);
        HashMap<String, List<PcUiBotDataSourceDTO>> dataSourceListMap = new HashMap<String, List<PcUiBotDataSourceDTO>>(1);
        dataSourceListMap.put("dataSourceList", Collections.singletonList(pcUiBotDataSourceDTO));
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        paramMap.put("executeContext", Collections.emptyMap());
        return paramMap;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

