/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.event;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.EventData;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseAniaEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.domain.SseScrumEventEnum;
import com.digiwin.mobile.mobileuibot.agileData.sse.dto.SSEBaseEvent;
import com.digiwin.mobile.mobileuibot.agileData.sse.service.impl.event.SSEOnEventService;
import com.digiwin.mobile.mobileuibot.agileData.sse.utils.SseEmitterUtils;
import okhttp3.sse.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class SSEOnEventAdtServiceImpl
extends SSEOnEventService {
    private static final Logger log = LoggerFactory.getLogger(SSEOnEventAdtServiceImpl.class);

    public void onEvent(SSEBaseEvent sseBaseEvent, EventSource eventSource, String type, String data) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject((String)data);
        String status = res.getString("status");
        log.info("type:{}", (Object)type);
        if (SseAniaEventEnum.CHAT_DONE.getEvent().equals(type)) {
            this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
        } else if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)) {
            SseEmitterUtils.sendAnswerDone((SseEmitter)sseEmitter, (boolean)true);
        } else if (SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)) {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)sseBaseEvent.getId(), (String)status);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), sseEmitter, eventMessage);
        } else if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)) {
            eventSource.cancel();
        } else {
            EventData.EventMessage eventMessage = EventData.EventMessage.builderMessageV2((JSONObject)res, (String)sseBaseEvent.getId());
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
        }
    }
}

