/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.api;

import com.digiwin.mobile.mobileuibot.api.EnumConstraint;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumConstraintValidator
implements ConstraintValidator<EnumConstraint, Object> {
    private List<Object> values = new ArrayList();
    private Class<? extends Enum<?>> enumClass;

    public void initialize(EnumConstraint constraintAnnotation) {
        this.enumClass = constraintAnnotation.enumClass();
        String valueMethod = constraintAnnotation.valueMethod();
        try {
            Method method = this.enumClass.getDeclaredMethod(valueMethod, new Class[0]);
            this.values = Arrays.stream(this.enumClass.getEnumConstants()).map(e -> {
                try {
                    return method.invoke(e, new Object[0]);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.toList());
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("\u679a\u4e3e\u7c7b" + this.enumClass.getName() + "\u7f3a\u5c11\u65b9\u6cd5: " + valueMethod, e2);
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null || value.toString().trim().isEmpty()) {
            return true;
        }
        if (this.values.contains(value)) {
            return true;
        }
        String resolvedMessage = context.getDefaultConstraintMessageTemplate().replace("{value}", value.toString()).replace("{enumClass}", this.enumClass.getSimpleName()).replace("{values}", this.values.stream().map(Object::toString).collect(Collectors.joining(", ")));
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(resolvedMessage).addConstraintViolation();
        return false;
    }
}

