/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.http.DigiwinHttpReqMsgInterceptor;
import com.digiwin.mobile.mobileuibot.common.http.DigiwinHttpReqTimeInterceptor;
import com.digiwin.mobile.mobileuibot.common.http.DigiwinHttpResponseErrorHandler;
import com.digiwin.mobile.mobileuibot.common.http.constant.TimeOutEnum;
import com.digiwin.mobile.mobileuibot.config.RestTemplateConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HeaderElement;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.NumberUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@DependsOn(value={"baseConfig"})
@Configuration
public class RestTemplateConfig {
    @Bean
    public DigiwinHttpReqMsgInterceptor digiwinHttpReqMsgInterceptor() {
        return new DigiwinHttpReqMsgInterceptor();
    }

    @Bean
    @Primary
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        RestTemplateBuilder restTemplateBuilder = builder.setConnectTimeout(this.getConnectTimeoutDuration()).setReadTimeout(this.getReadTimeoutDuration());
        return this.restTemplateBuilder(restTemplateBuilder);
    }

    @Bean
    public RestTemplate asaRestTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }

    @Bean
    public ClientHttpRequestFactory httpRequestFactory() {
        1 requestFactory = new /* Unavailable Anonymous Inner Class!! */;
        return requestFactory;
    }

    public HttpClient httpClient() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(1000);
        connectionManager.setDefaultMaxPerRoute(300);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(2000).setConnectionRequestTimeout(200).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true)).setKeepAliveStrategy((response, context) -> {
            BasicHeaderElementIterator iterator = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (iterator.hasNext()) {
                HeaderElement headerElement = iterator.nextElement();
                String param = headerElement.getName();
                String value = headerElement.getValue();
                if (null == value || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return 60L;
        }).build();
    }

    private RestTemplate restTemplateBuilder(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.requestFactory(() -> {
            Properties props = System.getProperties();
            if ("true".equals(props.getProperty("http.proxySet"))) {
                String host = props.getProperty("http.proxyHost");
                String port = props.getProperty("http.proxyPort");
                SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
                InetSocketAddress address = new InetSocketAddress(host, (int)((Integer)NumberUtils.parseNumber((String)port, Integer.class)));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                simpleClientHttpRequestFactory.setProxy(proxy);
                return simpleClientHttpRequestFactory;
            }
            if (props.containsKey("https.proxySet")) {
                String host = props.getProperty("https.proxyHost");
                String port = props.getProperty("https.proxyPort");
                SSLContext sc = null;
                try {
                    sc = SSLContext.getInstance("SSL");
                    sc.init(null, new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */}, new SecureRandom());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
                InetSocketAddress address = new InetSocketAddress(host, (int)((Integer)NumberUtils.parseNumber((String)port, Integer.class)));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                simpleClientHttpRequestFactory.setProxy(proxy);
                return simpleClientHttpRequestFactory;
            }
            return new OkHttp3ClientHttpRequestFactory();
        }).interceptors(new ClientHttpRequestInterceptor[]{this.digiwinHttpReqMsgInterceptor(), new DigiwinHttpReqTimeInterceptor()}).errorHandler((ResponseErrorHandler)new DigiwinHttpResponseErrorHandler()).defaultHeader("Content-Type", new String[]{MediaType.APPLICATION_JSON.toString()}).build();
    }

    private Duration getConnectTimeoutDuration() {
        return TimeOutEnum.getDuration();
    }

    private Duration getReadTimeoutDuration() {
        return TimeOutEnum.getDuration();
    }
}

