/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.filter;

import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Component
@WebFilter(urlPatterns={"/*"}, filterName="corsFilter", asyncSupported=true)
public class CorsFilter
implements Filter {
    @Autowired
    private SysEnvConfig config;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean always;
        String allowOrigin = this.config.getAllowedOrigin();
        String requestOrigin = ((HttpServletRequest)servletRequest).getHeader("Origin");
        boolean bl = always = "*".equals(allowOrigin) || StringUtils.isEmpty((CharSequence)requestOrigin);
        if (always || StringUtils.isNotEmpty((CharSequence)allowOrigin) && StringUtils.isNotEmpty((CharSequence)requestOrigin)) {
            List<String> allowOriginList = Arrays.asList(StringUtils.split((String)allowOrigin, (String)","));
            if (always || allowOriginList.contains(requestOrigin)) {
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                response.setHeader("Access-Control-Allow-Origin", always ? "*" : requestOrigin);
                response.setHeader("Access-Control-Allow-Credentials", "true");
                response.setHeader("Access-Control-Max-Age", "3600");
                response.setHeader("Access-Control-Allow-Methods", "*");
                response.setHeader("Access-Control-Allow-Headers", "*");
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)filterConfig.getServletContext());
        super.init(filterConfig);
    }

    public void destroy() {
        super.destroy();
    }
}

