/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.config.request.RequestWrapper;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.runtime.PcUiBotRuntimes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@WebFilter(urlPatterns={"/*"}, filterName="channelFilter", asyncSupported=true)
public class ChannelFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            TraceIdUtil.set();
            logger.debug("================\u8fdb\u5165\u8fc7\u6ee4\u5668======================");
            if (servletRequest.getContentType() != null && servletRequest.getContentType().contains("multipart/form-data;")) {
                filterChain.doFilter(servletRequest, servletResponse);
                TraceIdUtil.remove();
                return;
            }
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            RequestWrapper requestWrapper = new RequestWrapper(httpServletRequest);
            this.modifyRequestParams(requestWrapper);
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
            TraceIdUtil.remove();
        }
        finally {
            PcUiBotRuntimes.clear();
        }
    }

    private void modifyRequestParams(RequestWrapper requestWrapper) {
        try {
            List<String> locales = Arrays.asList(Locale.SIMPLIFIED_CHINESE.toString(), Locale.TRADITIONAL_CHINESE.toString(), Locale.US.toString());
            String defaultLocale = Locale.SIMPLIFIED_CHINESE.toString();
            if (AppEnvDeployAreaEnum.TW.name().equals(AppContext.getEnvDeployArea())) {
                defaultLocale = Locale.TRADITIONAL_CHINESE.toString();
            }
            if (requestWrapper.getContentType() != null && requestWrapper.getContentType().contains("application/json")) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(requestWrapper.getBodyString());
                if (jsonNode.has("locale")) {
                    String locale = jsonNode.get("locale").asText();
                    if (!locales.contains(locale)) {
                        ((ObjectNode)jsonNode).put("locale", defaultLocale);
                        requestWrapper.setBody(objectMapper.writeValueAsBytes((Object)jsonNode));
                    }
                } else {
                    String locale = requestWrapper.getParameter("locale");
                    if (StringUtils.hasLength((String)locale) && !locales.contains(locale)) {
                        requestWrapper.addParameter("locale", (Object)defaultLocale);
                    }
                }
            } else {
                String locale = requestWrapper.getParameter("locale");
                if (StringUtils.hasLength((String)locale) && !locales.contains(locale)) {
                    requestWrapper.addParameter("locale", (Object)defaultLocale);
                }
            }
        }
        catch (Exception e) {
            logger.error("modifyRequestParams error", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void destroy() {
        super.destroy();
    }
}

