/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request.log;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class PerformanceLogInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceLogInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        StopWatch stopWatch = new StopWatch(request.getRequestURI());
        stopWatch.start(handler.toString());
        request.setAttribute("stopWatch", (Object)stopWatch);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        StopWatch stopWatch = (StopWatch)request.getAttribute("stopWatch");
        stopWatch.stop();
        logger.debug("{}, {} ms", (Object)stopWatch.shortSummary(), (Object)stopWatch.getTotalTimeMillis());
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
    }
}

