/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotService;
import com.digiwin.mobile.mobileuibot.core.UiBotServiceImpl;
import com.digiwin.mobile.mobileuibot.core.appec.ComponentBox;
import com.digiwin.mobile.mobileuibot.core.appec.LeftFooter;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigRight;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTypeEnum;
import com.digiwin.mobile.mobileuibot.core.appec.UiBotSlip;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionServiceImpl;
import com.digiwin.mobile.mobileuibot.core.component.action.BusinessRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.DigiwinActionSubmitParas;
import com.digiwin.mobile.mobileuibot.core.component.custom.CustomContentRequest;
import com.digiwin.mobile.mobileuibot.core.component.search.SearchCategory;
import com.digiwin.mobile.mobileuibot.core.component.webview.WebviewPanel;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.ai.service.DigiwinAiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dap.DapResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTbbReport;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.UserIntegrity;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.model.EocSetInfo;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UibotModelTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uiBotService")
public class UiBotServiceImpl
implements UiBotService {
    private static final Logger log = LoggerFactory.getLogger(UiBotServiceImpl.class);
    @Autowired
    private HttpService httpService;
    @Autowired
    private UiBotModelBuildStrategyFactory uiBotModelBuildStrategyFactory;
    @Autowired
    private UiBotCompDataBuildStrategyFactory uiBotCompDataBuildStrategyFactory;
    @Autowired
    private DigiwinAiProxyService digiwinAiProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgemapsProxyService;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;
    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private UserCardListFilterService userCardsFilterService;
    @Autowired
    ActionServiceImpl actionService;

    public UiBotModel buildRenderPageModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        String pageId;
        UiBotModelBuildStrategy strategy = null;
        if (pageSetting == null) {
            pageId = apiRequest.getPageId();
            pageSetting = new PageSetting();
            pageSetting.setPageId(pageId);
        } else {
            pageId = pageSetting.getPageId();
        }
        PageSettingIdPresetEnum pageIdEnum = PageSettingIdPresetEnum.getEnumByName((String)pageId);
        if (pageIdEnum == null) {
            pageIdEnum = SourceCategoryEnum.PROJECT.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_MILESTONE_UNIVERSAL_PARSING_PAGE : (SourceCategoryEnum.DATA_ENTRY.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_BASIC_DATA_UNIVERSAL_PARSING_PAGE : (SourceCategoryEnum.DATA_ENTRY_MODEL_DRIVEN.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_DATA_ENTRY_DRIVEN_ITEM_PARSING_PAGE : (SourceCategoryEnum.START_PROJECT.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_START_PROJECT_DSL_UNIVERSAL_PARSING_PAGE : (SourceCategoryEnum.WORK_REPORT_INFO.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_PCC_WORK_REPORT_INFO_DSL_UNIVERSAL_PARSING_PAGE : (SourceCategoryEnum.APC_STAND_PRODUCTION_PROGRESS.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_UNIVERSAL_PARSING_PAGE : (SourceCategoryEnum.WORKBENCH.name().equals(apiRequest.getRawData().getString("sourceCategory")) ? PageSettingIdPresetEnum.MOBILE_ATHENA_WORKBENCH_UNIVERSAL_PARSING_PAGE : PageSettingIdPresetEnum.MOBILE_ATHENA_DESIGNER_UNIVERSAL_PARSING_PAGE))))));
        }
        Integer modelType = UibotModelTypeEnum.DEFAULT_PAGE_MODEL.getValue();
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$pagesetting$PageSettingIdPresetEnum[pageIdEnum.ordinal()]) {
            case 1: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildIndexPortalStrategy");
                break;
            }
            case 2: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildIndexStrategy");
                break;
            }
            case 3: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildNotificationPageStrategy");
                break;
            }
            case 4: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uibotModelBuildDashboardStrategy");
                break;
            }
            case 5: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyTaskListStrategy");
                break;
            }
            case 6: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTripartiteToDoListStrategy");
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyTaskDetailStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            }
            case 28: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildMyApprovalTaskItemDetailStrategy");
                break;
            }
            case 29: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApprovalTaskProgressStrategy");
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildNotificationStrategy");
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildActionPageStrategy");
                break;
            }
            case 42: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectListStrategy");
                break;
            }
            case 43: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildJumpProjectOrTaskListStrategy");
                break;
            }
            case 44: 
            case 45: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccProjectDetailStrategy");
                break;
            }
            case 46: {
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildProjectNextLevelListStrategy");
                break;
            }
            case 47: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccProjectPlanDetailStrategy");
                break;
            }
            case 48: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccProjectPlanBasicDetailStrategy");
                break;
            }
            case 49: 
            case 50: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildKscProjectDetailStrategy");
                break;
            }
            case 51: {
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildSystemCloudHouseKeeperChooseTemplateStrategy");
                break;
            }
            case 52: {
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildSystemCloudHouseKeeperEditTaskStrategy");
                break;
            }
            case 53: {
                strategy = this.uiBotModelBuildStrategyFactory.get("projectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy");
                break;
            }
            case 54: 
            case 55: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildDetailItemDetailStrategy");
                break;
            }
            case 56: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectCreateStrategy");
                break;
            }
            case 57: 
            case 58: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelECNProjectDetailStrategy");
                break;
            }
            case 59: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelStandardProjectDetailStrategy");
                break;
            }
            case 60: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelSmartSearchStrategy");
                break;
            }
            case 61: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelSearchItemDetailStrategy");
                break;
            }
            case 62: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelLeftSlipStrategy");
                break;
            }
            case 63: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildManualTaskDetailStrategy");
                break;
            }
            case 64: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildManualTaskDetailActionStrategy");
                break;
            }
            case 65: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccTailTaskStrategy");
                break;
            }
            case 66: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildKscTailTaskStrategy");
                break;
            }
            case 67: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPccMaterialStrategy");
                break;
            }
            case 68: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildKscMaterialStrategy");
                break;
            }
            case 69: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildSearchItemDetailStrategy");
                break;
            }
            case 70: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcWorkingHourReportDetailStrategy");
                break;
            }
            case 71: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleReportDetailStrategy");
                break;
            }
            case 72: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleReportMkpDetailStrategy");
                break;
            }
            case 73: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcAbnormalReportDetailStrategy");
                break;
            }
            case 74: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPersonnelOnlineStateStrategy");
                break;
            }
            case 75: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPersonnelOnlineGroupStrategy");
                break;
            }
            case 76: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildPersonnelOnlineGroupDetailStrategy");
                break;
            }
            case 77: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCarMessageStrategy");
                break;
            }
            case 78: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCarListStrategy");
                break;
            }
            case 79: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCarCodeStrategy");
                break;
            }
            case 80: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBScanReceiveOrderStrategy");
                break;
            }
            case 81: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBShippingTaskStrategy");
                break;
            }
            case 82: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBShippingTaskQrCodeStrategy");
                break;
            }
            case 83: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBShippingTaskVehicleInfoStrategy");
                break;
            }
            case 84: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBGoodsDepartureStrategy");
                break;
            }
            case 85: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBGoodsLoadingStrategy");
                break;
            }
            case 86: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBGoodsLoadingVehicleInfoStrategy");
                break;
            }
            case 87: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportStrategy");
                break;
            }
            case 88: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportScheduleStrategy");
                break;
            }
            case 89: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportVehicleInfoStrategy");
                break;
            }
            case 90: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportAbnormalAlarmStrategy");
                break;
            }
            case 91: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportForwardingAlarmStrategy");
                break;
            }
            case 92: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptConfirmationRejectionStrategy");
                break;
            }
            case 93: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptPreparationStrategy");
                break;
            }
            case 94: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBConfirmationReceiptPreparationStrategy");
                break;
            }
            case 95: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBModificationReceiptScheduleStrategy");
                break;
            }
            case 96: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptConfirmationStrategy");
                break;
            }
            case 97: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptSignatureStrategy");
                break;
            }
            case 98: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptScheduleChangeStrategy");
                break;
            }
            case 99: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCargoInformationStrategy");
                break;
            }
            case 100: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBProjectLogisticsStrategy");
                break;
            }
            case 101: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildReassignReportStrategy");
                break;
            }
            case 102: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildUibotUniversalParseStrategy");
                break;
            }
            case 103: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildReportListStrategy");
                break;
            }
            case 104: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildAbiReportInfoStrategy");
                break;
            }
            case 105: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildAbiReportDetailStrategy");
                break;
            }
            case 106: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBottomWindowInfoStrategy");
                break;
            }
            case 107: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTeamTaskStrategy");
                break;
            }
            case 108: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTeamProjectStrategy");
                break;
            }
            case 109: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcProjectScheduleReportSubmitStrategy");
                break;
            }
            case 110: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntranceStrategy");
                break;
            }
            case 111: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntryBasicPageStrategy");
                break;
            }
            case 112: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntryBrowsePageStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            }
            case 113: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildBasicDataEntryEditPageStrategy");
                break;
            }
            case 114: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBModifiyAddressStrategy");
                break;
            }
            case 115: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBAddressBookStrategy");
                break;
            }
            case 116: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBDeliveryLoadedItemStrategy");
                break;
            }
            case 117: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBCargoInformationListStrategy");
                break;
            }
            case 118: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcProjectScheduleReportWaitDealListStrategy");
                break;
            }
            case 119: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcSupportBottomStrategy");
                break;
            }
            case 120: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleTransferQuantitySftDetailStrategy");
                break;
            }
            case 121: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcProjectScheduleTransferQuantityMkpDetailStrategy");
                break;
            }
            case 122: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcApprovalReassignBottomStrategy");
                break;
            }
            case 123: 
            case 124: 
            case 125: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcHandelBottomStrategy");
                break;
            }
            case 126: {
                break;
            }
            case 127: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildCustomPatternTaskDetailStrategy");
                break;
            }
            case 128: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            }
            case 129: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineDealDetailStrategy");
                break;
            }
            case 130: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineCancelDetailStrategy");
                break;
            }
            case 131: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcTeamDispatchStrategy");
                modelType = UibotModelTypeEnum.TASK_PAGE_MODEL.getValue();
                break;
            }
            case 132: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBDeliveryLoadEditItemStrategy");
                break;
            }
            case 133: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcTeamDispatchDetailStrategy");
                break;
            }
            case 134: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcTeamDispatchAbnormalReportDetailStrategy");
                break;
            }
            case 135: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcOnlineReportStrategy");
                break;
            }
            case 136: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptSignatureUploadStrategy");
                break;
            }
            case 137: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBReceiptSignatureSignStrategy");
                break;
            }
            case 138: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBArrivalScanConfirmStrategy");
                break;
            }
            case 139: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcWorkHourQuantityConfirmStrategy");
                break;
            }
            case 140: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildOutSourceWorkReportDetailStrategy");
                break;
            }
            case 141: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildOutSourceWorkReportTaskDetailStrategy");
                break;
            }
            case 142: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildOutSourceWorkReportCompleteDetailStrategy");
                break;
            }
            case 143: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineAreaDetailStrategy");
                break;
            }
            case 144: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy");
                break;
            }
            case 145: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportStopAbnormalAlarmStrategy");
                break;
            }
            case 146: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportShiftingAbnormalAlarmStrategy");
                break;
            }
            case 147: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcMergeWorkHourQuantityConfirmStrategy");
                break;
            }
            case 148: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcCommonAttachmentUploadStrategy");
                break;
            }
            case 149: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcCommonAttachmentDetailStrategy");
                break;
            }
            case 150: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildTbdsProductionProcessRecordModifyParamStrategy");
                break;
            }
            case 151: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy");
                break;
            }
            case 152: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTbdsProductionProgressRecordNextStepStrategy");
                break;
            }
            case 153: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBElectronicFenceListStrategy");
                break;
            }
            case 154: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBElectronicFenceDetailStrategy");
                break;
            }
            case 155: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportComingSoonStrategy");
                break;
            }
            case 156: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportForwardingAgentStrategy");
                break;
            }
            case 157: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportFactoryGuideStrategy");
                break;
            }
            case 158: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildZTBTransportFactoryVoucherStrategy");
                break;
            }
            case 159: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy");
                break;
            }
            case 160: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildTbdsProductionProgressRecordReportSubmitStrategy");
                break;
            }
            case 161: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildTbdsProductionProgressReportDetailStrategy");
                break;
            }
            case 162: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReconciliationProgressNoticeDetailStrategy");
                break;
            }
            case 163: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReconciliationProgressReportStrategy");
                break;
            }
            case 164: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReconciliationProgressCallPaymentStrategy");
                break;
            }
            case 165: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildDetectionDataDetailStrategy");
                break;
            }
            case 166: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildPreviousManualTaskDetailStrategy");
                break;
            }
            case 167: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildApcRemarkDetailStrategy");
                break;
            }
            case 168: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReplaceReportTaskExecutorDetailStrategy");
                break;
            }
            case 169: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildReplaceReportTaskDetailStrategy");
                break;
            }
            case 170: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uibotModelBuildPersonelStateMergeDetailStrategy");
                break;
            }
            case 171: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uibotModelBuildPersonalStateOnlineDetailStrategy");
                break;
            }
            case 172: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelDesignerUniversalParsingPageStrategy");
                break;
            }
            case 173: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBasicDataUniversalParsingPageStrategy");
                break;
            }
            case 174: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBizDataEntryDrivenItemParsingPageStrategy");
                break;
            }
            case 175: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelDataDrivenDslUniversalParsingPageStrategy");
                break;
            }
            case 176: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBasicDataBrowseDetailViewDrivenParsingPageStrategy");
                break;
            }
            case 177: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildWorkflowProgressFixationPageStrategy");
                break;
            }
            case 178: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildAgileDataDetailStrategy");
                break;
            }
            case 179: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectCreateV2Strategy");
                break;
            }
            case 180: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelStartProjectUniversalParsingPageStrategy");
                break;
            }
            case 181: {
                strategy = this.uiBotModelBuildStrategyFactory.get("emptyPageStrategy");
                break;
            }
            case 182: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildPccWorkReportInfoStrategy");
                break;
            }
            case 183: {
                strategy = this.uiBotModelBuildStrategyFactory.get("taskDetailBuildPccWorkReportInfoUniversalParsingStrategy");
                break;
            }
            case 184: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildQrCodeSearchTaskListStrategy");
                break;
            }
            case 185: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildCardlistConvertTablePageStrategy");
                break;
            }
            case 186: {
                strategy = this.uiBotModelBuildStrategyFactory.get("projectPccNotStartedStrategy");
                break;
            }
            case 187: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildApcStandProductionProgressPageStrategy");
                break;
            }
            case 188: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelApcStandProductionProgressUniversalParsingPageStrategy");
                break;
            }
            case 189: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildWorkbenchPageStrategy");
                break;
            }
            case 190: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelWorkbenchUniversalParsingPageStrategy");
                break;
            }
            case 191: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectV2PageStrategy");
                break;
            }
            case 192: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildProjectMilestonePageStrategy");
                break;
            }
            case 193: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelProjectMilestoneUniversalParsingPageStrategy");
                break;
            }
            case 194: {
                strategy = this.uiBotModelBuildStrategyFactory.get("uiBotModelBuildFoundPageStrategy");
                break;
            }
        }
        this.handleUserCardListFilter(apiRequest);
        UiBotModel resultModel = null;
        resultModel = null != strategy ? strategy.buildModel(pageSetting, apiRequest) : UiBotModel.emptyUiBotModel();
        if (MobileRenderMetaData.RENDER_VERSION_2.equals(resultModel.getRenderVersion())) {
            this.handleLocalRule(resultModel);
        }
        if (StringUtils.hasLength((String)apiRequest.getBizId())) {
            resultModel.setDataId(apiRequest.getBizId());
        } else if (StringUtils.hasLength((String)apiRequest.getDataId()) && !StringUtils.hasLength((String)resultModel.getDataId())) {
            resultModel.setDataId(apiRequest.getDataId());
        }
        if (resultModel.getSlip() != null && resultModel.getSlip().getSlipConfig() != null) {
            UiBotSlip slip = resultModel.getSlip();
            if (slip.getSlipType().intValue() == SlipTypeEnum.ONLY_LEFT_SLIP.getValue()) {
                SlipConfigRight right = slip.getSlipConfig().getRight();
                this.dealWithRight(right, apiRequest);
            } else if (slip.getSlipType().intValue() == SlipTypeEnum.ONLY_RIGHT_SLIP.getValue()) {
                SlipConfigLeft left = slip.getSlipConfig().getLeft();
                this.dealWithLeft(left, apiRequest);
            } else if (slip.getSlipType().intValue() == SlipTypeEnum.LEFT_AND_RIGHT_SLIP.getValue()) {
                SlipConfigRight right = slip.getSlipConfig().getRight();
                SlipConfigLeft left = slip.getSlipConfig().getLeft();
                this.dealWithLeft(left, apiRequest);
                this.dealWithRight(right, apiRequest);
            }
        }
        resultModel.setModelType(modelType);
        return resultModel;
    }

    public void handleUserCardListFilter(ApiRequest apiRequest) {
        String businessType = apiRequest.getRawData().getBusinessType();
        if (null != businessType) {
            BusinessRawData businessRawData = apiRequest.getRawData().getBusinessRawData();
            if (null == businessRawData) {
                return;
            }
            if (BusinessTypeEnum.FILTER.getValue().equalsIgnoreCase(businessType) && businessRawData.getRefreshPageId().equalsIgnoreCase(apiRequest.getPageId())) {
                UserCardListFilter userCardListFilter = new UserCardListFilter();
                userCardListFilter.setPageId(businessRawData.getCurrentPageId());
                userCardListFilter.setUserId(apiRequest.getUserId());
                userCardListFilter.setTenantId(apiRequest.getTenantId());
                userCardListFilter.setComponentId(businessRawData.getComponentId());
                userCardListFilter.setDataId(businessRawData.getMobileDataId());
                userCardListFilter.setTmActivityId(businessRawData.getTmActivityId());
                List digiwinActionSubmitParasList = this.actionService.buildSubmitParasMap(apiRequest.getSubmitParam());
                digiwinActionSubmitParasList.removeIf(r -> "mobile_submit_card_data_key".equals(r.getOriginalSchema()));
                digiwinActionSubmitParasList.removeIf(r -> "mobile_local_add_card_data_key".equals(r.getOriginalSchema()));
                Map<String, Object> collect = digiwinActionSubmitParasList.stream().collect(Collectors.toMap(DigiwinActionSubmitParas::getSchema, DigiwinActionSubmitParas::getValue, (c1, c2) -> c1));
                userCardListFilter.setData(JsonUtil.javaObjectToJsonString(collect));
                this.userCardsFilterService.insertOrUpdateUserCardListFilter(userCardListFilter);
            }
            if (BusinessTypeEnum.FILTER.getValue().equalsIgnoreCase(businessType)) {
                apiRequest.setSubmitParam(null);
                apiRequest.setSubmitParams(null);
                apiRequest.setCurrentSubmitParam(null);
            }
        }
    }

    private void handleLocalRule(UiBotModel uiBotModel) {
        UiBotRenderData uiBotRenderData = uiBotModel.getRenderData();
        if (Objects.isNull(uiBotRenderData) || CollectionUtils.isEmpty((Collection)uiBotModel.getRules())) {
            return;
        }
        ArrayList useLocalRulesBaseMobileComponentList = new ArrayList();
        List bodyList = uiBotRenderData.getBody();
        bodyList.forEach(e -> MobileRenderDataUtil.getUseLocalRulesBaseMobileComponent((Object)e.getData(), (String)e.getComponentType(), (List)useLocalRulesBaseMobileComponentList));
        if (CollectionUtils.isEmpty(useLocalRulesBaseMobileComponentList)) {
            return;
        }
        Set localRuleCmptUuidList = useLocalRulesBaseMobileComponentList.stream().filter(e -> StringUtils.hasLength((String)e.getCmptUuid())).map(BaseMobileComponent::getCmptUuid).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(localRuleCmptUuidList)) {
            return;
        }
        Map<String, List<UiBotRule>> localRules = uiBotModel.getRules().stream().filter(rule -> localRuleCmptUuidList.contains(rule.getComponentId())).collect(Collectors.groupingBy(UiBotRule::getComponentId));
        uiBotModel.setLocalRules(localRules);
        uiBotModel.getRules().removeIf(rule -> localRuleCmptUuidList.contains(rule.getComponentId()));
    }

    private void dealWithLeft(SlipConfigLeft left, ApiRequest apiRequest) {
        left.setTitle(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)left.getTitle()));
        this.dealWithSlipTitle(left.getSubTitle(), apiRequest);
    }

    private void dealWithSlipTitle(SlipTitle subTitle, ApiRequest apiRequest) {
        subTitle.setPrefix(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)subTitle.getPrefix()));
        subTitle.setSuffix(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)subTitle.getSuffix()));
        if (subTitle.getNewLine() != null && subTitle.getNewLine().size() > 0) {
            ArrayList<String> newLines = new ArrayList<String>(subTitle.getNewLine().size());
            for (String newLine : subTitle.getNewLine()) {
                newLines.add(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)newLine));
            }
            subTitle.setNewLine(newLines);
        }
    }

    private void dealWithRight(SlipConfigRight right, ApiRequest apiRequest) {
        right.setTitle(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)right.getTitle()));
        LeftHeader leftHeader = right.getHeader();
        this.dealWithSlipTitle(leftHeader.getSubTitle(), apiRequest);
        LeftFooter leftFooter = right.getFooter();
        leftFooter.setTitle(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)leftFooter.getTitle()));
        List componentBoxes = leftFooter.getComponentBox();
        for (ComponentBox componentBox : componentBoxes) {
            componentBox.setData((Object)LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)((String)componentBox.getData())));
            componentBox.setSearchCategories(this.dealWithSearchCategory(apiRequest.getLocale(), componentBox.getSearchCategories()));
        }
    }

    private List<SearchCategory> dealWithSearchCategory(String locale, List<SearchCategory> searchCategories) {
        for (SearchCategory searchCategory : searchCategories) {
            searchCategory.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)searchCategory.getName()));
        }
        return searchCategories;
    }

    public MobileComponent buildComponentDataModel(ComponentSettingRequestIdEnum componentSettingRequestIdEnum, ApiRequest apiRequest) throws IOException {
        return this.uiBotCompDataBuildStrategyFactory.get(componentSettingRequestIdEnum.getReuqestId()).buildComponentData(apiRequest);
    }

    public List<MobileComponent> buildComponentDataModelList(ComponentSettingRequestIdEnum componentSettingRequestIdEnum, ApiRequest apiRequest) throws IOException {
        return this.uiBotCompDataBuildStrategyFactory.get(componentSettingRequestIdEnum.getReuqestId()).buildComponentDataList(apiRequest);
    }

    public UiBotModel buildCustomContentReportUseTbbApi(Map<String, Object> queryParam, CustomContentRequest customContentRequest) {
        String locale = String.valueOf(queryParam.getOrDefault("locale", ""));
        String useDap = String.valueOf(queryParam.getOrDefault("useDap", ""));
        String serviceUrl = String.valueOf(queryParam.getOrDefault("serviceUrl", ""));
        boolean recommend = false;
        if (customContentRequest.getSysParam().get("recommend") != null) {
            recommend = (Boolean)customContentRequest.getSysParam().get("recommend");
        }
        log.debug("useDap is {}", (Object)useDap);
        log.debug("servicUrl is {}", (Object)serviceUrl);
        log.debug("recommend is {}", (Object)recommend);
        String proxyBodyPayload = JsonUtil.javaObjectToJsonString((Object)customContentRequest);
        log.debug("request body is {}", (Object)proxyBodyPayload);
        String iamUserToken = (String)customContentRequest.getSysParam().get("iamUserToken");
        String clientId = (String)customContentRequest.getSysParam().get("clientId");
        String tenantId = (String)customContentRequest.getSysParam().get("tenantId");
        String userId = (String)customContentRequest.getSysParam().get("userId");
        String digiwinGoodsCode = (String)customContentRequest.getSysParam().get("digiwinGoodsCode");
        ResponseEntity responseEntity = this.httpService.doPost(serviceUrl, new AthenaBasicHttpRequestHead(iamUserToken), proxyBodyPayload, DapResponse.class);
        HttpStatus statusCode = responseEntity.getStatusCode();
        UiBotModel uiBotModel = null;
        if (statusCode.is2xxSuccessful() && null != responseEntity.getBody() && Boolean.parseBoolean(useDap)) {
            uiBotModel = this.getUibotModelDataFromDapResponse((DapResponse)responseEntity.getBody());
            if (!recommend) {
                if (null == uiBotModel) {
                    uiBotModel = UiBotModel.emptyUiBotModel();
                }
            } else if ("PCC".equalsIgnoreCase(digiwinGoodsCode)) {
                this.handleUiBotModelByAiRecommend(uiBotModel, locale, clientId, iamUserToken, tenantId, userId);
            } else {
                uiBotModel = UiBotModel.emptyUiBotModel();
            }
        } else {
            if (!statusCode.is2xxSuccessful()) {
                String errorMsg = "serviceUrl {} call returning a statusCode {}, and response is {},  use welcome data instead...;";
                log.debug(errorMsg, new Object[]{serviceUrl, statusCode.value(), responseEntity.getBody()});
            } else {
                String errorMsg = "serviceUrl {} DO NOT use dap, or, use welcome data instead...";
                log.debug(errorMsg, new Object[]{serviceUrl, statusCode.value(), responseEntity.getBody()});
            }
            uiBotModel = UiBotModel.createCustomContentWelcomeModel((String)locale);
        }
        return uiBotModel;
    }

    public UiBotModel buildCustomContentReportUseAthenaApi(Map<String, Object> queryParam, CustomContentRequest customContentRequest) throws UnsupportedEncodingException {
        UiBotModel uiBotModel;
        String locale = String.valueOf(queryParam.getOrDefault("locale", ""));
        String useDap = String.valueOf(queryParam.getOrDefault("useDap", ""));
        String serviceUrl = String.valueOf(queryParam.getOrDefault("serviceUrl", ""));
        boolean recommend = false;
        if (customContentRequest.getSysParam().get("recommend") != null) {
            recommend = (Boolean)customContentRequest.getSysParam().get("recommend");
        }
        log.debug("useDap is {}", (Object)useDap);
        log.debug("servicUrl is {}", (Object)serviceUrl);
        log.debug("recommend is {}", (Object)recommend);
        String proxyBodyPayload = JsonUtil.javaObjectToJsonString((Object)customContentRequest);
        log.debug("request body is {}", (Object)proxyBodyPayload);
        String iamUserToken = (String)customContentRequest.getSysParam().get("iamUserToken");
        String clientId = (String)customContentRequest.getSysParam().get("clientId");
        String tenantId = (String)customContentRequest.getSysParam().get("tenantId");
        String userId = (String)customContentRequest.getSysParam().get("userId");
        String digiwinGoodsCode = (String)customContentRequest.getSysParam().get("digiwinGoodsCode");
        List kgTbbReports = this.digiwinKnowledgemapsProxyService.getTbbReports(iamUserToken, locale, digiwinGoodsCode);
        ArrayList accessibleKgTbbReports = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)kgTbbReports)) {
            List digiwinAudcActivityAccessibleList = this.digiwinAudcProxyService.getAccessibleList(locale, iamUserToken, tenantId, kgTbbReports.stream().map(report -> report.getCode()).collect(Collectors.toList()), 1, "report");
            digiwinAudcActivityAccessibleList.stream().forEach(digiwinAudcActivityAccessible -> {
                if (digiwinAudcActivityAccessible.isAllow().booleanValue()) {
                    accessibleKgTbbReports.add(kgTbbReports.stream().filter(kgTbbReport -> digiwinAudcActivityAccessible.getTmActivityId().equals(kgTbbReport.getCode())).findFirst().get());
                }
            });
        }
        if (CollectionUtils.isEmpty(accessibleKgTbbReports)) {
            uiBotModel = UiBotModel.emptyUiBotModel();
            return uiBotModel;
        }
        WebviewPanel webviewPanel = new WebviewPanel();
        for (KnowledgeMapsTbbReport kgTbbReport : accessibleKgTbbReports) {
            webviewPanel.setTitle(kgTbbReport.getAppName());
            webviewPanel.addWebview(KnowledgeMapsTbbReport.buildWebview((KnowledgeMapsTbbReport)kgTbbReport, (String)locale, (String)iamUserToken));
        }
        uiBotModel = UiBotModel.createCustomContentSingleWebviewPanelModel((WebviewPanel)webviewPanel);
        if (!recommend) {
            return uiBotModel;
        }
        return UiBotModel.emptyUiBotModel();
    }

    private UiBotModel getUibotModelDataFromDapResponse(DapResponse dapResponse) {
        Map data = (Map)dapResponse.getResponse().get("data");
        return (UiBotModel)JsonUtil.objectToJavaObject((Object)data, UiBotModel.class);
    }

    private void handleUiBotModelByAiRecommend(UiBotModel uiBotModel, String locale, String clientId, String iamUserToken, String tenantId, String userId) {
        DigiwinAtmcTmData tmData2;
        if (uiBotModel.getLayout() == null || uiBotModel.getLayout().isEmpty()) {
            return;
        }
        List recommendCodeList = new ArrayList();
        List tmDataList = this.digiwinAudcProxyService.getTmDataList(clientId, iamUserToken, tenantId, locale);
        Optional<DigiwinAtmcTmData> tmDataOptional = tmDataList.stream().filter(tmData -> "PCC".equalsIgnoreCase(tmData.getAppCode())).findFirst();
        DigiwinAtmcTmData digiwinAtmcTmData = tmData2 = tmDataOptional.isPresent() ? tmDataOptional.get() : null;
        if (tmData2 != null) {
            List dtoList = tmData2.getBaseItemDtoList();
            List tmActivityIdList = dtoList.stream().map(dto -> dto.getCode()).collect(Collectors.toList());
            List digiwinAudcActivityAccessibleList = this.digiwinAudcProxyService.getAccessibleList(locale, iamUserToken, tenantId, tmActivityIdList, 1, "report");
            tmActivityIdList.add("projectDelayEnter");
            tmActivityIdList.add("overdueEnter");
            recommendCodeList = this.digiwinAiProxyService.getRecommendedReport(tmActivityIdList, userId, iamUserToken, tenantId);
        }
        Iterator layoutIterator = uiBotModel.getLayout().iterator();
        UiBotPageData pageData = uiBotModel.getPageData();
        while (layoutIterator.hasNext()) {
            UiBotLayout layout = (UiBotLayout)layoutIterator.next();
            if (!"WEBVIEW_PANEL".equals(layout.getType())) continue;
            WebviewPanel webviewPanel = (WebviewPanel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), WebviewPanel.class);
            webviewPanel.setTitle(null);
            List webviewList = webviewPanel.getData();
            if (webviewList == null || webviewList.isEmpty()) continue;
            ArrayList recommendWebviewList = new ArrayList();
            List finalRecommendCodeList = recommendCodeList;
            webviewList.stream().forEach(webview -> {
                String code = this.getCodeByParseUrl(webview.getUrl());
                if (finalRecommendCodeList.contains(code)) {
                    recommendWebviewList.add(webview);
                }
            });
            webviewPanel.setData(recommendWebviewList);
            pageData.put((Object)layout.getSchema(), (Object)webviewPanel);
        }
    }

    private String getCodeByParseUrl(String url) {
        if (url.contains("/#/") && url.contains("?")) {
            int start = url.indexOf("/#/") + 3;
            int end = url.indexOf("?");
            return url.substring(start, end);
        }
        return "";
    }

    public boolean nonSuperAdminNotSetAccount(ApiRequest apiRequest) {
        try {
            ArrayList<Future> futureList = new ArrayList<Future>();
            Future superAdminFuture = this.threadPoolTaskExecutor.submit(() -> this.digiwinIamProxyService.isSuperAdmin(apiRequest.getIamUserToken(), apiRequest.getUserId()));
            futureList.add(superAdminFuture);
            Future eocSetInfoFuture = this.threadPoolTaskExecutor.submit(() -> this.digiwinMdcProxyService.eocSetInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getUserId()));
            futureList.add(eocSetInfoFuture);
            Future userIntegrityFuture = this.threadPoolTaskExecutor.submit(() -> this.digiwinKnowledgemapsProxyService.userIntegrityCheck(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale()));
            futureList.add(userIntegrityFuture);
            Boolean superAdmin = false;
            EocSetInfo eocSetInfo = new EocSetInfo();
            UserIntegrity userIntegrity = new UserIntegrity();
            try {
                block4: for (Future future : futureList) {
                    while (true) {
                        if (future.isDone() && !future.isCancelled()) {
                            Object obj = future.get();
                            if (obj instanceof Boolean) {
                                superAdmin = (Boolean)obj;
                                continue block4;
                            }
                            if (obj instanceof EocSetInfo) {
                                eocSetInfo = (EocSetInfo)obj;
                                continue block4;
                            }
                            if (!(obj instanceof UserIntegrity)) continue block4;
                            userIntegrity = (UserIntegrity)obj;
                            continue block4;
                        }
                        Thread.sleep(1L);
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                log.error(e.getLocalizedMessage());
                throw new ServiceException(e.getMessage());
            }
            if (Boolean.TRUE.equals(superAdmin) ? Boolean.FALSE.equals(eocSetInfo.getRemindUnitSetting()) : Boolean.TRUE.equals(eocSetInfo.getRemindUnitSetting() == false) && Boolean.TRUE.equals(userIntegrity.getUserIntegrity())) {
                return false;
            }
            ApiRawData rawData = apiRequest.getRawData();
            if (Objects.isNull(rawData)) {
                rawData = new ApiRawData();
            }
            rawData.put("superAdmin", (Object)superAdmin);
            rawData.put("eocSetInfo", (Object)eocSetInfo);
            rawData.put("userIntegrity", (Object)userIntegrity);
            apiRequest.setRawData(rawData);
            return true;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
    }
}

