/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BaseMobileComponentWrapperJsonDeserializer
extends JsonDeserializer<BaseMobileComponentWrapper<BaseMobileComponent>> {
    private static final Logger logger = LoggerFactory.getLogger(BaseMobileComponentWrapperJsonDeserializer.class);

    public BaseMobileComponentWrapper<BaseMobileComponent> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        boolean existPrefix;
        String mappingComponent;
        logger.debug("BaseMobileComponentWrapperJsonDeserializer run to prehandle data to component instance...");
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        String mobilePath = Optional.ofNullable(node.get("mobilePath")).map(JsonNode::asText).orElse("");
        String schema = Optional.ofNullable(node.get("schema")).map(JsonNode::asText).orElse("");
        String componentType = Optional.ofNullable(node.get("componentType")).map(JsonNode::asText).orElse("");
        if ("DW_CUSTOMIZE".equals(componentType) && StringUtils.hasLength((String)(mappingComponent = Optional.ofNullable(node.get("data")).map(data -> data.get("mappingComponent")).map(JsonNode::asText).orElse("")))) {
            componentType = mappingComponent;
        }
        if (existPrefix = componentType.startsWith("DW_")) {
            componentType = componentType.substring(3);
        }
        if (BooleanUtils.isTrue((Boolean)AppRequestContext.getContextEntity().getIsUpgrade())) {
            existPrefix = true;
        }
        JsonNode data2 = node.get("data");
        Class cmptClazz = (Class)MobileRenderDataUtil.allMobileComponentsMap.get(componentType);
        BaseMobileComponent baseMobileComponent = null;
        if (null != cmptClazz) {
            if ("ATTACHMENT".equals(componentType)) {
                baseMobileComponent = (BaseMobileComponent)JsonUtil.jsonStringToObject((String)data2.toString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            } else if ("BUTTON".equals(componentType)) {
                String string = data2.toString();
                if (data2.get("type") != null && data2.get("type") instanceof TextNode) {
                    Map map = (Map)JsonUtil.jsonStringToObject((String)string, Map.class);
                    map.remove("type");
                    string = JsonUtil.javaObjectToJsonString((Object)map);
                }
                baseMobileComponent = (BaseMobileComponent)JsonUtil.jsonStringToObject((String)string, (Class)cmptClazz);
            } else {
                baseMobileComponent = (BaseMobileComponent)JsonUtil.jsonStringToObject((String)data2.toString(), (Class)cmptClazz);
            }
        }
        return new BaseMobileComponentWrapper(baseMobileComponent, (existPrefix ? "DW_" : "") + componentType, schema, mobilePath);
    }
}

