/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

public class Retractable
extends BaseMobileComponent
implements Serializable {
    private static final long serialVersionUID = -7485078164778545657L;
    public static final String COMPONENT_TYPE = "RETRACYABLE";
    private String title;
    private Boolean isExpand = false;
    private Integer style;
    private Integer alignmentType;
    private Integer iconStatus;
    private Integer level = 0;
    private String desc;
    private String choice = MultiFunctionListChoiceEnum.NO_CHOICE.name();
    private Map<String, Object> rawData;
    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> content = new ArrayList();
    private CustomTitle customTitle;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public static Retractable buildRetractable(ApiRequest apiRequest, LocaleService localeService, List<WoOpReportInfo> woOpReportInfoList) {
        Retractable retractable = new Retractable();
        retractable.setTitle(woOpReportInfoList.get(0).getTeamName());
        retractable.setStyle(Integer.valueOf(2));
        retractable.setAlignmentType(Integer.valueOf(2));
        retractable.setIsExpand(Boolean.valueOf(true));
        retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper((BaseMobileComponent)ZtbViewList.buildZtbViewList((ApiRequest)apiRequest, (LocaleService)localeService, woOpReportInfoList), "ZTB_VIEW_LIST")));
        return retractable;
    }

    public static List<Retractable> buildRetractable(ApiRequest apiRequest, LocaleService localeService, Map<String, Map<String, List<WoOpReportInfo>>> woOpReportInfoList, String taskNameField, String bgColor) {
        return woOpReportInfoList.entrySet().stream().map(woOpReportInfoByWoNo -> {
            Retractable retractable = new Retractable();
            String title = (String)woOpReportInfoByWoNo.getKey();
            if ("2".equals(taskNameField)) {
                title = Optional.ofNullable(woOpReportInfoByWoNo.getValue()).map(e -> e.values()).map(e -> (List)e.iterator().next()).map(e -> (WoOpReportInfo)e.get(0)).map(e -> e.getProjectNo() + " " + e.getProjectName()).orElse("");
            }
            retractable.setTitle(title);
            retractable.setStyle(Integer.valueOf(2));
            retractable.setAlignmentType(Integer.valueOf(2));
            retractable.setIsExpand(Boolean.valueOf(true));
            List customTabContentContainerByOpNoList = ((Map)woOpReportInfoByWoNo.getValue()).entrySet().stream().map(woOpReportInfoByOpNo -> {
                Retractable retractableByOpNo = new Retractable();
                retractableByOpNo.setTitle(Optional.ofNullable(woOpReportInfoByOpNo.getValue()).map(e -> (WoOpReportInfo)e.get(0)).map(WoOpReportInfo::getOpName).orElse(""));
                retractableByOpNo.setStyle(Integer.valueOf(2));
                retractableByOpNo.setAlignmentType(Integer.valueOf(2));
                retractableByOpNo.setLevel(Integer.valueOf(1));
                retractableByOpNo.setIsExpand(Boolean.valueOf(true));
                retractableByOpNo.setContent(Collections.singletonList(new BaseMobileComponentWrapper((BaseMobileComponent)ZtbViewList.buildWoOpReportInfoSupportZtbViewList((ApiRequest)apiRequest, (LocaleService)localeService, (List)((List)woOpReportInfoByOpNo.getValue()), (String)bgColor), "ZTB_VIEW_LIST")));
                return new BaseMobileComponentWrapper((BaseMobileComponent)retractableByOpNo, COMPONENT_TYPE);
            }).collect(Collectors.toList());
            retractable.setContent(customTabContentContainerByOpNoList);
            return retractable;
        }).collect(Collectors.toList());
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.rawData = data;
        if (Objects.nonNull(this.customTitle)) {
            if (BooleanUtils.isTrue((Boolean)this.customTitle.getIsCustom())) {
                this.title = this.customTitle.getTitle();
            } else {
                String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)this.customTitle.getTitlePath(), (String)this.customTitle.getTitle())).map(Object::toString).orElse(null);
                List options = Optional.ofNullable(this.customTitle.getTitleSetting()).map(CustomTitle.TitleSetting::getSetting).map(CustomTitle.Setting::getOptions).orElse(null);
                this.title = !CollectionUtils.isEmpty((Collection)options) ? options.stream().filter(e -> e.getId().equals(value)).findFirst().map(e -> e.getText()).orElse(value) : value;
            }
        }
        if (BooleanUtils.isNotTrue((Boolean)cmptContext.getAddAllSelectButton()) && MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.name().equals(this.choice)) {
            cmptContext.setAddAllSelectButton(Boolean.valueOf(true));
        }
        ((UiBotDesignerRenderService)SpringContextHolder.getBean(UiBotDesignerRenderService.class)).buildCmptDsl(cmptContext, executeContext, this.getContent(), data, mobilePageRawData);
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getIsExpand() {
        return this.isExpand;
    }

    public Integer getStyle() {
        return this.style;
    }

    public Integer getAlignmentType() {
        return this.alignmentType;
    }

    public Integer getIconStatus() {
        return this.iconStatus;
    }

    public Integer getLevel() {
        return this.level;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getChoice() {
        return this.choice;
    }

    public Map<String, Object> getRawData() {
        return this.rawData;
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getContent() {
        return this.content;
    }

    public CustomTitle getCustomTitle() {
        return this.customTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setIsExpand(Boolean isExpand) {
        this.isExpand = isExpand;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public void setAlignmentType(Integer alignmentType) {
        this.alignmentType = alignmentType;
    }

    public void setIconStatus(Integer iconStatus) {
        this.iconStatus = iconStatus;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setChoice(String choice) {
        this.choice = choice;
    }

    public void setRawData(Map<String, Object> rawData) {
        this.rawData = rawData;
    }

    @JsonDeserialize(contentUsing=BaseMobileComponentWrapperJsonDeserializer.class)
    public void setContent(List<BaseMobileComponentWrapper<BaseMobileComponent>> content) {
        this.content = content;
    }

    public void setCustomTitle(CustomTitle customTitle) {
        this.customTitle = customTitle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Retractable)) {
            return false;
        }
        Retractable other = (Retractable)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$isExpand = this.getIsExpand();
        Boolean other$isExpand = other.getIsExpand();
        if (this$isExpand == null ? other$isExpand != null : !((Object)this$isExpand).equals(other$isExpand)) {
            return false;
        }
        Integer this$style = this.getStyle();
        Integer other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
            return false;
        }
        Integer this$alignmentType = this.getAlignmentType();
        Integer other$alignmentType = other.getAlignmentType();
        if (this$alignmentType == null ? other$alignmentType != null : !((Object)this$alignmentType).equals(other$alignmentType)) {
            return false;
        }
        Integer this$iconStatus = this.getIconStatus();
        Integer other$iconStatus = other.getIconStatus();
        if (this$iconStatus == null ? other$iconStatus != null : !((Object)this$iconStatus).equals(other$iconStatus)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$choice = this.getChoice();
        String other$choice = other.getChoice();
        if (this$choice == null ? other$choice != null : !this$choice.equals(other$choice)) {
            return false;
        }
        Map this$rawData = this.getRawData();
        Map other$rawData = other.getRawData();
        if (this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData)) {
            return false;
        }
        List this$content = this.getContent();
        List other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        CustomTitle this$customTitle = this.getCustomTitle();
        CustomTitle other$customTitle = other.getCustomTitle();
        return !(this$customTitle == null ? other$customTitle != null : !this$customTitle.equals(other$customTitle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Retractable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isExpand = this.getIsExpand();
        result = result * 59 + ($isExpand == null ? 43 : ((Object)$isExpand).hashCode());
        Integer $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        Integer $alignmentType = this.getAlignmentType();
        result = result * 59 + ($alignmentType == null ? 43 : ((Object)$alignmentType).hashCode());
        Integer $iconStatus = this.getIconStatus();
        result = result * 59 + ($iconStatus == null ? 43 : ((Object)$iconStatus).hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $choice = this.getChoice();
        result = result * 59 + ($choice == null ? 43 : $choice.hashCode());
        Map $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        List $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        CustomTitle $customTitle = this.getCustomTitle();
        result = result * 59 + ($customTitle == null ? 43 : $customTitle.hashCode());
        return result;
    }

    public String toString() {
        return "Retractable(title=" + this.getTitle() + ", isExpand=" + this.getIsExpand() + ", style=" + this.getStyle() + ", alignmentType=" + this.getAlignmentType() + ", iconStatus=" + this.getIconStatus() + ", level=" + this.getLevel() + ", desc=" + this.getDesc() + ", choice=" + this.getChoice() + ", rawData=" + this.getRawData() + ", content=" + this.getContent() + ", customTitle=" + this.getCustomTitle() + ")";
    }
}

