/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.chartlegend.ChartLegend;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.chartlegend.ChartLegendData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttitle.ChartTitle;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttitle.ChartTitleData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttitle.ChartTitleText;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttooltip.ChartTooltip;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartColorPalette;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartPointField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChartBasic
implements Serializable {
    private static final long serialVersionUID = 7182486410493798422L;
    private ChartTitle title;
    private ChartTooltip tooltip;
    private ChartLegend legend;
    private String dataTipMessage;

    public static ChartBasic buildChartBasic(AgileDataIntermediateDataItem intermediateDataItem) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        ChartTypeEnum chartTypeEnum = ChartTypeEnum.getEnumByValue((String)chartRenderSetting.getChartType());
        ChartTitle chartTitle = new ChartTitle();
        ChartTooltip chartTooltip = new ChartTooltip();
        List titleDatas = chartTitle.getData();
        if (StringUtils.isNotBlank((CharSequence)intermediateDataItem.getShowName())) {
            titleDatas.add(new ChartTitleData().setTitle(new ChartTitleText().setText(intermediateDataItem.getShowName().trim())));
        }
        ChartLegend chartLegend = ChartTypeEnum.PIE == chartTypeEnum ? ChartBasic.buildPieChartLegend((AgileDataIntermediateDataItem)intermediateDataItem, (ChartRenderSetting)chartRenderSetting) : (ChartTypeEnum.LINE == chartTypeEnum || ChartTypeEnum.BAR == chartTypeEnum || ChartTypeEnum.LINE_BAR == chartTypeEnum || ChartTypeEnum.MIXED == chartTypeEnum ? ChartBasic.buildRectangleCoordinateChartLegend((AgileDataIntermediateDataItem)intermediateDataItem, (ChartRenderSetting)chartRenderSetting, (ChartTypeEnum)chartTypeEnum) : new ChartLegend());
        return new ChartBasic().setTitle(chartTitle).setTooltip(chartTooltip).setLegend(chartLegend).setDataTipMessage(intermediateDataItem.getDataTipMessage());
    }

    private static ChartLegend buildRectangleCoordinateChartLegend(AgileDataIntermediateDataItem intermediateDataItem, ChartRenderSetting chartRenderSetting, ChartTypeEnum chartTypeEnum) {
        List pointFields = chartRenderSetting.getPoints();
        List valueFields = chartRenderSetting.getValues();
        List pageData = intermediateDataItem.getPageData();
        ChartLegend chartLegend = new ChartLegend();
        int colorIdx = 0;
        for (int i = 0; i < valueFields.size(); ++i) {
            AgileDataChartValueField valueField = (AgileDataChartValueField)chartRenderSetting.getValues().get(i);
            String chartTypeSpecifiedInValueField = valueField.getChartType();
            ChartLegendData legendData = new ChartLegendData();
            legendData.setName(valueField.getTitle());
            legendData.setColor(ChartColorPalette.getColorFromCategoryPalette((int)colorIdx, (int)valueFields.size()));
            legendData.setBusinessType(valueField.getBusinessType());
            legendData.setDescription(valueField.getDescription());
            legendData.setDecimalRule(valueField.getFormat().getDecimalRule());
            legendData.setPercent(valueField.getFormat().getPercent());
            legendData.setDecimal(valueField.getFormat().getDecimal());
            legendData.setUnit(valueField.getFormat().getUnit());
            ++colorIdx;
            if (org.springframework.util.StringUtils.hasLength((String)chartTypeSpecifiedInValueField)) {
                ChartTypeEnum specifiedChartType = ChartTypeEnum.getEnumByValue((String)chartTypeSpecifiedInValueField);
                if (null != specifiedChartType) {
                    legendData.setChartType(specifiedChartType.getType());
                }
            } else {
                legendData.setChartType(chartTypeEnum.getType());
            }
            chartLegend.getData().add(legendData);
        }
        return chartLegend;
    }

    private static ChartLegend buildPieChartLegend(AgileDataIntermediateDataItem intermediateDataItem, ChartRenderSetting chartRenderSetting) {
        ChartLegend chartLegend = new ChartLegend();
        List pageData = intermediateDataItem.getPageData();
        AgileDataChartValueField agileDataChartValueField = null;
        if (!CollectionUtils.isEmpty((Collection)chartRenderSetting.getValues())) {
            agileDataChartValueField = (AgileDataChartValueField)chartRenderSetting.getValues().get(0);
        }
        for (int i = 0; i < chartRenderSetting.getPoints().size(); ++i) {
            AgileDataChartPointField pointField = (AgileDataChartPointField)chartRenderSetting.getPoints().get(i);
            for (int j = 0; j < pageData.size(); ++j) {
                JSONObject pageDatum = (JSONObject)pageData.get(j);
                ChartLegendData legendData = new ChartLegendData();
                legendData.setName(pageDatum.getString(pointField.getName()));
                legendData.setColor(ChartColorPalette.getColorFromCategoryPalette((int)j, (int)pageData.size()));
                if (null != agileDataChartValueField) {
                    legendData.setBusinessType(agileDataChartValueField.getBusinessType());
                    legendData.setDescription(agileDataChartValueField.getDescription());
                    legendData.setDecimalRule(agileDataChartValueField.getFormat().getDecimalRule());
                    legendData.setUnit(agileDataChartValueField.getFormat().getUnit());
                    legendData.setPercent(agileDataChartValueField.getFormat().getPercent());
                    legendData.setDecimal(agileDataChartValueField.getFormat().getDecimal());
                }
                chartLegend.getData().add(legendData);
            }
        }
        return chartLegend;
    }

    public ChartTitle getTitle() {
        return this.title;
    }

    public ChartTooltip getTooltip() {
        return this.tooltip;
    }

    public ChartLegend getLegend() {
        return this.legend;
    }

    public String getDataTipMessage() {
        return this.dataTipMessage;
    }

    public ChartBasic setTitle(ChartTitle title) {
        this.title = title;
        return this;
    }

    public ChartBasic setTooltip(ChartTooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ChartBasic setLegend(ChartLegend legend) {
        this.legend = legend;
        return this;
    }

    public ChartBasic setDataTipMessage(String dataTipMessage) {
        this.dataTipMessage = dataTipMessage;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartBasic)) {
            return false;
        }
        ChartBasic other = (ChartBasic)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ChartTitle this$title = this.getTitle();
        ChartTitle other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        ChartTooltip this$tooltip = this.getTooltip();
        ChartTooltip other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        ChartLegend this$legend = this.getLegend();
        ChartLegend other$legend = other.getLegend();
        if (this$legend == null ? other$legend != null : !this$legend.equals(other$legend)) {
            return false;
        }
        String this$dataTipMessage = this.getDataTipMessage();
        String other$dataTipMessage = other.getDataTipMessage();
        return !(this$dataTipMessage == null ? other$dataTipMessage != null : !this$dataTipMessage.equals(other$dataTipMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartBasic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChartTitle $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        ChartTooltip $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        ChartLegend $legend = this.getLegend();
        result = result * 59 + ($legend == null ? 43 : $legend.hashCode());
        String $dataTipMessage = this.getDataTipMessage();
        result = result * 59 + ($dataTipMessage == null ? 43 : $dataTipMessage.hashCode());
        return result;
    }

    public String toString() {
        return "ChartBasic(title=" + this.getTitle() + ", tooltip=" + this.getTooltip() + ", legend=" + this.getLegend() + ", dataTipMessage=" + this.getDataTipMessage() + ")";
    }

    public ChartBasic() {
    }

    public ChartBasic(ChartTitle title, ChartTooltip tooltip, ChartLegend legend, String dataTipMessage) {
        this.title = title;
        this.tooltip = tooltip;
        this.legend = legend;
        this.dataTipMessage = dataTipMessage;
    }
}

