/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline.ChartMarkLine;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline.ChartMarkLineItem;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline.ChartMarkLineTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartColorPalette;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartMarkLine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartMarkLineFunTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChartMarkLine
implements Serializable {
    private static final long serialVersionUID = 6153553149733744631L;
    private List<ChartMarkLineItem> data = new ArrayList();

    public static ChartMarkLine buildLineChartMarkLine(AgileDataIntermediateDataItem intermediateDataItem) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        List values = chartRenderSetting.getValues();
        HashMap<String, String> valueFieldColorMap = new HashMap<String, String>(values.size());
        for (int j = 0; j < values.size(); ++j) {
            AgileDataChartValueField valueField = (AgileDataChartValueField)values.get(j);
            String lineColor = ChartColorPalette.getColorFromCategoryPalette((int)j, (int)values.size());
            valueFieldColorMap.put(valueField.getName(), lineColor);
        }
        return ChartMarkLine.buildChartMarkLine((AgileDataIntermediateDataItem)intermediateDataItem, valueFieldColorMap);
    }

    public static ChartMarkLine buildBarChartMarkLine(AgileDataIntermediateDataItem intermediateDataItem, Map<String, String> valueFieldColorMap) {
        return ChartMarkLine.buildChartMarkLine((AgileDataIntermediateDataItem)intermediateDataItem, valueFieldColorMap);
    }

    private static ChartMarkLine buildChartMarkLine(AgileDataIntermediateDataItem intermediateDataItem, Map<String, String> valueFieldColorMap) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        AgileDataChartMarkLine agileDataChartMarkLine = chartRenderSetting.getMarkLine();
        ChartMarkLine chartMarkLine = new ChartMarkLine();
        if (Objects.isNull(agileDataChartMarkLine) || CollectionUtils.isEmpty((Collection)agileDataChartMarkLine.getData())) {
            return null;
        }
        List valueFields = chartRenderSetting.getValues();
        agileDataChartMarkLine.getData().forEach(aMarkLineItem -> {
            String applyToValueField = aMarkLineItem.getApplyToValueField();
            Optional<AgileDataChartValueField> optValueField = valueFields.stream().filter(v -> Objects.equals(v.getName(), applyToValueField)).findFirst();
            if (optValueField.isPresent()) {
                AgileDataChartValueField valueField = optValueField.get();
                DescriptiveStatistics stats = new DescriptiveStatistics();
                for (JSONObject pageDatum : intermediateDataItem.getPageData()) {
                    stats.addValue(pageDatum.getDoubleValue(valueField.getName()));
                }
                AgileDataChartMarkLineFunTypeEnum lineFunTypeEnum = AgileDataChartMarkLineFunTypeEnum.getEnumByValue((String)aMarkLineItem.getType());
                if (null != lineFunTypeEnum) {
                    ChartMarkLineItem markLineItem = new ChartMarkLineItem();
                    Double lineValue = 0.0;
                    switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$proxy$uibot$model$agiledata$chart$AgileDataChartMarkLineFunTypeEnum[lineFunTypeEnum.ordinal()]) {
                        case 1: {
                            lineValue = stats.getMean();
                            break;
                        }
                        case 2: {
                            lineValue = stats.getMin();
                            break;
                        }
                        case 3: {
                            lineValue = stats.getMax();
                            break;
                        }
                        default: {
                            lineValue = 0.0;
                        }
                    }
                    markLineItem.setyAxis(lineValue);
                    markLineItem.setColor(valueFieldColorMap.getOrDefault(applyToValueField, "#E8E8E8"));
                    markLineItem.setLineType(ChartMarkLineTypeEnum.DASHED.getValue());
                    markLineItem.setLabel(valueField.getFormat().getFormattedString(lineValue));
                    chartMarkLine.addChartMarkLineItem(markLineItem);
                }
            }
        });
        return chartMarkLine;
    }

    public void addChartMarkLineItem(ChartMarkLineItem item) {
        this.data.add(item);
    }

    public void removeChartMarkLineItem(ChartMarkLineItem item) {
        this.data.remove(item);
    }

    public void removeChartMarkLineItem(int index) {
        this.data.remove(index);
    }

    public List<ChartMarkLineItem> getData() {
        return this.data;
    }

    public ChartMarkLine setData(List<ChartMarkLineItem> data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartMarkLine)) {
            return false;
        }
        ChartMarkLine other = (ChartMarkLine)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$data = this.getData();
        List other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartMarkLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ChartMarkLine(data=" + this.getData() + ")";
    }
}

