/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.calendar;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="inputCalendarParamAnalyzer")
public class InputCalendarParamAnalyzer
implements ComponentParamAnalyzer<InputCalendar, String> {
    private static final Logger logger = LoggerFactory.getLogger(InputCalendarParamAnalyzer.class);

    public String getComponentType() {
        return "INPUT_CALENDAR";
    }

    public Class<InputCalendar> getSubmitParamType() {
        return InputCalendar.class;
    }

    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputCalendar)) {
            logger.debug("submitParam is not instanceof InputCalendar component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return "";
        }
        InputCalendar inputCalendar = (InputCalendar)submitParam;
        if (null == inputCalendar.getInputText() || inputCalendar.getInputText().isEmpty()) {
            return "";
        }
        this.paddingDateForm(inputCalendar);
        return DateTimeUtil.getInputCalendarDateUseDefaultPattern((String)inputCalendar.getInputText());
    }

    private void paddingDateForm(InputCalendar inputCalendar) {
        String inputText = inputCalendar.getInputText();
        if (!org.springframework.util.StringUtils.hasLength((String)inputText)) {
            return;
        }
        String[] dates = inputText.trim().split(" ");
        Object[] split = dates[0].split("\\.");
        if (split[1].length() == 1) {
            split[1] = "0" + (String)split[1];
        }
        if (split[2].length() == 1) {
            split[2] = "0" + (String)split[2];
        }
        String date = StringUtils.join((Object[])split, (String)".");
        if (dates.length > 1) {
            date = date + " " + dates[1];
        }
        inputCalendar.setInputText(date);
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
    }
}

