/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinition;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItem;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleResponseData;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelectSearchTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.OrderOptionEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceSetDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotBizFieldBase;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.fasterxml.jackson.core.type.TypeReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="inputWindowSingleItemBuilder")
public class InputWindowSingleItemBuilder
implements MobileComponentListBuilder<InputWindowSingleItem> {
    private static final Logger logger = LoggerFactory.getLogger(InputWindowSingleItemBuilder.class);
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public String getMobileComponentType() {
        return "WINDOW_SINGLE_SELECT_ITEM";
    }

    public List<InputWindowSingleItem> build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<InputWindowSingleItem> clazz, Object ... args) {
        List uiBotLayouts = pcUiBotModel.getLayout();
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        String mTagId = InputWindowSingleItemBuilder.getTagId((UiBotExecuteContext)executeContext);
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<UiBotLayout> optPcDataLayout = pcUiBotModel.getLayout().stream().filter(l -> l.getId() != null && l.getId().equalsIgnoreCase(l.getSchema())).findFirst();
        if (!optPcDataLayout.isPresent()) {
            return Collections.emptyList();
        }
        UiBotLayout pcDataLayout = optPcDataLayout.get();
        if (!("TABLE".equalsIgnoreCase(pcDataLayout.getType()) || "ATHENA_TABLE".equalsIgnoreCase(pcDataLayout.getType()) || "GRID_TABLE".equalsIgnoreCase(pcDataLayout.getType()))) {
            return Collections.emptyList();
        }
        String schema = pcDataLayout.getSchema();
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        if (bizDataList.isEmpty()) {
            return Collections.emptyList();
        }
        List tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        if (StrUtil.isNotEmpty((CharSequence)mTagId) && "start_demo_so_athenaopt_mainline_project_0001".equals(mTagId)) {
            List columnTagList = this.columnTagService.listColumnTagsBymTagId(mTagId);
            return this.getItemListByBizDataAndColumnTag(schema, tableColumns, bizDataList, columnTagList, apiRequest, Collections.emptyMap());
        }
        List columnTagList = StringUtils.hasLength((String)apiRequest.getPageId()) && ("ZtbReceiptScheduleChange".equals(apiRequest.getLinkSchema()) || "MOBILE_PROJECT_CREATE".equalsIgnoreCase(apiRequest.getPageId()) || "MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL".equalsIgnoreCase(apiRequest.getPageId())) ? this.columnTagService.listColumnTagsByPathAndPageId(schema, apiRequest.getPageId()) : this.columnTagService.listColumnTagsByPath(schema);
        if (CollectionUtils.isEmpty((Collection)columnTagList)) {
            columnTagList = this.columnTagService.listColumnTagsByPath(schema);
        }
        return this.getItemListByBizDataAndColumnTag(schema, tableColumns, bizDataList, columnTagList, apiRequest, Collections.emptyMap());
    }

    private static String getTagId(UiBotExecuteContext executeContext) {
        String mTagId = String.valueOf(executeContext.get((Object)"tmActivityId"));
        if ("start_demo_so_athenaopt_mainline_project_0001".equals(mTagId)) {
            return mTagId;
        }
        return mTagId;
    }

    private List<InputWindowSingleItem> getItemListByBizDataAndColumnTag(String path, List<UiBotTableColumn> tableColumns, List<Map<String, Object>> bizDataList, List<ColumnTag> columnTagList, ApiRequest apiRequest, Map<String, Object> extendParam) {
        ArrayList<InputWindowSingleItem> itemList = new ArrayList<InputWindowSingleItem>();
        Map<String, UiBotTableColumn> tableColumnMap = tableColumns.stream().collect(Collectors.toMap(UiBotBizFieldBase::getSchema, c -> c, (c1, c2) -> c1));
        Map translateShowValueMap = this.getTranslateShowValueMap(tableColumns, columnTagList, apiRequest);
        List bizIdTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        List titleTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        List subtitleTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_SUBTITLE.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        List profileTagList = columnTagList.stream().filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        bizDataList.forEach(bizData -> {
            InputWindowSingleItem item = new InputWindowSingleItem();
            String id = this.getBusinessDataId(bizData, bizIdTagList);
            item.setId(StringUtil.isEmpty((CharSequence)id) ? this.getDisplayTitle(bizData, titleTagList) : id);
            item.setTitle(this.getDisplayTitle(bizData, titleTagList));
            item.setSubtitle(this.getDisplaySubtitle(bizData, subtitleTagList));
            item.setShowImage(Boolean.valueOf(false));
            item.setContent(this.getDisplayProfile(bizData, profileTagList, tableColumnMap, translateShowValueMap, extendParam));
            item.setDetail(bizData);
            item.setSeeMoreButton(this.buildSeeMoreButton(apiRequest, bizData));
            if (item.getTitle().isEmpty() && !item.getSubtitle().isEmpty()) {
                item.setTitle(item.getSubtitle());
            }
            if (StringUtil.isNotEmpty((CharSequence)item.getId())) {
                itemList.add(item);
            }
        });
        return itemList;
    }

    private Button<UiBotAction> buildSeeMoreButton(ApiRequest apiRequest, Map<String, Object> bizData) {
        Map apiRequestRawData = apiRequest.getRawData().getInnerMap();
        Object drilDownButton = apiRequestRawData.get("drilDownButton");
        Button seeMoreButton = (Button)JsonUtil.objectToJavaObject(drilDownButton, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (seeMoreButton == null) {
            return null;
        }
        Action action = seeMoreButton.getAction();
        if (action == null) {
            return null;
        }
        Map rawData = (Map)action.getRawData();
        if (rawData == null) {
            return null;
        }
        Object data = rawData.get("data");
        if (Objects.nonNull(data) && data instanceof Map) {
            Map dataMap = (Map)data;
            if (Objects.nonNull(apiRequestRawData.get("parameter"))) {
                Map parameter = (Map)apiRequestRawData.get("parameter");
                dataMap.putAll(parameter);
            }
            dataMap.putAll(bizData);
            rawData.put("data", dataMap);
        } else {
            rawData.put("data", bizData);
        }
        return seeMoreButton;
    }

    private Map<String, Map<String, String>> getTranslateShowValueMap(List<UiBotTableColumn> tableColumns, List<ColumnTag> columnTagList, ApiRequest apiRequest) {
        List columnTagSchemaList = columnTagList.stream().map(ColumnTag::getSchema).collect(Collectors.toList());
        List enumKeyIsNotEmptyuiBotTableColumnSet = tableColumns.stream().filter(e -> columnTagSchemaList.contains(e.getSchema()) && StringUtils.hasLength((String)e.getEnumKey())).collect(Collectors.toList());
        HashMap<String, Map<String, String>> translateShowValueMap = new HashMap<String, Map<String, String>>();
        for (UiBotTableColumn enumKeyIsNotEmptyuiBotTableColumn : enumKeyIsNotEmptyuiBotTableColumnSet) {
            List dictByKeyList = null;
            try {
                dictByKeyList = this.digiwinKnowledgeMapsProxyService.getDictByKey(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), enumKeyIsNotEmptyuiBotTableColumn.getEnumKey());
            }
            catch (Exception e2) {
                logger.error("InputWindowSingleItemBuilder getTranslateShowValueMap error:", (Throwable)e2);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)dictByKeyList)) continue;
            Map<String, String> dictMapByKey = dictByKeyList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("code")), e -> String.valueOf(e.get("value")), (c1, c2) -> c1));
            translateShowValueMap.put(enumKeyIsNotEmptyuiBotTableColumn.getSchema(), dictMapByKey);
        }
        return translateShowValueMap;
    }

    private String getBusinessDataId(Map<String, Object> bizData, List<ColumnTag> bizIdColumnTagList) {
        boolean tagCodeCorrect = bizIdColumnTagList.stream().allMatch(columnTag -> columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode()));
        if (!tagCodeCorrect) {
            return "";
        }
        StringBuffer resultSb = new StringBuffer();
        int separatorLength = 0;
        for (ColumnTag columnTag2 : bizIdColumnTagList) {
            String schema = columnTag2.getSchema();
            separatorLength = Optional.ofNullable(columnTag2.getSeparator()).map(String::length).orElse(0);
            resultSb.append(Optional.ofNullable(bizData.get(schema)).orElse("")).append(Optional.ofNullable(columnTag2.getSeparator()).orElse(";"));
        }
        if (resultSb.length() > 0) {
            return resultSb.substring(0, resultSb.length() - separatorLength).trim();
        }
        return "";
    }

    private String getDisplayTitle(Map<String, Object> bizData, List<ColumnTag> titleColumnTagList) {
        boolean tagCodeCorrect = titleColumnTagList.stream().allMatch(columnTag -> columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()));
        if (!tagCodeCorrect) {
            return "";
        }
        StringBuffer resultSb = new StringBuffer();
        int separatorLength = 0;
        for (ColumnTag columnTag2 : titleColumnTagList) {
            String schema = columnTag2.getSchema();
            separatorLength = Optional.ofNullable(columnTag2.getSeparator()).map(String::length).orElse(0);
            resultSb.append(Optional.ofNullable(bizData.get(schema)).orElse("")).append(Optional.ofNullable(columnTag2.getSeparator()).orElse(" "));
        }
        if (resultSb.length() > 0) {
            return resultSb.substring(0, resultSb.length() - separatorLength).trim();
        }
        return "";
    }

    private String getDisplaySubtitle(Map<String, Object> bizData, List<ColumnTag> subtitleColumnTagList) {
        boolean tagCodeCorrect = subtitleColumnTagList.stream().allMatch(columnTag -> columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_SUBTITLE.getCode()));
        if (!tagCodeCorrect) {
            return "";
        }
        StringBuffer resultSb = new StringBuffer();
        int separatorLength = 0;
        for (ColumnTag columnTag2 : subtitleColumnTagList) {
            String schema = columnTag2.getSchema();
            separatorLength = Optional.ofNullable(columnTag2.getSeparator()).map(String::length).orElse(0);
            resultSb.append(Optional.ofNullable(bizData.get(schema)).orElse("")).append(Optional.ofNullable(columnTag2.getSeparator()).orElse(" "));
        }
        if (resultSb.length() > 0) {
            return resultSb.substring(0, resultSb.length() - separatorLength).trim();
        }
        return "";
    }

    private List<String> getDisplayProfile(Map<String, Object> bizData, List<ColumnTag> profileColumnTagList, Map<String, UiBotTableColumn> tableColumnMap, Map<String, Map<String, String>> translateShowValueMap, Map<String, Object> extendParam) {
        boolean tagCodeCorrect = profileColumnTagList.stream().allMatch(columnTag -> columnTag.getTagDefinition().getCode().equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()));
        if (!tagCodeCorrect) {
            return Collections.emptyList();
        }
        Boolean isDesigner = (Boolean)MapUtil.getOrDefault(extendParam, (String)"isDesigner", (Object)false);
        ArrayList<String> result = new ArrayList<String>();
        profileColumnTagList.forEach(columnTag -> {
            String schema = columnTag.getSchema();
            if (tableColumnMap.get(schema) != null && StringUtil.isNotEmpty((CharSequence)Optional.ofNullable(bizData.get(schema)).map(Object::toString).orElse(""))) {
                String bizDataBySchema = String.valueOf(bizData.get(schema));
                if (BooleanUtils.isTrue((Boolean)isDesigner) && translateShowValueMap.containsKey(schema) && !StringUtils.hasLength((String)(bizDataBySchema = (String)((Map)translateShowValueMap.get(schema)).get(bizDataBySchema)))) {
                    bizDataBySchema = "-";
                }
                String content = ((UiBotTableColumn)tableColumnMap.get(schema)).getHeaderName() + " " + bizDataBySchema;
                result.add(content.trim());
            }
        });
        return result;
    }

    private void translate() {
    }

    private void getPageDefineParameter(ApiRawData rawData) {
        if (rawData.get((Object)"dataSourceSet") == null) {
            return;
        }
        if (rawData.getJSONObject("dataSourceSet").get((Object)"dataSourceList") == null) {
            return;
        }
        boolean isCheckEmpty = true;
        JSONArray jsonArray = rawData.getJSONObject("dataSourceSet").getJSONArray("dataSourceList");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject dataSourceDTO = jsonArray.getJSONObject(i);
            if (dataSourceDTO.get((Object)"action") == null || CollectionUtils.isEmpty((Collection)dataSourceDTO.getJSONObject("action").getJSONArray("actionParams"))) continue;
            isCheckEmpty = false;
        }
        if (isCheckEmpty) {
            rawData.put("parameter", null);
        }
    }

    private void parseActiveParentRowTypeParameter(ApiRawData rawData) {
        if (rawData.get((Object)"dataSourceSet") == null) {
            return;
        }
        JSONArray dataSourceList = rawData.getJSONObject("dataSourceSet").getJSONArray("dataSourceList");
        if (CollectionUtils.isEmpty((Collection)dataSourceList)) {
            return;
        }
        this.transParentParameter(dataSourceList, (Map)rawData.get((Object)"parameter"));
    }

    private void transParentParameter(JSONArray dataSourceList, Map<String, Object> parameter) {
        for (int i = 0; i < dataSourceList.size(); ++i) {
            JSONObject dataSourceDTO = dataSourceList.getJSONObject(i);
            if (!"ACTIVE_PARENT_ROW".equals(dataSourceDTO.get((Object)"parameterType")) || null == dataSourceDTO.get((Object)"action") || CollectionUtils.isEmpty((Collection)dataSourceDTO.getJSONObject("action").getJSONArray("actionParams"))) continue;
            JSONArray actionParams = dataSourceDTO.getJSONObject("action").getJSONArray("actionParams");
            Map parameterMapping = this.flatParameter(parameter);
            for (int j = 0; j < actionParams.size(); ++j) {
                JSONObject actionParameter = actionParams.getJSONObject(j);
                if (!"ACTIVE_PARENT_ROW".equals(actionParameter.getString("type"))) continue;
                Object paramValue = parameterMapping.get(actionParameter.getString("value"));
                actionParameter.put("type", (Object)"ACTIVE_ROW_CONSTANT");
                actionParameter.put("value", (Object)(null != paramValue ? String.valueOf(paramValue) : null));
            }
        }
    }

    private Map<String, Object> flatParameter(Map<String, Object> parameter) {
        HashMap<String, Object> parameterMapping = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(parameter)) {
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                parameterMapping.putAll(this.flatParameterHelp(entry.getKey(), entry.getValue(), 1));
            }
        }
        return parameterMapping;
    }

    private Map<String, Object> flatParameterHelp(String key, Object value, int recursionDepth) {
        Map map;
        HashMap<String, Object> parameterMapping = new HashMap<String, Object>();
        parameterMapping.put(key, value);
        if (null == value || recursionDepth >= 3) {
            return parameterMapping;
        }
        if (value instanceof List) {
            if (!CollectionUtils.isEmpty((Collection)((List)value))) {
                Object firstElement = ((List)value).get(0);
                parameterMapping.putAll(this.flatParameterHelp(key, firstElement, recursionDepth));
            }
        } else if (value instanceof Map && !CollectionUtils.isEmpty((Map)(map = (Map)value))) {
            for (Map.Entry entry : map.entrySet()) {
                int tmpRecursionDepth = recursionDepth;
                parameterMapping.putAll(this.flatParameterHelp(key + "." + (String)entry.getKey(), entry.getValue(), ++tmpRecursionDepth));
            }
        }
        return parameterMapping;
    }

    public InputWindowSingleResponseData buildInputWindowData(ApiRequest apiRequest) {
        InputWindowSingleResponseData responseData = InputWindowSingleResponseData.empty();
        Boolean useHasNext = apiRequest.getRawData().getBoolean("useHasNext");
        if (BooleanUtils.isTrue((Boolean)useHasNext)) {
            this.getPageDefineParameter(apiRequest.getRawData());
            this.parseActiveParentRowTypeParameter(apiRequest.getRawData());
        }
        QueryResultSet queryResultSet = this.digiwinAtdmProxyService.queryWithMetaData(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)apiRequest.getRawData()), apiRequest.getTenantId());
        this.merageOpenwindowData(queryResultSet);
        if (queryResultSet == null || queryResultSet.getMainQueryResult() == null) {
            return responseData;
        }
        List itemList = this.buildWindowItem(apiRequest, queryResultSet);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return responseData;
        }
        responseData.setSearchType(BooleanUtils.isTrue((Boolean)useHasNext) ? InputWindowSingleSelectSearchTypeEnum.BACKEND_SEARCH.getType() : InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        responseData.setList(itemList);
        responseData.setTotal(Integer.valueOf(itemList.size()));
        return responseData;
    }

    public List<InputWindowSingleItem> buildWindowItem(ApiRequest apiRequest, QueryResultSet queryResultSet) {
        ApiRawData rawData = apiRequest.getRawData();
        String dataSourceName = queryResultSet.getMainQueryResult().getDataSourceName();
        List columnTagList = this.buildDisplayField(dataSourceName, (List)rawData.get((Object)"roleAttention"), (List)rawData.get((Object)"dataKeys"));
        List bizDataList = this.getQueryResultData(rawData, (List)queryResultSet.getPageData().get(dataSourceName));
        this.handleDataSort(rawData, bizDataList);
        List tableColumns = this.createShowMetadataColumn(queryResultSet.getMainQueryResult().getApiMetadataCollection().getMasterApiMetadata());
        HashMap<String, Boolean> extendParam = new HashMap<String, Boolean>();
        extendParam.put("isDesigner", true);
        return this.getItemListByBizDataAndColumnTag(dataSourceName, tableColumns, bizDataList, columnTagList, apiRequest, extendParam);
    }

    private void handleDataSort(ApiRawData rawData, List<Map<String, Object>> bizDataList) {
        if (CollectionUtils.isEmpty(bizDataList)) {
            return;
        }
        Boolean useHasNext = rawData.getBoolean("useHasNext");
        if (BooleanUtils.isTrue((Boolean)useHasNext)) {
            return;
        }
        List mobileSortInfo = (List)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"mobileSortInfo"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty((Collection)mobileSortInfo)) {
            return;
        }
        List collect = bizDataList.stream().sorted((o1, o2) -> {
            for (PcUiBotTmOperationOpenWindowDefine.SortInfo sortInfo : mobileSortInfo) {
                int result;
                String sortField = sortInfo.getSortField();
                String dataType = sortInfo.getDataType();
                Object value1 = o1.get(sortField);
                Object value2 = o2.get(sortField);
                if ("string".equals(dataType)) {
                    Collator collator = "zh_CN".equalsIgnoreCase(AppRequestContext.getContextEntity().getLocale()) ? Collator.getInstance(Locale.SIMPLIFIED_CHINESE) : Collator.getInstance(Locale.TRADITIONAL_CHINESE);
                    result = collator.compare(value1, value2);
                } else if ("number".equals(dataType)) {
                    int num1 = value1 instanceof Number ? ((Number)value1).intValue() : 0;
                    int num2 = value2 instanceof Number ? ((Number)value2).intValue() : 0;
                    result = Integer.compare(num1, num2);
                } else {
                    result = 0;
                }
                if (result == 0) continue;
                return OrderOptionEnum.ASC.getType().equals(sortInfo.getSortType()) ? result : -result;
            }
            return 0;
        }).collect(Collectors.toList());
        bizDataList.clear();
        bizDataList.addAll(collect);
    }

    private List<Map<String, Object>> getQueryResultData(ApiRawData rawData, List<Map<String, Object>> bizDataList) {
        if (CollectionUtils.isEmpty(bizDataList)) {
            return new ArrayList<Map<String, Object>>();
        }
        String actionId = "";
        PcUiBotDataSourceSetDTO pcUiBotDataSourceSetDTO = (PcUiBotDataSourceSetDTO)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"dataSourceSet"), PcUiBotDataSourceSetDTO.class);
        List pcUiBotDataSourceDTOList = Optional.ofNullable(pcUiBotDataSourceSetDTO).map(PcUiBotDataSourceSetDTO::getDataSourceList).orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(pcUiBotDataSourceDTOList)) {
            actionId = ((PcUiBotDataSourceDTO)pcUiBotDataSourceDTOList.get(0)).getActionId();
        }
        if ("total_judgment_level".equals(rawData.getString("schema"))) {
            bizDataList = ((List)Optional.ofNullable((List)bizDataList.get(0).get("judgment_header_list")).orElse(new ArrayList())).stream().filter(r -> "1".equals(StringUtil.valueOf(r.get("judgment_type")))).collect(Collectors.toList());
        }
        if ("esp_question.eoc.dept.user.info.get".equalsIgnoreCase(actionId)) {
            bizDataList = bizDataList.stream().map(e -> {
                List employeeInfoListByDepartment = (List)MapUtil.getOrDefault((Map)e, (String)"employee_info", Collections.emptyList());
                employeeInfoListByDepartment.forEach(item -> {
                    item.put("department_id", e.get("department_id"));
                    item.put("department_name", e.get("department_name"));
                });
                return employeeInfoListByDepartment;
            }).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return bizDataList;
    }

    private List<ColumnTag> buildDisplayField(String dataSourceName, List<String> roleAttention, List<String> dataKeys) {
        ColumnTagDefinition tagDefinition;
        ColumnTag columnTag;
        int i;
        ArrayList<ColumnTag> columnTagList = new ArrayList<ColumnTag>();
        if (!CollectionUtils.isEmpty(roleAttention)) {
            for (i = 0; i < roleAttention.size(); ++i) {
                columnTag = new ColumnTag().setPath(dataSourceName).setSchema(roleAttention.get(i)).setOrderNo(Integer.valueOf(i));
                columnTagList.add(columnTag);
                tagDefinition = new ColumnTagDefinition();
                columnTag.setTagDefinition(tagDefinition);
                if (i == 0) {
                    tagDefinition.setCode(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode());
                    continue;
                }
                tagDefinition.setCode(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode());
            }
        }
        if (!CollectionUtils.isEmpty(dataKeys)) {
            for (i = 0; i < dataKeys.size(); ++i) {
                columnTag = new ColumnTag().setPath(dataSourceName).setSchema(dataKeys.get(i)).setOrderNo(Integer.valueOf(i)).setSeparator("&&&&");
                columnTagList.add(columnTag);
                tagDefinition = new ColumnTagDefinition();
                columnTag.setTagDefinition(tagDefinition);
                tagDefinition.setCode(ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode());
            }
        }
        return columnTagList;
    }

    private List<UiBotTableColumn> createShowMetadataColumn(PcUiBotApiMetadata masterApiMetadata) {
        List subFields = ((PcUiBotMetadataField)masterApiMetadata.getResponseFields().get(0)).getSubFields();
        return subFields.stream().map(r -> {
            UiBotTableColumn uiBotTableColumn = new UiBotTableColumn();
            uiBotTableColumn.setDataType(r.getDataType());
            uiBotTableColumn.setHeaderName(r.getDescription());
            uiBotTableColumn.setPath(r.getPath());
            uiBotTableColumn.setSchema(r.getName());
            uiBotTableColumn.setEnumKey(r.getEnumKey());
            return uiBotTableColumn;
        }).collect(Collectors.toList());
    }

    private void merageOpenwindowData(QueryResultSet queryResultSet) {
        if (queryResultSet != null && queryResultSet.contains("suggestActionName")) {
            Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
            QueryResult queryResult_main = new QueryResult();
            QueryResult queryResult = new QueryResult();
            if (group.size() > 1) {
                for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
                    List<QueryResult> resultList = groupItem.getValue();
                    if (CollectionUtils.isEmpty(resultList)) continue;
                    for (QueryResult queryResult_tmp : resultList) {
                        if ("allActionName".equals(queryResult_tmp.getDataSourceName())) {
                            queryResult_tmp.getData().forEach(item -> item.put("recommend", false));
                            queryResult_main = queryResult_tmp;
                            if (queryResult.getData() != null) {
                                queryResult_main.getData().removeAll(queryResult_tmp.getData());
                                queryResult_main.getData().addAll(0, queryResult.getData());
                                queryResultSet.getQueryResults().remove(queryResult_tmp);
                                queryResult = queryResult_main;
                                queryResultSet.getQueryResults().add(queryResult_main);
                                continue;
                            }
                            queryResult = queryResult_tmp;
                            continue;
                        }
                        if (!"suggestActionName".equals(queryResult_tmp.getDataSourceName())) continue;
                        queryResult_tmp.getData().forEach(item -> item.put("recommend", true));
                        if (queryResult.getData() != null) {
                            queryResultSet.getQueryResults().remove(queryResult_tmp);
                            queryResult.getData().addAll(0, queryResult_tmp.getData());
                            queryResult.getDataKeyIndex().putAll(queryResult_tmp.getDataKeyIndex());
                            continue;
                        }
                        queryResult = queryResult_tmp;
                        queryResultSet.getQueryResults().remove(queryResult_tmp);
                    }
                }
                if (queryResult_main.getData() != null && !queryResult_main.getData().isEmpty() && ((Map)queryResult_main.getData().get(0)).get("__DATA_KEY") != null) {
                    ArrayList listalls = new ArrayList();
                    ArrayList listallT = new ArrayList();
                    ArrayList listallF = new ArrayList();
                    queryResult_main.getData().forEach(data -> {
                        Optional<Map> optional;
                        if (data.containsKey("recommend") && ((Boolean)data.get("recommend")).booleanValue()) {
                            listallT.add(data);
                        } else if (data.containsKey("__DATA_KEY") && !(optional = listallT.stream().filter(t -> t.containsKey("__DATA_KEY") && t.get("__DATA_KEY").equals(data.get("__DATA_KEY"))).findFirst()).isPresent()) {
                            listallF.add(data);
                        }
                    });
                    listalls.addAll(listallT);
                    listalls.addAll(listallF);
                    queryResult_main.resetData(listalls);
                    queryResultSet.setMainQueryResult(queryResult_main);
                }
            }
            if (group.size() == 1 && "suggestActionName".equals(queryResultSet.getMainQueryResult().getDataSourceName())) {
                queryResultSet.getMainQueryResult().getData().forEach(item -> item.put("recommend", true));
                if (queryResultSet.getQueryResults() != null && !queryResultSet.getQueryResults().isEmpty()) {
                    ((QueryResult)queryResultSet.getQueryResults().get(0)).getData().forEach(item -> item.put("recommend", true));
                }
            }
        }
    }
}

