/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc;

import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuildData;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilder;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class BasePageDescBuilder
implements PageDescBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BasePageDescBuilder.class);
    private final List<String> pcLayoutTypeList = new ArrayList(2);

    protected List<String> getPcLayoutTypeList() {
        return this.pcLayoutTypeList;
    }

    public BasePageDescBuilder() {
        this.pcLayoutTypeList.add("ACTIVITY_TITLE");
        this.pcLayoutTypeList.add("APPROVAL_DESCRIPTION");
    }

    protected Integer getOverdueDateIconData() {
        return 58990;
    }

    protected Integer getProjectNameOnCardIconData() {
        return 58995;
    }

    protected Integer getProjectSourceInfoIconData() {
        return 58997;
    }

    protected Integer getProjectInitiatorInfoIconData() {
        return 59021;
    }

    protected Integer getProjectTimeDistanceIconData() {
        return 58995;
    }

    protected Integer getProjectNoIconData() {
        return 59274;
    }

    protected Integer getProjectNameIconData() {
        return 58997;
    }

    protected Integer getProjectLeaderNameIconData() {
        return 59273;
    }

    protected List<PageDescBuildData> extractBuildData(UiBotModel pcUiBotModel) {
        ArrayList<PageDescBuildData> buildData = new ArrayList<PageDescBuildData>(this.getPcLayoutTypeList().size());
        for (String pcLayoutType : this.pcLayoutTypeList) {
            Optional<UiBotLayout> optLayout = pcUiBotModel.getLayout().stream().filter(layout -> layout.getType() != null && layout.getType().equalsIgnoreCase(pcLayoutType)).findFirst();
            optLayout.ifPresent(uiBotLayout -> {
                String schema = uiBotLayout.getSchema();
                Map data = (Map)pcUiBotModel.getPageData().get((Object)schema);
                if (null != uiBotLayout.getGroup()) {
                    buildData.add(PageDescBuildData.create((String)pcLayoutType, (Map)data, (List)uiBotLayout.getGroup()));
                } else {
                    buildData.add(PageDescBuildData.create((String)pcLayoutType, (Map)data));
                }
            });
        }
        return buildData;
    }

    protected void addDescriptionalDataToPageDesc(PageDesc pageDesc, PageDescBuildData buildData) {
        for (UiBotLayout uiBotFieldLayout : buildData.getFieldLayoutList()) {
            String fieldSchema = uiBotFieldLayout.getSchema();
            if (!"LABEL".equalsIgnoreCase(uiBotFieldLayout.getType()) || !buildData.getData().containsKey(fieldSchema)) continue;
            String title = uiBotFieldLayout.getTitle();
            if (!StringUtils.hasLength((String)title)) {
                title = uiBotFieldLayout.getHeaderName();
            }
            String value = String.valueOf(buildData.getData().get(fieldSchema));
            StringJoiner sj = new StringJoiner(":");
            sj.add(title);
            sj.add(StringUtils.hasLength((String)value) ? value : "-");
            Integer iconData = -1;
            if ("project_no".equalsIgnoreCase(fieldSchema)) {
                iconData = this.getProjectNoIconData();
            }
            if ("project_name".equalsIgnoreCase(fieldSchema)) {
                iconData = this.getProjectNameIconData();
            }
            if ("project_leader_name".equalsIgnoreCase(fieldSchema)) {
                iconData = this.getProjectLeaderNameIconData();
            }
            pageDesc.addContent(iconData, sj.toString(), PageDescContentTypeEnum.NORMAL.getValue());
        }
    }
}

