/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.table.TableColumnColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.table.TableCompoundColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.AgileDataTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.TableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class TableColumnConfig
implements Serializable {
    private static final long serialVersionUID = -783269710476001751L;
    private Boolean canDrillDown;
    private String columnId;
    private Action action;
    private String fontColor = TableColumnColorEnum.NORMAL.getColor();
    private List<TableCompoundColumn> compoundCols;

    public void clearFontColor() {
        this.fontColor = null;
    }

    public static TableColumnConfig create(AgileDataTableColumn column, UiBotExecuteContext executeContext) {
        TableColumnConfig tableColumnConfig = new TableColumnConfig();
        tableColumnConfig.buildFontColor(tableColumnConfig, column.getOperations());
        tableColumnConfig.setColumnId(column.getSchema());
        tableColumnConfig.setAction(Action.createDrilDown((AgileDataTableColumn)column, (UiBotExecuteContext)executeContext));
        return tableColumnConfig;
    }

    public static TableColumnConfig create(UiBotTableColumn column, UiBotExecuteContext executeContext) {
        TableColumnConfig tableColumnConfig = new TableColumnConfig();
        tableColumnConfig.setColumnId(column.getSchema());
        tableColumnConfig.buildFontColor(tableColumnConfig, column.getOperations());
        tableColumnConfig.setAction(Action.createDrilDown((UiBotTableColumn)column, (UiBotExecuteContext)executeContext));
        return tableColumnConfig;
    }

    public static TableColumnConfig create(TableColumnDefinition tableColumnDefinition, List<TableCompoundColumn> compoundCols, List<JSONObject> tableData, UiBotExecuteContext executeContext) {
        TableColumnConfig tableColumnConfig = new TableColumnConfig();
        tableColumnConfig.setColumnId(tableColumnDefinition.getSchema());
        tableColumnConfig.setCompoundCols(compoundCols);
        return tableColumnConfig;
    }

    public void buildFontColor(TableColumnConfig tableColumnConfig, JSONArray operations) {
        if (AgileDataTableColumn.canDrillDown((JSONArray)operations).booleanValue()) {
            tableColumnConfig.setCanDrillDown(Boolean.valueOf(true));
            tableColumnConfig.setFontColor(TableColumnColorEnum.CAN_DRILL_DOWN.getColor());
        } else if (AgileDataTableColumn.isHighlight((JSONArray)operations).booleanValue()) {
            tableColumnConfig.setFontColor(TableColumnColorEnum.HIGHLIGHT.getColor());
        } else {
            tableColumnConfig.setCanDrillDown(Boolean.valueOf(false));
        }
    }

    public static List<TableColumnConfig> getTableColumnConfigs(List<TableColumnDefinition> columnDefinitionList, List<UiBotTableColumn> decomposedColumnList, List<JSONObject> tableData, UiBotExecuteContext executeContext) {
        ArrayList<TableColumnConfig> columnConfigs = new ArrayList<TableColumnConfig>(columnDefinitionList.size());
        for (TableColumnDefinition tableColumnDefinition : columnDefinitionList) {
            TableColumnConfig tableColumnConfig;
            if (tableColumnDefinition.preferCompoundMode()) {
                tableColumnConfig = TableColumnConfig.create((TableColumnDefinition)tableColumnDefinition, (List)TableCompoundColumn.getCompoundColumns((TableColumnDefinition)tableColumnDefinition), tableData, (UiBotExecuteContext)executeContext);
            } else {
                UiBotTableColumn tableColumn = (UiBotTableColumn)tableColumnDefinition.getColumns().get(0);
                tableColumnConfig = TableColumnConfig.create((UiBotTableColumn)tableColumn, (UiBotExecuteContext)executeContext);
            }
            columnConfigs.add(tableColumnConfig);
        }
        return columnConfigs;
    }

    public Boolean getCanDrillDown() {
        return this.canDrillDown;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public Action getAction() {
        return this.action;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public List<TableCompoundColumn> getCompoundCols() {
        return this.compoundCols;
    }

    public void setCanDrillDown(Boolean canDrillDown) {
        this.canDrillDown = canDrillDown;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public void setCompoundCols(List<TableCompoundColumn> compoundCols) {
        this.compoundCols = compoundCols;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableColumnConfig)) {
            return false;
        }
        TableColumnConfig other = (TableColumnConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$canDrillDown = this.getCanDrillDown();
        Boolean other$canDrillDown = other.getCanDrillDown();
        if (this$canDrillDown == null ? other$canDrillDown != null : !((Object)this$canDrillDown).equals(other$canDrillDown)) {
            return false;
        }
        String this$columnId = this.getColumnId();
        String other$columnId = other.getColumnId();
        if (this$columnId == null ? other$columnId != null : !this$columnId.equals(other$columnId)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$fontColor = this.getFontColor();
        String other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !this$fontColor.equals(other$fontColor)) {
            return false;
        }
        List this$compoundCols = this.getCompoundCols();
        List other$compoundCols = other.getCompoundCols();
        return !(this$compoundCols == null ? other$compoundCols != null : !((Object)this$compoundCols).equals(other$compoundCols));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableColumnConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $canDrillDown = this.getCanDrillDown();
        result = result * 59 + ($canDrillDown == null ? 43 : ((Object)$canDrillDown).hashCode());
        String $columnId = this.getColumnId();
        result = result * 59 + ($columnId == null ? 43 : $columnId.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : $fontColor.hashCode());
        List $compoundCols = this.getCompoundCols();
        result = result * 59 + ($compoundCols == null ? 43 : ((Object)$compoundCols).hashCode());
        return result;
    }

    public String toString() {
        return "TableColumnConfig(canDrillDown=" + this.getCanDrillDown() + ", columnId=" + this.getColumnId() + ", action=" + this.getAction() + ", fontColor=" + this.getFontColor() + ", compoundCols=" + this.getCompoundCols() + ")";
    }

    public TableColumnConfig() {
    }

    public TableColumnConfig(Boolean canDrillDown, String columnId, Action action, String fontColor, List<TableCompoundColumn> compoundCols) {
        this.canDrillDown = canDrillDown;
        this.columnId = columnId;
        this.action = action;
        this.fontColor = fontColor;
        this.compoundCols = compoundCols;
    }
}

