/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.title.titlebody;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBodyBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component(value="baseTitleBodyBuilder")
public class BaseTitleBodyBuilder
implements TitleBodyBuilder {
    private static final Logger log = LoggerFactory.getLogger(BaseTitleBodyBuilder.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;
    private volatile Map<String, String> componentMap = new HashMap();

    public BaseTitleBodyBuilder() {
        this.componentMap.put(this.getMobileComponentType(), "ACTIVITY_TITLE");
    }

    public TitleBody build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        Optional<UiBotLayout> optLayout = pcUiBotModel.getLayout().stream().filter(layout -> "ACTIVITY_TITLE".equals(layout.getType())).findFirst();
        if (!optLayout.isPresent()) {
            return TitleBody.createEmpty();
        }
        UiBotLayout layout2 = optLayout.get();
        String schema = layout2.getSchema();
        Map data = (Map)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)data, (String)("pagedata." + schema + " cannot be null"));
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail)args[0];
        Map uiBotActivityData = (Map)pcUiBotModel.getPageData().get((Object)"uiBot__activity");
        String planEndTimeMin = MapUtils.getString((Map)uiBotActivityData, (Object)"planEndTimeMin");
        String planEndTimeMax = MapUtils.getString((Map)uiBotActivityData, (Object)"planEndTimeMax");
        String endMonthDate = BooleanUtils.isTrue((Boolean)digiwinAtmcBacklogDetail.getMerge()) && !Objects.equals(planEndTimeMin, planEndTimeMax) ? DateTimeUtil.getMonthDateOfTime((String)planEndTimeMin) + "-" + DateTimeUtil.getMonthDateOfTime((String)planEndTimeMax) : DateTimeUtil.getMonthDateOfTime((String)MapUtils.getString((Map)uiBotActivityData, (Object)"endTime"));
        String systemTip = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u9700\u5b8c\u6210");
        String taskName = (String)uiBotActivityData.get("name");
        String approvalState = digiwinAtmcBacklogDetail.getApprovalState();
        String overdueDate = Optional.ofNullable(digiwinAtmcBacklogDetail.getOverdueDate()).orElse(Optional.ofNullable((String)data.get("overdueDate")).orElse(""));
        String remainTime = Optional.ofNullable(digiwinAtmcBacklogDetail.getRemainTime()).orElse(Optional.ofNullable((String)data.get("remainTime")).orElse(""));
        boolean isOverdue = !overdueDate.isEmpty() && remainTime.isEmpty();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (StringUtils.hasLength((String)approvalState)) {
            Tag approvalStateTag = Tag.createApprovalStateTag((String)approvalState);
            tags.add(approvalStateTag);
        }
        Tag timeHintTag = isOverdue ? Tag.createWarningTag((String)(this.localeService.getLanguageValue(locale, "\u903e\u671f") + overdueDate)) : Tag.createPromptTag((String)(this.localeService.getLanguageValue(locale, "\u5012\u8ba1\u65f6") + remainTime));
        tags.add(timeHintTag);
        return TitleBody.create((String)(endMonthDate + systemTip + " " + taskName), (PageDesc)this.pageDescBuilderFactory.get("BUSINESS_REPORT").build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args), (Tag)timeHintTag, tags);
    }
}

