/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.layout.generator;

import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import com.digiwin.mobile.mobileuibot.core.layout.generator.LayoutGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="singlePatternLayoutGenerator")
public class SinglePatternLayoutGenerator
implements LayoutGenerator {
    private static final Logger log = LoggerFactory.getLogger(SinglePatternLayoutGenerator.class);

    public String getType() {
        return MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT.getValue();
    }

    public BaseLayoutMobileComponent generate(LayoutGeneratorPreprocessData preprocessData) {
        int renderVersion = preprocessData.getRenderVersion();
        if (MobileRenderMetaData.RENDER_VERSION_1 == renderVersion) {
            return this.generateUseCustomGroup(preprocessData);
        }
        if (MobileRenderMetaData.RENDER_VERSION_2 == renderVersion) {
            return this.generateUseSingleListContainer(preprocessData);
        }
        return this.generateUseCustomGroup(preprocessData);
    }

    private CustomGroup generateUseCustomGroup(LayoutGeneratorPreprocessData preprocessData) {
        return CustomGroup.create((String)"", (CustomGroupStyleTypeEnum)CustomGroupStyleTypeEnum.STYLE_INPUT_FORM);
    }

    private SingleListContainer generateUseSingleListContainer(LayoutGeneratorPreprocessData preprocessData) {
        return new SingleListContainer();
    }
}

