/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.rule;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleInitConfig;
import com.digiwin.mobile.mobileuibot.core.rule.RuleMappingConfig;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleUtil;
import com.digiwin.mobile.mobileuibot.core.rule.RuleValidCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Document(collection="mobileUiBotRule")
public class Rule
implements Serializable {
    private static final long serialVersionUID = -7984118157325999337L;
    @Field(value="_id")
    private String id;
    private String category;
    private String subcategory;
    private String path;
    private String schema;
    private String parameter;
    private String type;
    private String errorMsgPrefix;
    private String condition;
    private Integer conditionOperatorType;
    private String targetSchema;
    private String targetEnable;
    private String targetRequired;
    private String targetPlaceholder;
    private String targetHidden;
    private String scope;
    private Boolean valid;
    private List<RuleValidCondition> validConditions;
    private RuleInitConfig initConfig;
    private String remark;
    private String componentType;
    private RuleMappingConfig mappingConfig;
    private CommonRule commonRule;
    private Map<String, String> errorMessage;
    private String targetText;
    private Integer operatorType;
    private Integer order;
    private String parameterDataType;
    private String tenantId;
    private String pageId;

    public boolean calculateTargetPropertyResult(Map<String, Object> bizData, String targetPropertyExpression) {
        boolean result = false;
        if (null == targetPropertyExpression || targetPropertyExpression.isEmpty()) {
            return result;
        }
        if (!RuleUtil.validExpression((String)targetPropertyExpression)) {
            if (!RuleUtil.validBooleanValue((String)targetPropertyExpression)) {
                return false;
            }
            return Boolean.parseBoolean(targetPropertyExpression);
        }
        String expressionBizDataKey = RuleUtil.analyzeExpressionBizDataKey((String)targetPropertyExpression);
        Object bizDataValue = bizData.get(expressionBizDataKey);
        if (bizDataValue instanceof Boolean) {
            result = (Boolean)bizDataValue;
        }
        return result;
    }

    public boolean validWithBizData(Map<String, Object> bizData) {
        if (!this.getValid().booleanValue()) {
            boolean bl = false;
        }
        boolean result = CollectionUtils.isEmpty((Collection)this.getValidConditions()) ? true : this.getValidConditions().stream().allMatch(validCondition -> validCondition.conditionIsTrue(bizData));
        return result;
    }

    public static boolean hasCustomMadeRule(ApiRequest apiRequest, List<Rule> ruleList) {
        List customMadeRules = ruleList.stream().filter(r -> null != r.getTenantId()).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(customMadeRules);
    }

    public static List<Rule> compareRule(ApiRequest apiRequest, List<Rule> ruleList, String ruleType) {
        List<Object> compareRule = new ArrayList();
        List customMadeRules = Rule.customMadeRules((String)apiRequest.getTenantId(), ruleList);
        switch (ruleType) {
            case "INIT": {
                compareRule = Rule.compareInitRule(ruleList, (List)customMadeRules, (String)apiRequest.getTenantId());
                break;
            }
            case "validate": {
                compareRule = Rule.compareValidateRule(ruleList, (List)customMadeRules, (String)apiRequest.getTenantId());
                break;
            }
            case "relation": {
                compareRule = Rule.compareRelationRule(ruleList, (List)customMadeRules, (String)apiRequest.getTenantId());
                break;
            }
            default: {
                compareRule = ruleList;
            }
        }
        return compareRule;
    }

    public static List<Rule> compareInitRule(List<Rule> ruleList, List<Rule> customMadeRules, String tenantId) {
        List<Object> compareInitRule = ruleList.stream().filter(r -> null == r.getTenantId()).collect(Collectors.toList());
        compareInitRule.addAll(customMadeRules);
        for (Rule rule : ruleList) {
            if (customMadeRules.size() <= 0) continue;
            RuleInitConfig initConfig = rule.getInitConfig();
            Rule rule1 = customMadeRules.stream().filter(r1 -> initConfig.getComponentType().equalsIgnoreCase(r1.getInitConfig().getComponentType()) && initConfig.getDataType().equalsIgnoreCase(r1.getInitConfig().getDataType()) && initConfig.getEnable() == r1.getInitConfig().getEnable()).findFirst().orElse(null);
            if (null == rule1) continue;
            compareInitRule = compareInitRule.stream().filter(r2 -> !rule1.getInitConfig().getComponentType().equalsIgnoreCase(r2.getInitConfig().getComponentType()) || !rule1.getInitConfig().getDataType().equalsIgnoreCase(r2.getInitConfig().getDataType()) || rule1.getInitConfig().getEnable() != r2.getInitConfig().getEnable() || tenantId.equalsIgnoreCase(r2.getTenantId())).collect(Collectors.toList());
        }
        return compareInitRule;
    }

    public static List<Rule> compareValidateRule(List<Rule> ruleList, List<Rule> customMadeRules, String tenantId) {
        List<Object> compareValidateRule = ruleList.stream().filter(r -> null == r.getTenantId()).collect(Collectors.toList());
        compareValidateRule.addAll(customMadeRules);
        for (Rule rule : ruleList) {
            if (customMadeRules.size() <= 0) continue;
            switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$rule$validate$ValidateRuleTypeEnum[ValidateRuleTypeEnum.getEnumByValue((String)rule.getType()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    Rule ruleAppoint = customMadeRules.stream().filter(r1 -> rule.getPath().equalsIgnoreCase(r1.getPath()) && rule.getSchema().equalsIgnoreCase(r1.getSchema()) && rule.getParameter().equalsIgnoreCase(r1.getParameter()) && rule.getOrder() == r1.getOrder()).findFirst().orElse(null);
                    if (null == ruleAppoint) break;
                    compareValidateRule = compareValidateRule.stream().filter(r2 -> !ruleAppoint.getPath().equalsIgnoreCase(r2.getPath()) || !ruleAppoint.getSchema().equalsIgnoreCase(r2.getSchema()) || !ruleAppoint.getParameter().equalsIgnoreCase(r2.getParameter()) || ruleAppoint.getOrder() != r2.getOrder() || tenantId.equalsIgnoreCase(r2.getTenantId())).collect(Collectors.toList());
                    break;
                }
            }
        }
        return compareValidateRule;
    }

    public static List<Rule> compareRelationRule(List<Rule> ruleList, List<Rule> customMadeRules, String tenantId) {
        List<Object> compareRelationRule = ruleList.stream().filter(r -> null == r.getTenantId()).collect(Collectors.toList());
        compareRelationRule.addAll(customMadeRules);
        for (Rule rule : ruleList) {
            switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$rule$RuleSubcategoryEnum[RuleSubcategoryEnum.getEnumByValue((String)rule.getSubcategory()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    Rule rule1 = customMadeRules.stream().filter(r1 -> rule.getPath().equalsIgnoreCase(r1.getPath()) && rule.getSchema().equalsIgnoreCase(r1.getSchema()) && rule.getCondition().equalsIgnoreCase(r1.getCondition()) && rule.getConditionOperatorType() == r1.getConditionOperatorType() && rule.getTargetSchema().equalsIgnoreCase(r1.getTargetSchema())).findFirst().orElse(null);
                    if (null == rule1) break;
                    compareRelationRule = compareRelationRule.stream().filter(r2 -> !rule1.getPath().equalsIgnoreCase(r2.getPath()) || !rule1.getSchema().equalsIgnoreCase(r2.getSchema()) || !rule1.getCondition().equalsIgnoreCase(r2.getCondition()) || rule1.getConditionOperatorType() != r2.getConditionOperatorType() || !rule1.getTargetSchema().equalsIgnoreCase(r2.getTargetSchema()) || tenantId.equalsIgnoreCase(r2.getTenantId())).collect(Collectors.toList());
                    break;
                }
                case 3: {
                    Rule ruleCommon = customMadeRules.stream().filter(r1 -> rule.getPath().equalsIgnoreCase(r1.getPath()) && rule.getSchema().equalsIgnoreCase(r1.getSchema()) && rule.getCommonRule() != null && r1.getCommonRule() != null && rule.getCommonRule().getCondition() == r1.getCommonRule().getCondition() && rule.getCommonRule().getTargetSchema().equalsIgnoreCase(r1.getCommonRule().getTargetSchema())).findFirst().orElse(null);
                    if (null == ruleCommon) break;
                    compareRelationRule = compareRelationRule.stream().filter(r2 -> !ruleCommon.getPath().equalsIgnoreCase(r2.getPath()) || !ruleCommon.getSchema().equalsIgnoreCase(r2.getSchema()) || ruleCommon.getCommonRule().getCondition() != r2.getCommonRule().getCondition() || !ruleCommon.getCommonRule().getTargetSchema().equalsIgnoreCase(r2.getCommonRule().getTargetSchema()) || tenantId.equalsIgnoreCase(r2.getTenantId())).collect(Collectors.toList());
                    break;
                }
            }
        }
        return compareRelationRule;
    }

    public static List<Rule> customMadeRules(String pcTenantId, List<Rule> ruleList) {
        List<Rule> customMadeRules = ruleList.stream().filter(r -> pcTenantId.equalsIgnoreCase(r.getTenantId())).collect(Collectors.toList());
        return customMadeRules;
    }

    public String errorMessageInfo(String locale) {
        String errorMessage = (String)this.errorMessage.get(locale);
        return errorMessage;
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public String getPath() {
        return this.path;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getType() {
        return this.type;
    }

    public String getErrorMsgPrefix() {
        return this.errorMsgPrefix;
    }

    public String getCondition() {
        return this.condition;
    }

    public Integer getConditionOperatorType() {
        return this.conditionOperatorType;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public String getTargetEnable() {
        return this.targetEnable;
    }

    public String getTargetRequired() {
        return this.targetRequired;
    }

    public String getTargetPlaceholder() {
        return this.targetPlaceholder;
    }

    public String getTargetHidden() {
        return this.targetHidden;
    }

    public String getScope() {
        return this.scope;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public List<RuleValidCondition> getValidConditions() {
        return this.validConditions;
    }

    public RuleInitConfig getInitConfig() {
        return this.initConfig;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public RuleMappingConfig getMappingConfig() {
        return this.mappingConfig;
    }

    public CommonRule getCommonRule() {
        return this.commonRule;
    }

    public Map<String, String> getErrorMessage() {
        return this.errorMessage;
    }

    public String getTargetText() {
        return this.targetText;
    }

    public Integer getOperatorType() {
        return this.operatorType;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getParameterDataType() {
        return this.parameterDataType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setSubcategory(String subcategory) {
        this.subcategory = subcategory;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setErrorMsgPrefix(String errorMsgPrefix) {
        this.errorMsgPrefix = errorMsgPrefix;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setConditionOperatorType(Integer conditionOperatorType) {
        this.conditionOperatorType = conditionOperatorType;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public void setTargetEnable(String targetEnable) {
        this.targetEnable = targetEnable;
    }

    public void setTargetRequired(String targetRequired) {
        this.targetRequired = targetRequired;
    }

    public void setTargetPlaceholder(String targetPlaceholder) {
        this.targetPlaceholder = targetPlaceholder;
    }

    public void setTargetHidden(String targetHidden) {
        this.targetHidden = targetHidden;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public void setValidConditions(List<RuleValidCondition> validConditions) {
        this.validConditions = validConditions;
    }

    public void setInitConfig(RuleInitConfig initConfig) {
        this.initConfig = initConfig;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setMappingConfig(RuleMappingConfig mappingConfig) {
        this.mappingConfig = mappingConfig;
    }

    public void setCommonRule(CommonRule commonRule) {
        this.commonRule = commonRule;
    }

    public void setErrorMessage(Map<String, String> errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setTargetText(String targetText) {
        this.targetText = targetText;
    }

    public void setOperatorType(Integer operatorType) {
        this.operatorType = operatorType;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setParameterDataType(String parameterDataType) {
        this.parameterDataType = parameterDataType;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$conditionOperatorType = this.getConditionOperatorType();
        Integer other$conditionOperatorType = other.getConditionOperatorType();
        if (this$conditionOperatorType == null ? other$conditionOperatorType != null : !((Object)this$conditionOperatorType).equals(other$conditionOperatorType)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        Integer this$operatorType = this.getOperatorType();
        Integer other$operatorType = other.getOperatorType();
        if (this$operatorType == null ? other$operatorType != null : !((Object)this$operatorType).equals(other$operatorType)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$subcategory = this.getSubcategory();
        String other$subcategory = other.getSubcategory();
        if (this$subcategory == null ? other$subcategory != null : !this$subcategory.equals(other$subcategory)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        if (this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$errorMsgPrefix = this.getErrorMsgPrefix();
        String other$errorMsgPrefix = other.getErrorMsgPrefix();
        if (this$errorMsgPrefix == null ? other$errorMsgPrefix != null : !this$errorMsgPrefix.equals(other$errorMsgPrefix)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        String this$targetSchema = this.getTargetSchema();
        String other$targetSchema = other.getTargetSchema();
        if (this$targetSchema == null ? other$targetSchema != null : !this$targetSchema.equals(other$targetSchema)) {
            return false;
        }
        String this$targetEnable = this.getTargetEnable();
        String other$targetEnable = other.getTargetEnable();
        if (this$targetEnable == null ? other$targetEnable != null : !this$targetEnable.equals(other$targetEnable)) {
            return false;
        }
        String this$targetRequired = this.getTargetRequired();
        String other$targetRequired = other.getTargetRequired();
        if (this$targetRequired == null ? other$targetRequired != null : !this$targetRequired.equals(other$targetRequired)) {
            return false;
        }
        String this$targetPlaceholder = this.getTargetPlaceholder();
        String other$targetPlaceholder = other.getTargetPlaceholder();
        if (this$targetPlaceholder == null ? other$targetPlaceholder != null : !this$targetPlaceholder.equals(other$targetPlaceholder)) {
            return false;
        }
        String this$targetHidden = this.getTargetHidden();
        String other$targetHidden = other.getTargetHidden();
        if (this$targetHidden == null ? other$targetHidden != null : !this$targetHidden.equals(other$targetHidden)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        List this$validConditions = this.getValidConditions();
        List other$validConditions = other.getValidConditions();
        if (this$validConditions == null ? other$validConditions != null : !((Object)this$validConditions).equals(other$validConditions)) {
            return false;
        }
        RuleInitConfig this$initConfig = this.getInitConfig();
        RuleInitConfig other$initConfig = other.getInitConfig();
        if (this$initConfig == null ? other$initConfig != null : !this$initConfig.equals(other$initConfig)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$componentType = this.getComponentType();
        String other$componentType = other.getComponentType();
        if (this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType)) {
            return false;
        }
        RuleMappingConfig this$mappingConfig = this.getMappingConfig();
        RuleMappingConfig other$mappingConfig = other.getMappingConfig();
        if (this$mappingConfig == null ? other$mappingConfig != null : !this$mappingConfig.equals(other$mappingConfig)) {
            return false;
        }
        CommonRule this$commonRule = this.getCommonRule();
        CommonRule other$commonRule = other.getCommonRule();
        if (this$commonRule == null ? other$commonRule != null : !this$commonRule.equals(other$commonRule)) {
            return false;
        }
        Map this$errorMessage = this.getErrorMessage();
        Map other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !((Object)this$errorMessage).equals(other$errorMessage)) {
            return false;
        }
        String this$targetText = this.getTargetText();
        String other$targetText = other.getTargetText();
        if (this$targetText == null ? other$targetText != null : !this$targetText.equals(other$targetText)) {
            return false;
        }
        String this$parameterDataType = this.getParameterDataType();
        String other$parameterDataType = other.getParameterDataType();
        if (this$parameterDataType == null ? other$parameterDataType != null : !this$parameterDataType.equals(other$parameterDataType)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$pageId = this.getPageId();
        String other$pageId = other.getPageId();
        return !(this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $conditionOperatorType = this.getConditionOperatorType();
        result = result * 59 + ($conditionOperatorType == null ? 43 : ((Object)$conditionOperatorType).hashCode());
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        Integer $operatorType = this.getOperatorType();
        result = result * 59 + ($operatorType == null ? 43 : ((Object)$operatorType).hashCode());
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $subcategory = this.getSubcategory();
        result = result * 59 + ($subcategory == null ? 43 : $subcategory.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $errorMsgPrefix = this.getErrorMsgPrefix();
        result = result * 59 + ($errorMsgPrefix == null ? 43 : $errorMsgPrefix.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        String $targetSchema = this.getTargetSchema();
        result = result * 59 + ($targetSchema == null ? 43 : $targetSchema.hashCode());
        String $targetEnable = this.getTargetEnable();
        result = result * 59 + ($targetEnable == null ? 43 : $targetEnable.hashCode());
        String $targetRequired = this.getTargetRequired();
        result = result * 59 + ($targetRequired == null ? 43 : $targetRequired.hashCode());
        String $targetPlaceholder = this.getTargetPlaceholder();
        result = result * 59 + ($targetPlaceholder == null ? 43 : $targetPlaceholder.hashCode());
        String $targetHidden = this.getTargetHidden();
        result = result * 59 + ($targetHidden == null ? 43 : $targetHidden.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        List $validConditions = this.getValidConditions();
        result = result * 59 + ($validConditions == null ? 43 : ((Object)$validConditions).hashCode());
        RuleInitConfig $initConfig = this.getInitConfig();
        result = result * 59 + ($initConfig == null ? 43 : $initConfig.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $componentType = this.getComponentType();
        result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
        RuleMappingConfig $mappingConfig = this.getMappingConfig();
        result = result * 59 + ($mappingConfig == null ? 43 : $mappingConfig.hashCode());
        CommonRule $commonRule = this.getCommonRule();
        result = result * 59 + ($commonRule == null ? 43 : $commonRule.hashCode());
        Map $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : ((Object)$errorMessage).hashCode());
        String $targetText = this.getTargetText();
        result = result * 59 + ($targetText == null ? 43 : $targetText.hashCode());
        String $parameterDataType = this.getParameterDataType();
        result = result * 59 + ($parameterDataType == null ? 43 : $parameterDataType.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
        return result;
    }

    public String toString() {
        return "Rule(id=" + this.getId() + ", category=" + this.getCategory() + ", subcategory=" + this.getSubcategory() + ", path=" + this.getPath() + ", schema=" + this.getSchema() + ", parameter=" + this.getParameter() + ", type=" + this.getType() + ", errorMsgPrefix=" + this.getErrorMsgPrefix() + ", condition=" + this.getCondition() + ", conditionOperatorType=" + this.getConditionOperatorType() + ", targetSchema=" + this.getTargetSchema() + ", targetEnable=" + this.getTargetEnable() + ", targetRequired=" + this.getTargetRequired() + ", targetPlaceholder=" + this.getTargetPlaceholder() + ", targetHidden=" + this.getTargetHidden() + ", scope=" + this.getScope() + ", valid=" + this.getValid() + ", validConditions=" + this.getValidConditions() + ", initConfig=" + this.getInitConfig() + ", remark=" + this.getRemark() + ", componentType=" + this.getComponentType() + ", mappingConfig=" + this.getMappingConfig() + ", commonRule=" + this.getCommonRule() + ", errorMessage=" + this.getErrorMessage() + ", targetText=" + this.getTargetText() + ", operatorType=" + this.getOperatorType() + ", order=" + this.getOrder() + ", parameterDataType=" + this.getParameterDataType() + ", tenantId=" + this.getTenantId() + ", pageId=" + this.getPageId() + ")";
    }

    public Rule() {
    }

    public Rule(String id, String category, String subcategory, String path, String schema, String parameter, String type, String errorMsgPrefix, String condition, Integer conditionOperatorType, String targetSchema, String targetEnable, String targetRequired, String targetPlaceholder, String targetHidden, String scope, Boolean valid, List<RuleValidCondition> validConditions, RuleInitConfig initConfig, String remark, String componentType, RuleMappingConfig mappingConfig, CommonRule commonRule, Map<String, String> errorMessage, String targetText, Integer operatorType, Integer order, String parameterDataType, String tenantId, String pageId) {
        this.id = id;
        this.category = category;
        this.subcategory = subcategory;
        this.path = path;
        this.schema = schema;
        this.parameter = parameter;
        this.type = type;
        this.errorMsgPrefix = errorMsgPrefix;
        this.condition = condition;
        this.conditionOperatorType = conditionOperatorType;
        this.targetSchema = targetSchema;
        this.targetEnable = targetEnable;
        this.targetRequired = targetRequired;
        this.targetPlaceholder = targetPlaceholder;
        this.targetHidden = targetHidden;
        this.scope = scope;
        this.valid = valid;
        this.validConditions = validConditions;
        this.initConfig = initConfig;
        this.remark = remark;
        this.componentType = componentType;
        this.mappingConfig = mappingConfig;
        this.commonRule = commonRule;
        this.errorMessage = errorMessage;
        this.targetText = targetText;
        this.operatorType = operatorType;
        this.order = order;
        this.parameterDataType = parameterDataType;
        this.tenantId = tenantId;
        this.pageId = pageId;
    }
}

