/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabscroll.TabScrollContainer;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="uiBotModelBuildUibotUniversalParseStrategy")
public class UiBotModelBuildUibotUniversalParseStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildUibotUniversalParseStrategy.class);
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAtdmProxyService atdmProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        Boolean isTabs = (Boolean)rawData.get("isTabs");
        ArrayList<UiBotLayout> uiBotLayouts = new ArrayList<UiBotLayout>(1);
        UiBotModel uiBotModel = new UiBotModel(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), (String)rawData.get("dataId"), (String)rawData.get("tmTaskId"), (String)rawData.get("tmActivityId"), (ApiRawData)JsonUtil.jsonStringToObject((String)JsonUtil.javaObjectToJsonString(rawData.get("rawData")), ApiRawData.class));
        UiBotLayout tabScrollLayout = new UiBotLayout();
        tabScrollLayout.setType("TAB_SCROLL_CONTAINER");
        tabScrollLayout.setSchema("tabScroll");
        TabScrollContainer tabScrollContainer = new TabScrollContainer();
        List bodyArea = tabScrollContainer.getBodyArea();
        CustomTabContentContainer container = new CustomTabContentContainer();
        container.setContentCmptType("CUSTOM_TAB_CONTROLLER");
        if (isTabs.booleanValue()) {
            container.setData((Object)ModuleUtils.buildOneTab((UiBotModel)pcUiBotModel, (ApiRequest)apiRequest));
        } else {
            container.setData((Object)ModuleUtils.buildTabs((UiBotModel)pcUiBotModel, (ApiRequest)apiRequest, (DigiwinAtdmProxyService)this.atdmProxyService));
        }
        bodyArea.add(container);
        uiBotLayouts.add(tabScrollLayout);
        pageData.put((Object)"tabScroll", (Object)tabScrollContainer);
        uiBotModel.setPageData(pageData);
        uiBotModel.setParams(apiRequest.getParams());
        Map commonRawData = uiBotModel.getCommonRawData();
        commonRawData.put("layout", ModuleUtils.getAthenaTable((List)pcUiBotModel.getLayout()));
        commonRawData.put("pageData", pcUiBotModel.getPageData());
        commonRawData.put("executeContext", pcUiBotModel.getExecuteContext());
        commonRawData.put("rules", pcUiBotModel.getRules());
        commonRawData.put("action", ModuleUtils.getDefaultAction((UiBotModel)pcUiBotModel));
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

