/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="uiBotModelBuildApcWorkShopOnlineAreaDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineAreaDetailStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        ApiRawData rawData = apiRequest.getRawData();
        List datas = (List)rawData.get("wo_op_data");
        if (CollectionUtils.isEmpty((Collection)datas)) {
            return UiBotModel.emptyUibotModelWithCancelButton((String)locale);
        }
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    customGroup.setName(rawData.get(customGroup.getName()) + " " + this.localeService.getLanguageValue(locale, "\u533a\u57df\u6d3e\u5de5\u8d44\u8baf"));
                    CustomGroupContent content = customGroup.getContent();
                    ArrayList<UiBotLayout> customUiBotLayouts = new ArrayList<UiBotLayout>(datas.size());
                    UiBotPageData customPageData = new UiBotPageData();
                    for (UiBotLayout layout : content.getLayout()) {
                        if (!"CARD".equalsIgnoreCase(layout.getType())) continue;
                        Card card = (Card)JsonUtil.objectToJavaObject((Object)content.getPageData().get((Object)layout.getSchema()), Card.class);
                        for (Map data : datas) {
                            String id = (String)data.get(card.getTitle());
                            UiBotLayout newLayout = new UiBotLayout(id, "CARD");
                            Card dataCard = new Card();
                            dataCard.setTitle(id);
                            List cardContents = card.getContent();
                            for (CardContent cardContent : cardContents) {
                                CardContent newCardContent = new CardContent();
                                newCardContent.setLabel(this.localeService.getLanguageValue(locale, cardContent.getLabel()));
                                newCardContent.setValue((String)data.get(cardContent.getSchema()));
                                newCardContent.setSchema(cardContent.getSchema());
                                dataCard.getContent().add(newCardContent);
                            }
                            customPageData.put((Object)id, (Object)dataCard);
                            customUiBotLayouts.add(newLayout);
                        }
                    }
                    content.setLayout(customUiBotLayouts);
                    content.setPageData(customPageData);
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttons = ModuleUtils.listMapToListObject((List)((List)pageData.get((Object)schema)), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(this.localeService.getLanguageValue(locale, bottomButton.getName()));
                    }
                    pageData.put((Object)schema, (Object)buttons);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel((String)apiRequest.getLocale());
    }
}

