/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uibotModelBuildPersonalStateOnlineDetailStrategy")
public class UibotModelBuildPersonalStateOnlineDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UibotModelBuildPersonalStateOnlineDetailStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build APC Attachemnt Detail Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map woOpReportInfo = (Map)JsonUtil.objectToJavaObject(rawData.get("woOpReportInfo"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        HashMap<String, Object> queryConditionMap = new HashMap<String, Object>(2);
        HashMap woInfoMap = new HashMap(2);
        woInfoMap.put("wo_no", woOpReportInfo.get("wo_no"));
        woInfoMap.put("plot_no", woOpReportInfo.get("plot_no"));
        queryConditionMap.put("wo_no_list", Collections.singletonList(woInfoMap));
        HashMap opInfoMap = new HashMap(1);
        opInfoMap.put("op_no", woOpReportInfo.get("op_no"));
        queryConditionMap.put("op_no_list", Collections.singletonList(opInfoMap));
        queryConditionMap.put("progress_percentage_less_than", 100);
        queryConditionMap.put("progress_percentage_greater_than", 0);
        HashMap parameterMap = new HashMap(1);
        parameterMap.put("query_condition", Collections.singletonList(queryConditionMap));
        parameterMap.put("enterprise_no", woOpReportInfo.get("eoc_company_id"));
        parameterMap.put("site_no", woOpReportInfo.get("eoc_site_id"));
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("parameter", parameterMap);
        requestParamMap.put("actionId", "dispatch.report.info.get");
        List queryDataList = this.digiwinEspProxyService.getDispatchReportInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), MapUtils.getString((Map)woOpReportInfo, (Object)"eoc_company_id"), Collections.singletonList(queryConditionMap));
        stopWatch.start("Build APC Attachemnt Detail Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    if (CollectionUtils.isEmpty((Collection)queryDataList)) {
                        layout.setType("EMPTY");
                        uiBotModel.getPageData().put((Object)schema, (Object)Empty.create((String)this.localeService.getLanguageValue(locale, "\u6682\u65e0\u6570\u636e"), (boolean)true));
                        break;
                    }
                    boolean isProductGatewayE10orT100 = this.digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    Map queryData = (Map)queryDataList.get(0);
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List customGroupUiBotLayouts = customGroupContent.getLayout();
                    Iterator customGroupUiBotLayoutIterator = customGroupUiBotLayouts.iterator();
                    while (customGroupUiBotLayoutIterator.hasNext()) {
                        UiBotLayout customGroupUiBotLayout = (UiBotLayout)customGroupUiBotLayoutIterator.next();
                        String customGroupSchema = customGroupUiBotLayout.getSchema();
                        switch (customGroupUiBotLayout.getType()) {
                            case "FIELD": {
                                if (("item_feature_no".equalsIgnoreCase(customGroupSchema) || "item_feature_spec".equalsIgnoreCase(customGroupSchema)) && !isProductGatewayE10orT100) {
                                    customGroupUiBotLayoutIterator.remove();
                                    break;
                                }
                                String label = this.localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel());
                                if ("zh_TW".equalsIgnoreCase(locale)) {
                                    if ("wo_no".equals(customGroupSchema)) {
                                        label = "\u88fd\u4ee4\u55ae\u865f";
                                    }
                                    if ("remaining_qty".equals(customGroupSchema)) {
                                        label = "\u9810\u8a08\u7522\u91cf";
                                    }
                                }
                                Field field = Field.createLabelLeftValueRightField((String)label, (String)MapUtils.getString((Map)queryData, (Object)customGroupSchema));
                                customGroupContent.getPageData().put((Object)customGroupSchema, (Object)field);
                            }
                        }
                    }
                    uiBotModel.getPageData().put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale, (String)"\u5173\u95ed");
                    uiBotModel.getPageData().put((Object)schema, Collections.singletonList(submitButton));
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

