/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.model.UserCardListFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class UiBotModelBuildApcStandProductionProgressPageStrategy
implements UiBotModelBuildStrategy {
    private static final String TMACTIVITYID = "DataEntry_getlist__apc_stand_production_progress";
    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;
    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformerImpl;
    @Autowired
    private PcRuleService pcRuleService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private UserCardListFilterService userCardListFilterService;
    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && !modelTypeShow ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        this.handleUiBotModel(apiRequest, uiBotModel);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private void handleUiBotModel(ApiRequest apiRequest, UiBotModel uiBotModel) {
        uiBotModel.setPageData(this.buildPageData(apiRequest));
        UiBotQueryButton queryButton = this.buildQueryButton();
        PcUiBotExecuteContext executeContext = this.buildPcUiBotExecuteContext(apiRequest);
        this.bulidRanderData(apiRequest, executeContext, uiBotModel, queryButton);
        this.buildRule(executeContext, uiBotModel);
        uiBotModel.setRawUiBotPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength((String)uiBotModel.getPageBackgroudColor()) ? uiBotModel.getPageBackgroudColor() : BackgroundColorEnum.APP_MAIN_GREY.getValue());
    }

    private UiBotPageData buildPageData(ApiRequest apiRequest) {
        HashMap<String, String> queryCondition = new HashMap<String, String>();
        queryCondition.put("task_display_field", this.buildTaskDisplayField(apiRequest));
        UserCardListFilter userCardListFilter = this.userCardListFilterService.getUserCardListFilterByTmActivityIdAndUserId(new UserCardListFilterQueryDTO().setTenantId(apiRequest.getTenantId()).setUserId(apiRequest.getUserId()).setTmActivityId(TMACTIVITYID));
        Optional.ofNullable(userCardListFilter).map(UserCardListFilter::getData).filter(StringUtils::hasLength).map(data -> (Map)JsonUtil.jsonStringToObject((String)data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).ifPresent(queryCondition::putAll);
        HashMap<String, ArrayList> parameter = new HashMap<String, ArrayList>(1);
        parameter.put("query_condition", Lists.newArrayList((Object[])new Map[]{queryCondition}));
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create((String)"layout.report.statistics.area.info.get", parameter, null, null);
        try {
            DigiwinAthenaApiResponse athenaApiResponse = this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)request), apiRequest.getTenantId());
            return Optional.ofNullable(athenaApiResponse).map(DigiwinAthenaApiResponse::getResponse).map(UiBotPageData::new).orElseGet(UiBotPageData::new);
        }
        catch (Exception e) {
            return new UiBotPageData();
        }
    }

    private String buildTaskDisplayField(ApiRequest apiRequest) {
        String taskDisplayField = "1";
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("variableId", (Object)"taskNameField");
        jsonArray.add((Object)jsonObject);
        List mechanismVariableList = this.digiwinKnowledgeMapsProxyService.getMechanismVariableList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), jsonArray);
        if (!CollectionUtils.isEmpty((Collection)mechanismVariableList)) {
            for (Map mechanismVariable : mechanismVariableList) {
                if (!"taskNameField".equals(mechanismVariable.get("variableId"))) continue;
                taskDisplayField = StringUtil.valueOf(mechanismVariable.get("result"));
                break;
            }
        }
        return taskDisplayField;
    }

    public UiBotQueryButton buildQueryButton() {
        MobileDesignerConfig config = this.mobileDesignerConfigRepository.selectOneDsl(TMACTIVITYID, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        List uiBotPageLayoutList = Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> {
            MobileRenderDataUtil.multilingualProcessing((Map)r, (String)AppRequestContext.getContextEntity().getLocale());
            return r;
        }).map(r -> r.getJSONObject("pageDslMobile")).map(r -> r.getJSONArray("layout").getJSONObject(0)).map(r -> r.getJSONObject("data")).map(r -> r.get((Object)"data")).map(r -> (List)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElseGet(ArrayList::new);
        uiBotPageLayoutList.forEach(uiBotPageLayout -> uiBotPageLayout.convert(uiBotPageLayout.getComponentType()));
        UiBotQueryButton queryButton = new UiBotQueryButton();
        queryButton.setPageLayout(uiBotPageLayoutList);
        List hooks = Optional.ofNullable(config).map(MobileDesignerConfig::getData).map(r -> r.getJSONObject("pageDslMobile")).map(r -> (List)JsonUtil.objectToJavaObject((Object)r.get((Object)"hooks"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).orElseGet(ArrayList::new);
        queryButton.setHooks(hooks);
        HashMap<String, String> dataSourceSet = new HashMap<String, String>();
        dataSourceSet.put("mainDatasource", "layout_data");
        queryButton.setDataSourceSet(dataSourceSet);
        return queryButton;
    }

    private PcUiBotExecuteContext buildPcUiBotExecuteContext(ApiRequest apiRequest) {
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create((String)apiRequest.getLocale(), (String)apiRequest.getTenantId(), (String)TMACTIVITYID);
        executeContext.appendPageInfo("task-detail-mobile", null, TMACTIVITYID, "performer", Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser().setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId()).setToken(apiRequest.getIamUserToken()));
        return executeContext;
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, UiBotQueryButton queryButton) {
        ComponentContext cmptContext = (ComponentContext)JsonUtil.objectToJavaObject((Object)apiRequest, ComponentContext.class);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.APC_STAND_PRODUCTION_PROGRESS.name());
        this.uiBotDesignerRenderService.buildMainPageHooksByQueryButton(queryButton, cmptContext, uiBotModel, null);
        List bodyCmptList = this.businessProcessPerformerImpl.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
        if (CollectionUtils.isEmpty((Collection)bodyCmptList)) {
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType((List)bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer singleListContainer = new SingleListContainer();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper((BaseMobileComponent)singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }
            List bottomCmptList = this.businessProcessPerformerImpl.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
            if (!CollectionUtils.isEmpty((Collection)bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }

    private void buildRule(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel) {
        List rules = this.pcRuleService.buildRuleOfLocal(executeContext.getTmActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        if (!CollectionUtils.isEmpty((Collection)rules)) {
            uiBotModel.setRules(rules);
        }
    }

    public static String getTmActivityId() {
        return TMACTIVITYID;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

