/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.ksc;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccStringUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildKscMaterialStrategy")
public class UiBotModelBuildKscMaterialStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildKscMaterialStrategy.class);
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildKscMaterial");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String[] fieldArray;
        UiBotModel uiBotModel = pageSetting.getPageModel();
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        JSONObject productItem = apiRequest.getRawData().getJSONObject("productItem");
        JSONObject taskInfo = apiRequest.getRawData().getJSONObject("taskInfo");
        String purchaseNo = productItem.getString("purchase_no");
        String projectNo = productItem.getString("project_no");
        String taskNo = productItem.getString("task_no");
        String itemNo = productItem.getString("item_no");
        String itemNameSpec = productItem.getString("item_name_spec");
        String eocCompanyId = taskInfo.getString("eoc_company_id");
        String taskCategory = taskInfo.getString("task_category");
        for (String field : fieldArray = PccStringUtil.getFieldsByTaskCategory((String)taskCategory, (boolean)true)) {
            if (!productItem.containsKey((Object)field)) continue;
            Field itemContentComponent = null;
            if ("attachment".equals(field)) {
                JSONObject rawAttachmentData = productItem.getJSONObject(field);
                if (CollectionUtils.isEmpty((Collection)rawAttachmentData.getJSONArray("data"))) continue;
                UiBotTableColumn manualCreatedColumn = new UiBotTableColumn();
                manualCreatedColumn.setSchema(field);
                manualCreatedColumn.setHeaderName(LocaleUtil.getMobileTextByKey((String)locale, (String)field));
                manualCreatedColumn.doSetCanNotEdit();
                itemContentComponent = Attachment.create(Attachment.class, (String)locale, (UiBotTableColumn)manualCreatedColumn, (Map)productItem);
            } else {
                String valueStr = productItem.getString(field);
                if ((valueStr = PccStringUtil.getValueShowText((String)locale, (String)taskCategory, (String)field, (String)valueStr)).trim().isEmpty()) continue;
                itemContentComponent = Field.create((String)LocaleUtil.getMobileTextByKey((String)locale, (String)field), (String)valueStr, (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT, (Boolean)false);
                UiBotLayout fieldLayout = new UiBotLayout();
                fieldLayout.setType("FIELD");
                fieldLayout.setSchema(field);
                uiBotModel.addLayout(fieldLayout);
            }
            uiBotModel.getPageData().put((Object)field, (Object)itemContentComponent);
        }
        List<String> attachmentFields = Arrays.asList("delivery", "delivery_attachment");
        for (String attachmentField : attachmentFields) {
            String label = this.localeService.getLanguageValue(locale, Objects.equals(attachmentField, "delivery") ? "\u4ea4\u4ed8\u7269" : "\u9644\u4ef6");
            UiBotAttachment uiBotAttachment = (UiBotAttachment)JsonUtil.objectToJavaObject((Object)productItem.get((Object)attachmentField), UiBotAttachment.class);
            if (ObjectUtils.isEmpty((Object)uiBotAttachment) || CollectionUtils.isEmpty((Collection)uiBotAttachment.getData())) {
                UiBotLayout fieldLayout = new UiBotLayout();
                fieldLayout.setType("FIELD");
                fieldLayout.setSchema(attachmentField);
                uiBotModel.addLayout(fieldLayout);
                Field field = Field.create((String)label, (String)"-", (FieldAlignmentTypeEnum)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT, (Boolean)false);
                uiBotModel.getPageData().put((Object)attachmentField, (Object)field);
                continue;
            }
            Attachment attachment = new Attachment();
            attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
                AttachmentFile attachmentFile = AttachmentFile.create((String)locale, (UiBotAttachmentData)uibotAttachData);
                if (StringUtils.hasLength((String)uibotAttachData.getCreateDate())) {
                    attachmentFile.setUploadTime(sdf.format(Long.valueOf(uibotAttachData.getCreateDate())));
                }
                attachment.getFileList().add(attachmentFile);
            }
            attachment.setTitle(label);
            AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            rawDataDigiwinAthena.setBuckets("SCH");
            rawDataDigiwinAthena.setDisableAam(Boolean.valueOf(true));
            attachment.setRawData((AttachmentRawData)rawDataDigiwinAthena);
            UiBotLayout fieldLayout = new UiBotLayout();
            fieldLayout.setType("ATTACHMENT");
            fieldLayout.setSchema(attachmentField);
            uiBotModel.addLayout(fieldLayout);
            uiBotModel.getPageData().put((Object)attachmentField, (Object)attachment);
        }
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getRight() != null) {
            LeftHeader header = uiBotModel.getSlip().getSlipConfig().getRight().getHeader();
            header.getSubTitle().setContent(taskInfo.getString("task_name"));
            if (uiBotModel.getSlip().getSlipConfig().getRight().getBody() != null) {
                Map params = uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().getParams();
                params.put("purchase_no", purchaseNo);
                params.put("item_no", itemNo);
                params.put("item_name_spec", itemNameSpec);
                params.put("eoc_company_id", eocCompanyId);
                params.put("item_type", taskCategory);
                params.put("project_no", projectNo);
                params.put("task_no", taskNo);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UiBotModel uiBotModel = null;
        JSONObject taskInfo = apiRequest.getRawData().getJSONObject("taskInfo");
        String taskCategory = taskInfo.getString("task_category");
        String data = "PO".equalsIgnoreCase(taskCategory) ? FileUtil.readText((String)"static/with_material_detail_.json") : FileUtil.readText((String)"static/without_material_detail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = (UiBotModel)JsonUtil.jsonStringToObject((String)data, UiBotModel.class);
        }
        return uiBotModel;
    }
}

