/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer;

import com.digiwin.mobile.mobileuibot.designer.uibot.taganalyzer.DesignerTagAnalyzer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="knowledgeMapsTagAnalyzerFactory")
public class DesignerTagAnalyzerFactory
implements InitializingBean,
ApplicationContextAware {
    private static final Map<String, DesignerTagAnalyzer> analyzerMap = new HashMap();
    private ApplicationContext appContext;
    private static final String TAG_CODE_SPLITTER = "__";

    public DesignerTagAnalyzer get(String tagCode) {
        String[] splitTagCode = tagCode.split(TAG_CODE_SPLITTER);
        if (splitTagCode.length != 3) {
            return null;
        }
        String tagDesc = splitTagCode[2];
        String targetAnalyzerKey = "";
        for (String analyzerKey : analyzerMap.keySet()) {
            if (!tagDesc.contains(analyzerKey)) continue;
            targetAnalyzerKey = analyzerKey;
            break;
        }
        return (DesignerTagAnalyzer)analyzerMap.get(targetAnalyzerKey);
    }

    public void afterPropertiesSet() throws Exception {
        this.appContext.getBeansOfType(DesignerTagAnalyzer.class).values().forEach(strategy -> analyzerMap.put(strategy.getTagCode(), strategy));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    public Map<String, DesignerTagAnalyzer> getAnalyzerMap() {
        return analyzerMap;
    }
}

