/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.im;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.im.IMService;
import com.digiwin.mobile.mobileuibot.im.addmembers.IMAddMembersRequest;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.AppExpireNoticeRecord;
import com.digiwin.mobile.mobileuibot.mysql.service.AppExpireNoticeRecordService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.ExpireApplicationNoticeDetail;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;
import com.digiwin.mobile.mobileuibot.proxy.im.service.DigiwinImProxyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="imService")
public class IMServiceImpl
implements IMService {
    private static final String YUN_XIN = "1";
    private static final String AGORA = "2";
    private static final String OPENFIRE = "3";
    private static final Logger logger = LoggerFactory.getLogger(IMServiceImpl.class);
    @Autowired
    private DigiwinImProxyService digiwinImProxyService;
    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private AppExpireNoticeRecordService appExpireNoticeRecordService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private SysEnvConfig sysEnvConfig;

    public IMUser getIMUserByToken(String iamUserToken, String tenantId) {
        IMUser imUser = this.digiwinImProxyService.userLoginAndCreate(iamUserToken, tenantId);
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        if (Objects.equals(this.sysEnvConfig.getImTypeJudgeLocalUrl(), athenaMuiUrl)) {
            imUser.setImType(OPENFIRE);
        } else if (Objects.equals("https://athena-paas.digiwincloud.com.cn", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("paas_11813");
            imUser.setEnvName("ania_paas");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("test_cnhw_4931");
            imUser.setEnvName("ania_hw_test");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("prod_cnhw_28169");
            imUser.setEnvName("ania_hw");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("test_azure_3301");
            imUser.setEnvName("ania_test_tw");
            imUser.setImType(AGORA);
        } else if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("prod_tw_38916");
            imUser.setEnvName("ania_azure");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-hz-test.digiwincloud.com.cn", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("paas_11813");
            imUser.setEnvName("semc_paas");
            imUser.setImType(YUN_XIN);
        } else if (Objects.equals("https://athena-pressure.digiwincloud.com.cn", athenaMuiUrl)) {
            imUser.setAiAssistantAccId("paas_11813");
            imUser.setEnvName("ania_hw_pressure");
            imUser.setImType(YUN_XIN);
        } else {
            imUser.setAiAssistantAccId("");
            imUser.setEnvName("");
        }
        return imUser;
    }

    public IMUser getAndCreateIMUserByToken(String iamUserToken, String tenantId) {
        return this.digiwinImProxyService.userGetAndCreate(iamUserToken, tenantId, null);
    }

    public DigiwinAthenaApiResponse<String> teamCreate(String iamUserToken, IMTeam imTeam, String tenantId) {
        EocPersonInfo eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(imTeam.getOwner(), iamUserToken, 2);
        if (eocPersonInfo != null && StringUtils.hasLength((String)eocPersonInfo.getEocId())) {
            imTeam.setOwner(eocPersonInfo.getEocId());
        }
        List<String> eocIds = new ArrayList(imTeam.getMemberIds().size());
        for (String userId : imTeam.getMemberIds()) {
            EocPersonInfo eocPersonInfo1 = this.digiwinEocProxyService.getEocPersonInfo(userId, iamUserToken, 2);
            if (eocPersonInfo1 == null || !StringUtils.hasLength((String)eocPersonInfo1.getEocId())) continue;
            eocIds.add(eocPersonInfo1.getEocId());
        }
        if (eocIds == null || eocIds.size() < imTeam.getMemberIds().size()) {
            eocIds = imTeam.getMemberIds();
        }
        imTeam.setMemberIds(eocIds);
        return this.digiwinImProxyService.teamCreate(iamUserToken, imTeam, tenantId);
    }

    public List<TeamMember> getTeamMembers(String iamUserToken, String teamId, String tenantId) {
        return this.digiwinImProxyService.getTeamMembers(iamUserToken, teamId, tenantId);
    }

    public List<TeamMember> setAccId(List<TeamMember> newTeamMembers, String iamUserToken) {
        for (TeamMember teamMember : newTeamMembers) {
            EocPersonInfo eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(teamMember.getEocId(), iamUserToken, 1);
            teamMember.setAccId(eocPersonInfo.getAccId());
        }
        return newTeamMembers;
    }

    public DigiwinAthenaApiResponse<String> teamAddMembers(IMAddMembersRequest imAddMembersRequest) {
        return this.digiwinImProxyService.teamAddMembers(imAddMembersRequest.getIamUserToken(), imAddMembersRequest.getTeamId(), imAddMembersRequest.getMemberIds(), imAddMembersRequest.getBizIdFromServerCustomInfo(), imAddMembersRequest.getIMTeamTypeFromServerCustomInfo(), imAddMembersRequest.getTenantId());
    }

    public ExpireApplicationNoticeDetail getExpireApplicationNoticeInfo(String userId, String iamUserToken, String tenantId, String locale) {
        ExpireApplicationNoticeDetail expireApplicationNoticeDetail = new ExpireApplicationNoticeDetail();
        try {
            List expireApplicationNoticeInfoList = this.digiwinAimProxyService.getExpireApplicationNoticeInfo(iamUserToken, tenantId);
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("userId", userId);
            param.put("tenantId", tenantId);
            if (CollectionUtils.isEmpty((Collection)expireApplicationNoticeInfoList)) {
                this.appExpireNoticeRecordService.deleteData(param);
                expireApplicationNoticeDetail.setContentList(Collections.emptyList());
                return expireApplicationNoticeDetail;
            }
            List appExpireNoticeRecordList = this.appExpireNoticeRecordService.getInfo(param);
            Set oldNoticeGid = appExpireNoticeRecordList.stream().map(e -> e.getNoticeGid()).collect(Collectors.toSet());
            Set newNoticeGid = expireApplicationNoticeInfoList.stream().map(e -> e.getGid()).collect(Collectors.toSet());
            List newNoticeList = expireApplicationNoticeInfoList.stream().filter(e -> !oldNoticeGid.contains(e.getGid())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(newNoticeList)) {
                expireApplicationNoticeDetail.setContentList(Collections.emptyList());
                return expireApplicationNoticeDetail;
            }
            List appExpireNoticeRecordAddInfoList = newNoticeList.stream().map(e -> {
                AppExpireNoticeRecord appExpireNoticeRecord = new AppExpireNoticeRecord();
                appExpireNoticeRecord.setId(UUIDUtil.getLongUuid());
                appExpireNoticeRecord.setUserId(userId);
                appExpireNoticeRecord.setTenantId(tenantId);
                appExpireNoticeRecord.setNoticeGid(e.getGid());
                appExpireNoticeRecord.setNoticeMsg(e.getContent().getMsg());
                appExpireNoticeRecord.setNoticeTime(new Date());
                appExpireNoticeRecord.setCreateTime(new Date());
                return appExpireNoticeRecord;
            }).collect(Collectors.toList());
            this.appExpireNoticeRecordService.batchInsertData(appExpireNoticeRecordAddInfoList);
            List inVaLidOldNoticeGid = oldNoticeGid.stream().filter(e -> !newNoticeGid.contains(e)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(inVaLidOldNoticeGid)) {
                HashMap<String, Object> deleteParam = new HashMap<String, Object>(3);
                deleteParam.put("userId", userId);
                deleteParam.put("tenantId", tenantId);
                deleteParam.put("gids", inVaLidOldNoticeGid);
                this.appExpireNoticeRecordService.deleteDataByGid(deleteParam);
            }
            List contentList = newNoticeList.stream().map(e -> this.localeService.getLanguageValue(locale, e.getContent().getMsg())).collect(Collectors.toList());
            expireApplicationNoticeDetail.setContentList(contentList);
            expireApplicationNoticeDetail.setDisplayDuration(Long.valueOf(5L));
        }
        catch (Exception e2) {
            expireApplicationNoticeDetail.setContentList(Collections.emptyList());
            logger.error("get app expire notice error: ", (Throwable)e2);
        }
        return expireApplicationNoticeDetail;
    }
}

