/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.information;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.information.InformationService;
import com.digiwin.mobile.mobileuibot.information.request.InformationBoardVO;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.InformationBoard;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/information"})
public class InformationController {
    @Autowired
    private InformationService informationService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/board/add"})
    public ApiResponse<InformationBoardVO> boardAdd(@RequestBody InformationBoardVO vo) {
        return ApiResponse.buildOK().setData((Object)InformationBoardVO.convert((InformationBoard)this.informationService.boardAdd(vo)));
    }

    @PostMapping(value={"/board/update"})
    public ApiResponse<InformationBoardVO> boardUpdate(@RequestBody InformationBoardVO vo) {
        InformationBoard board = this.informationService.selectByBoardId(vo.getBoardId());
        if (null == board) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(vo.getLocale(), "\u770b\u677f\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK().setData((Object)InformationBoardVO.convert((InformationBoard)this.informationService.boardUpdate(vo)));
    }

    @PostMapping(value={"/board/delete"})
    public ApiResponse<InformationBoardVO> boardDelete(@RequestBody InformationBoardVO vo) {
        InformationBoard board = this.informationService.selectByBoardId(vo.getBoardId());
        if (null == board) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(vo.getLocale(), "\u770b\u677f\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        this.informationService.boardDelete(vo.getBoardId());
        return ApiResponse.buildOK().setData((Object)InformationBoardVO.convert((InformationBoard)board));
    }

    @PostMapping(value={"/board/select"})
    public ApiResponse<InformationBoardVO> boardSelect(@RequestBody InformationBoardVO vo) {
        InformationBoard board = this.informationService.selectByBoardId(vo.getBoardId());
        if (null == board) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(vo.getLocale(), "\u770b\u677f\u8bb0\u5f55\u4e0d\u5b58\u5728"));
        }
        return ApiResponse.buildOK().setData((Object)InformationBoardVO.convert((InformationBoard)board));
    }

    @PostMapping(value={"/board/list"})
    public ApiResponse<List<InformationBoardVO>> boardList(@RequestBody InformationBoardVO vo) {
        List boardList = this.informationService.boardList(vo.getTenantId(), vo.getUserId());
        ArrayList boardVOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)boardList)) {
            boardList.forEach(board -> boardVOList.add(InformationBoardVO.convert((InformationBoard)board)));
        }
        return ApiResponse.buildOK().setData(boardVOList);
    }

    @PostMapping(value={"/report/list"})
    public ApiResponse<List<DigiwinAtmcTmDataReport>> reportList(@RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.informationService.reportList(apiRequest));
    }
}

