/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.login;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtils;
import com.digiwin.mobile.mobileuibot.common.crypto.rsa.RSAUtils;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRoleIdEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.login.LoginService;
import com.digiwin.mobile.mobileuibot.model.db1.Mock;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.IamAuth;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.DigiwinEocAddUpdateEmp;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.DigiwinEocAddUpdateEmpDept;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTokenRefreshTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAddJoinTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="loginService")
public class LoginServiceImpl
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Resource
    private DigiwinIamProxyService digiwinIamProxyService;
    @Resource
    private DigiwinCacProxyService digiwinCacProxyService;
    @Resource
    private DigiwinEocProxyService digiwinEocProxyService;
    @Resource
    private LocaleService localeService;

    public void handleUserByVerificationCodeInExperience(String mobilePhone, String verificationCode, String locale, String clientAgent, String expRoleId, DigiwhaleLoginResponse loginResponse, Mock mock, String iamDeviceId) throws Exception {
        DigiwinEocAddUpdateEmp empInfo;
        boolean addResult;
        String userId;
        String iamUserToken;
        IamAuth iamAuth = loginResponse.getIamAuth();
        if (Objects.isNull(iamAuth)) {
            iamAuth = new IamAuth();
            iamAuth.setSid(loginResponse.getSid());
            iamAuth.setUserId(loginResponse.getUserId());
            iamAuth.setUserName(loginResponse.getUserName());
            loginResponse.setIamAuth(iamAuth);
            iamUserToken = loginResponse.getToken();
            userId = loginResponse.getUserId();
        } else {
            iamUserToken = iamAuth.getToken();
            userId = iamAuth.getUserId();
        }
        boolean setDefaultLanguageResult = this.digiwinIamProxyService.setUserDefaultAcceptLanguage(iamUserToken, Long.valueOf(0L), iamAuth.getSid(), locale);
        DigiwinIamUserAddJoinTenant joinTenantResult = this.addUserToTargetTenantInExperience(iamUserToken, expRoleId, mock);
        DigiwinIamTokenRefreshTenant refreshTenantResult = this.digiwinIamProxyService.tokenRefreshTenant(joinTenantResult.getTenantId(), "", iamUserToken);
        if (null != refreshTenantResult.getSuccess() && !refreshTenantResult.getSuccess().booleanValue()) {
            this.buildError(loginResponse, this.localeService.getLanguageValue(locale, "\u8d26\u53f7\u5df2\u88ab\u505c\u7528\uff0c\u767b\u5f55\u5931\u8d25\u3002" + refreshTenantResult.getErrorMessage()));
            return;
        }
        iamAuth.setTenantSid(refreshTenantResult.getTenantSid());
        iamAuth.setTenantId(refreshTenantResult.getTenantId());
        iamAuth.setTenantName(refreshTenantResult.getTenantName());
        iamAuth.setToken(refreshTenantResult.getUserToken());
        iamUserToken = iamAuth.getToken();
        loginResponse.setAccessToken(iamAuth.getToken());
        loginResponse.setTenantId(refreshTenantResult.getTenantId());
        loginResponse.setTenantSid(refreshTenantResult.getTenantSid());
        loginResponse.setTenantName(refreshTenantResult.getTenantName());
        if (!this.digiwinIamProxyService.checkUserInTenant(userId, iamUserToken).booleanValue()) {
            this.buildError(loginResponse, this.localeService.getLanguageValue(locale, "\u672a\u80fd\u52a0\u5165\u79df\u6237\uff0c\u8bf7\u68c0\u67e5\u79df\u6237\u6216\u7528\u6237\u662f\u5426\u6709\u6548"));
            return;
        }
        boolean countIdAddResult = this.addUserToCountingInExperience(joinTenantResult.getTenantId(), userId, expRoleId, mock);
        if (!countIdAddResult) {
            this.buildError(loginResponse, this.localeService.getLanguageValue(locale, "\u672a\u6210\u529f\u5b8c\u6210\u9ed8\u8ba4\u6388\u6743\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u5546\u54c1\u3001\u79df\u6237\u6216\u7528\u6237\u662f\u5426\u6709\u6548"));
            return;
        }
        boolean setDefaultTenantResult = this.digiwinIamProxyService.setUserDefaultTenant(iamUserToken, joinTenantResult.getTenantId(), "");
        EocPerson eocPersonInfo = this.digiwinEocProxyService.getEocInfo(mobilePhone, iamUserToken);
        if (Objects.isNull(eocPersonInfo) && !(addResult = this.digiwinEocProxyService.addOrUpdateEocEmp(locale, userId, iamUserToken, empInfo = this.createDigiwinEocAddUpdateEmpInExperience(locale, expRoleId, mobilePhone, iamAuth, mock)))) {
            this.buildError(loginResponse, this.localeService.getLanguageValue(locale, "\u672a\u6210\u529f\u7ed1\u5b9a\u79df\u6237\u5458\u5de5\uff0c\u8bf7\u68c0\u67e5\u79df\u6237\u6216\u7528\u6237\u662f\u5426\u6709\u6548"));
            return;
        }
        DigiwhaleLoginResponse superadminLoginResponse = this.loginWithSuperAdminInExperience(locale, clientAgent, expRoleId, joinTenantResult.getTenantId(), mock, iamDeviceId);
        if (null == superadminLoginResponse) {
            this.buildError(loginResponse, this.localeService.getLanguageValue(locale, "\u672a\u6210\u529f\u83b7\u53d6\u7cfb\u7edf\u7ba1\u7406\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5\u89d2\u8272\u3001\u79df\u6237\u6216\u7528\u6237\u662f\u5426\u6709\u6548"));
            return;
        }
        boolean roleAddResult = false;
        if (superadminLoginResponse != null) {
            roleAddResult = this.digiwinIamProxyService.associationRoleAddUsers(superadminLoginResponse.getIamAuth().getToken(), this.getRoleId(joinTenantResult.getTenantId()), Collections.singletonList(userId));
        }
        if (!roleAddResult) {
            this.buildError(loginResponse, this.localeService.getLanguageValue(locale, "\u672a\u6210\u529f\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5\u89d2\u8272\u3001\u79df\u6237\u6216\u7528\u6237\u662f\u5426\u6709\u6548"));
            return;
        }
    }

    private String getRoleId(String tenantId) {
        String userRoleId = "superadmin";
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl) && "AthenaNjTest".equals(tenantId)) {
            userRoleId = "TestRole";
        }
        if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl) && "DigiwinGptDemo".equals(tenantId)) {
            userRoleId = "DigiwinGptDemoRole";
        }
        return userRoleId;
    }

    @NotNull
    private static List<DigiwinEocAddUpdateEmpDept> getDigiwinEocAddUpdateEmpDeptsPro() {
        ArrayList<DigiwinEocAddUpdateEmpDept> deptList = new ArrayList<DigiwinEocAddUpdateEmpDept>();
        DigiwinEocAddUpdateEmpDept dept = new DigiwinEocAddUpdateEmpDept();
        dept.setSid(926947488722944L);
        dept.setId("A00000");
        dept.setName("\u7e3d\u90e8(\u865b\u64ec\u90e8\u9580)");
        dept.setMainDept(Boolean.valueOf(true));
        dept.setCorpId("DigiwinGptDemo");
        dept.setCorpName("GPT\u751f\u6210\u5f0f\u95ee\u6570");
        dept.setLevelSid(1926947487748096L);
        dept.setDirectorId("");
        dept.setDirectorName("");
        deptList.add(dept);
        return deptList;
    }

    @NotNull
    private static List<DigiwinEocAddUpdateEmpDept> getDigiwinEocAddUpdateEmpDeptsTest() {
        ArrayList<DigiwinEocAddUpdateEmpDept> deptList = new ArrayList<DigiwinEocAddUpdateEmpDept>();
        DigiwinEocAddUpdateEmpDept dept = new DigiwinEocAddUpdateEmpDept();
        dept.setSid(1118086959779840L);
        dept.setId("test01");
        dept.setName("test01");
        dept.setMainDept(Boolean.valueOf(true));
        dept.setCorpId("nj01");
        dept.setCorpName("nj01");
        dept.setLevelSid(1113748446408704L);
        dept.setDirectorId("");
        dept.setDirectorName("");
        deptList.add(dept);
        return deptList;
    }

    private DigiwhaleLoginResponse buildError(DigiwhaleLoginResponse loginResponse, String errorMessage) {
        loginResponse.setError(HttpStatus.UNAUTHORIZED.value() + "");
        loginResponse.setErrorDescription(errorMessage);
        return loginResponse;
    }

    private DigiwinIamUserAddJoinTenant addUserToTargetTenantInExperience(String iamUserToken, String expRoleId, Mock mock) {
        String tenantId = "";
        if (mock != null) {
            tenantId = mock.getNanaTenantId();
        } else {
            String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
            if (Objects.equals("https://athena-paas.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                }
            } else if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "AthenaNjTest";
                }
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    tenantId = "erp2nanatrmdemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                    tenantId = "0000011111";
                }
            } else if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                }
            } else if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    tenantId = "erp2nanatrmdemo";
                }
            } else if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "agiledemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    tenantId = "erp2nanatrmdemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                    tenantId = "athena";
                }
            }
        }
        DigiwinIamUserAddJoinTenant joinTenantResult = this.digiwinIamProxyService.userAddJoinTenant(iamUserToken, tenantId, "", "", "");
        joinTenantResult.setTenantId(tenantId);
        return joinTenantResult;
    }

    private DigiwinEocAddUpdateEmp createDigiwinEocAddUpdateEmpInExperience(String locale, String expRoleId, String mobilePhone, IamAuth iamAuth, Mock mock) {
        DigiwinEocAddUpdateEmp digiwinEocAddUpdateEmp = new DigiwinEocAddUpdateEmp();
        String replacerId = "";
        if (mock != null) {
            replacerId = "";
        } else {
            String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
            if (!Objects.equals("https://athena-paas.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
                    if ("AthenaNjTest".equals(iamAuth.getTenantId())) {
                        digiwinEocAddUpdateEmp.setDepts(LoginServiceImpl.getDigiwinEocAddUpdateEmpDeptsTest());
                    }
                } else if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
                    if ("DigiwinGptDemo".equals(iamAuth.getTenantId())) {
                        digiwinEocAddUpdateEmp.setDepts(LoginServiceImpl.getDigiwinEocAddUpdateEmpDeptsPro());
                    }
                } else if (!Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                    if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
                        if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                            replacerId = "";
                        }
                    } else if (Objects.equals("https://athena-hz-test.digiwincloud.com.cn", athenaMuiUrl) && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                        replacerId = "pur001";
                    }
                }
            }
        }
        if (mobilePhone.contains("@")) {
            int atIndex = mobilePhone.indexOf("@");
            mobilePhone = mobilePhone.substring(0, atIndex);
        }
        return digiwinEocAddUpdateEmp.setId(mobilePhone).setName(iamAuth.getUserName()).setUserId(iamAuth.getUserId()).setUserName(iamAuth.getUserName()).setStatus(Boolean.valueOf(true)).setReplacerId(replacerId);
    }

    private Boolean addUserToCountingInExperience(String tenantId, String userId, String expRoleId, Mock mock) {
        if (mock != null) {
            boolean result = true;
            String code = mock.getNanaAuthorizationCode();
            if (StringUtils.hasLength((String)code)) {
                String[] split;
                for (String s : split = code.split(",")) {
                    result = result && this.digiwinCacProxyService.countingUserAdd(s, tenantId, userId) != false;
                }
            }
            return result;
        }
        String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
        if (expRoleId.trim().equals(ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
            if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                return true;
            }
            if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
                boolean dmpCountingAddResult = this.digiwinCacProxyService.countingUserAdd("dmp", tenantId, userId);
                boolean dcdpResult = this.digiwinCacProxyService.countingUserAdd("dcdp", tenantId, userId);
                boolean agileDataCountingAddResult = this.digiwinCacProxyService.countingUserAdd("Mfe0920564AT", tenantId, userId);
                return dmpCountingAddResult && dcdpResult && agileDataCountingAddResult;
            }
            if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
                boolean asadaCountingAddResult = this.digiwinCacProxyService.countingUserAdd("asada", tenantId, userId);
                boolean dcdpCountingAddResult = this.digiwinCacProxyService.countingUserAdd("dcdp", tenantId, userId);
                boolean dccCountingAddResult = this.digiwinCacProxyService.countingUserAdd("dcc", tenantId, userId);
                boolean cxoAssistantCountingAddResult = this.digiwinCacProxyService.countingUserAdd("A20240412173606-bmdDev", tenantId, userId);
                boolean trafficPackageCountingAddResult = this.digiwinCacProxyService.countingUserAdd("1216700ALL000001", tenantId, userId);
                boolean kcfCountingAddResult = this.digiwinCacProxyService.countingUserAdd("KCF", tenantId, userId);
                boolean kmoCountingAddResult = this.digiwinCacProxyService.countingUserAdd("KMO", tenantId, userId);
                boolean kbsCountingAddResult = this.digiwinCacProxyService.countingUserAdd("KBS", tenantId, userId);
                return asadaCountingAddResult && dcdpCountingAddResult && dccCountingAddResult && cxoAssistantCountingAddResult && trafficPackageCountingAddResult && kcfCountingAddResult && kmoCountingAddResult && kbsCountingAddResult;
            }
            if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
                boolean dmpCountingAddResult = this.digiwinCacProxyService.countingUserAdd("dmp", tenantId, userId);
                boolean dcdpResult = this.digiwinCacProxyService.countingUserAdd("dcdp", tenantId, userId);
                boolean agileDataCountingAddResult = this.digiwinCacProxyService.countingUserAdd("Ma7fab895fAT", tenantId, userId);
                return dmpCountingAddResult && dcdpResult && agileDataCountingAddResult;
            }
        } else {
            if (expRoleId.trim().equals(ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                    return true;
                }
                boolean trmnanaCountingAddResult = this.digiwinCacProxyService.countingUserAdd("trmnana", tenantId, userId);
                boolean asaCountingAddResult = this.digiwinCacProxyService.countingUserAdd("ASA", tenantId, userId);
                return trmnanaCountingAddResult && asaCountingAddResult;
            }
            if (expRoleId.trim().equals(ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                    return true;
                }
                boolean trmnanaCountingAddResult = this.digiwinCacProxyService.countingUserAdd("asaaa", tenantId, userId);
                boolean asaCountingAddResult = this.digiwinCacProxyService.countingUserAdd("ASA", tenantId, userId);
                return trmnanaCountingAddResult && asaCountingAddResult;
            }
        }
        return false;
    }

    private String getEncryptPublicKey() throws Exception {
        String serverPublicKey = this.digiwinIamProxyService.doGetPublicKey();
        if (io.micrometer.core.instrument.util.StringUtils.isEmpty((String)serverPublicKey)) {
            log.error("\u672a\u62ff\u5230\u4e92\u8054\u7684\u516c\u94a5\u3002\u3002\u3002\u3002");
        } else {
            log.error("\u62ff\u5230\u4e92\u8054\u516c\u94a5\u4e3a\uff1a" + serverPublicKey);
        }
        return RSAUtils.encryptByPublicKey((String)"MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCs+xq+pZvnji066WeQmfpS9vA17SciLiJk9DSTyGll11/F1tcg+jevbgG6a60uRfwdlnq1McMKbIdEdd0HcMIc3FPTAMCerSwWeZIU5ffL8hKBIhQy2JApZ4PIQIb5+WcojT97kjhxQRnBZjmXPfyRpXehIEAdyELn7fo7/dJacQIDAQAB", (String)serverPublicKey);
    }

    private String getEncryptPwd(String userName, String encryptPublicKey) throws Exception {
        String aesPrivateKey = this.digiwinIamProxyService.doGetAesKey(encryptPublicKey);
        String aesKey = new String(RSAUtils.decryptByPrivateKey((byte[])Base64.decodeBase64((String)aesPrivateKey), (String)"MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKz7Gr6lm+eOLTrpZ5CZ+lL28DXtJyIuImT0NJPIaWXXX8XW1yD6N69uAbprrS5F/B2WerUxwwpsh0R13QdwwhzcU9MAwJ6tLBZ5khTl98vyEoEiFDLYkClng8hAhvn5ZyiNP3uSOHFBGcFmOZc9/JGld6EgQB3IQuft+jv90lpxAgMBAAECgYANkRQj57E2k/wQJsYsnSb44s0sLZFoKN4htNV60bkSd7XXOmZc+8LqS2JvUIqgmnSPjYHKPEDjzGc/g072im1u3JUbTO7EyHhn7iuf9ynUe3KAAMSdD58SmQy2z12gpWYfp7x3AIGWWcHNk29Y/wVf73ZYRZWD5PZ7E2IHuFOewQJBAPfd0T0LlmIwssDgj0KsvP65rVhE6z81Z3IrMv0gXcmcQghJXYWOYonxxtAmSf3PYFJWFDcovFUtWlD5XkE7sj0CQQCyqDdz6laf/Y+fBBe6UEF9Qle1qFcga5S6nCBQ7RWPrfX3Twh8MvrTcCFfcVAe/NVxGZhFCvSNEF8aD0E67ZBFAkBMcoCXWFyQej6XmGr3AHnmAnSBVfhMbXczUjmOso3aobQIBECw8YJY01YjWrvVaUFnA5+Gh6zWhH9nnBHDAtttAkAdoG+xtUawOWg7wn3805pIn1vUMBpisfR0Dbf+M5LDxOFpJZ4OmpWlwo6GOVBEE0GCA/CQYoSzb+eVdromf4bRAkEAgjVXk9PqfsOQr3fZQ9G8sDiXHbqgwpvsqH73/7HTdLO6+IapR+meHyIj1H62z22WvsmwJmGtHyC2ROD5kJ1npg=="));
        return AESUtils.aesEncryptByBase64((String)userName, (String)aesKey);
    }

    private DigiwhaleLoginResponse loginWithSuperAdminInExperience(String locale, String clientAgent, String expRoleId, String targetTenantId, Mock mock, String iamDeviceID) throws Exception {
        String userId = "";
        String password = "";
        if (mock != null) {
            userId = mock.getNanaAdminAccount();
            password = mock.getNanaAdminPassword();
        } else {
            String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
            if (Objects.equals("https://athena-paas.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    userId = "DigiwinGpt123";
                    password = "DigiwinGpt123";
                }
            } else if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    if ("AthenaNjTest".equals(targetTenantId)) {
                        userId = "AthenaNjTest";
                        password = "72282866Digiwin";
                    } else {
                        userId = "DigiwinGpt123";
                        password = "DigiwinGpt123";
                    }
                }
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    userId = "demohhb123";
                    password = "Demo1234";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                    userId = "metis001";
                    password = "Metis0001";
                }
            } else if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    userId = "DigiwinGptDemo";
                    password = "DigiwinGptDemo123";
                }
            } else if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    userId = "demohhb";
                    password = "Demohhb123";
                } else {
                    userId = "hawkeye";
                    password = "123abcABC";
                }
            } else if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    userId = "lingxiang202401@gmail.com";
                    password = "Digiwin2024";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    userId = "demohhb";
                    password = "Demohhb123";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                    userId = "metis001";
                    password = "Metis0001";
                }
            } else if (Objects.equals("https://athena-hz-test.digiwincloud.com.cn", athenaMuiUrl) && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                userId = "qcuser001";
                password = "qcuser001";
            }
        }
        String encryptPublicKey = this.getEncryptPublicKey();
        ResponseEntity superadminLoginResponseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(encryptPublicKey, userId, this.getEncryptPwd(password, encryptPublicKey), locale, targetTenantId, clientAgent, null, iamDeviceID);
        return superadminLoginResponseEntity.getStatusCode().is2xxSuccessful() ? (DigiwhaleLoginResponse)superadminLoginResponseEntity.getBody() : null;
    }
}

