/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.myteam;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.list.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupOption;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupOptionConfigs;
import com.digiwin.mobile.mobileuibot.core.component.list.card.GroupFilterModelEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.UserProjectFilterGroupFilter;
import com.digiwin.mobile.mobileuibot.core.component.title.teamtitle.TeamTitle;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.UserProjectFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.UserProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.project.service.impl.ProjectServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPersonnelStructure;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinEmp;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildTeamProjectStrategy")
public class UiBotModelBuildTeamProjectStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildTeamProjectStrategy.class);
    private static final String GROUP_TYPE_TEAM_MEMBER = "teamMember";
    private static final String GROUP_TYPE_CODE = "code";
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private ProjectFilterService projectFilterService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private UserProjectFilterService userProjectFilterService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doBefore(pageSetting, apiRequest) : this.doMockData(apiRequest);
        return uiBotModel;
    }

    private UiBotModel doBefore(PageSetting pageSetting, ApiRequest apiRequest) {
        if (Optional.ofNullable(apiRequest.getRawData().get((Object)"groupType")).isPresent()) {
            return this.doActually(pageSetting, apiRequest);
        }
        return this.doActuallyV2(pageSetting, apiRequest);
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String userId = apiRequest.getUserId();
        ApiRawData rawData = apiRequest.getRawData();
        String groupType = (String)rawData.get((Object)"groupType");
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("groupType", groupType);
        if (GROUP_TYPE_TEAM_MEMBER.equalsIgnoreCase(groupType)) {
            params.put("userId", rawData.get((Object)"userId"));
        } else if (GROUP_TYPE_CODE.equalsIgnoreCase(groupType)) {
            params.put("projectDefCode", rawData.get((Object)"projectDefCode"));
        }
        List teamProjects = this.digiwinAtmcProxyService.getDepartProjectGroupList(iamUserToken, tenantId, locale, params);
        ProjectServiceImpl projectServiceImpl = new ProjectServiceImpl();
        List filteredProjectAndDoingTaskList = projectServiceImpl.convertProjectAndDoingTasks(teamProjects);
        List categories = CardCategory.getByProjects((List)teamProjects, (ProjectFilterService)this.projectFilterService, (ProjectServiceImpl)projectServiceImpl, (List)filteredProjectAndDoingTaskList, (String)locale, (String)iamUserToken, (String)userId, (String)tenantId);
        for (CardCategory cardCategory : categories) {
            cardCategory.setCardList(this.projectService.sortCardList(cardCategory.getCardList(), locale));
        }
        CardList cardList = new CardList();
        cardList.setCategoryList(categories);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case "TEAM_TITLE": {
                    pageData.put((Object)schema, JsonUtil.objectToJavaObject((Object)rawData.get((Object)schema), TeamTitle.class));
                    break;
                }
                case "CARD_LIST": {
                    pageData.put((Object)schema, (Object)cardList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doActuallyV2(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        uiBotModel.getRenderData().addWrapperedComponentToBody(this.buildCardListWrapper(apiRequest));
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildCardListWrapper(ApiRequest apiRequest) {
        DigiwinAtmcPersonnelStructure personnelStructure = this.digiwinAtmcProxyService.getPersonnelStructure(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List defaultSelectEmpList = Optional.ofNullable(personnelStructure).map(DigiwinAtmcPersonnelStructure::getAllChildrenDigiwinEmp).orElse(new ArrayList());
        UserProjectFilter projectFilter = this.userProjectFilterService.selectByParams(apiRequest.getUserId(), apiRequest.getTenantId(), PageFilterCodeEnum.TEAM_PROJECTS.getValue());
        CardList cardList = new CardList();
        cardList.setCardList(this.buildCardList(apiRequest, defaultSelectEmpList));
        cardList.setSearchUrl("/mobile/v1/project/search");
        cardList.setSearchIdList(this.buildSearchIdList(apiRequest, projectFilter, defaultSelectEmpList));
        cardList.setQueryParam(projectFilter == null ? "" : projectFilter.getQueryParam());
        cardList.setGroupFilter(this.buildGroupFilter(apiRequest, projectFilter));
        cardList.setPersonnelStructure(personnelStructure);
        return new BaseMobileComponentWrapper((BaseMobileComponent)cardList, "DW_CARD_LIST");
    }

    private List<String> buildSearchIdList(ApiRequest apiRequest, UserProjectFilter projectFilter, List<DigiwinEmp> defaultSelectEmpList) {
        if (projectFilter == null || !StringUtils.hasLength((String)projectFilter.getQueryParam()) || CollectionUtils.isEmpty(defaultSelectEmpList)) {
            return new ArrayList<String>();
        }
        return this.digiwinAtmcProxyService.teamProjectSearch(projectFilter.getQueryParam(), defaultSelectEmpList, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), apiRequest.getClientId());
    }

    private CardListGroupFilter buildGroupFilter(ApiRequest apiRequest, UserProjectFilter projectFilter) {
        List groupRecordList = this.digiwinAudcProxyService.groupRecord(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), PageFilterCodeEnum.TEAM_PROJECTS.getValue());
        if (CollectionUtils.isEmpty((Collection)groupRecordList)) {
            return null;
        }
        String groupFilter = Optional.ofNullable(projectFilter).map(UserProjectFilter::getGroupFilter).orElse(null);
        UserProjectFilterGroupFilter customGroup = StringUtils.hasLength((String)groupFilter) ? (UserProjectFilterGroupFilter)JsonUtil.jsonStringToObject((String)groupFilter, UserProjectFilterGroupFilter.class) : null;
        List customNormalGroup = Optional.ofNullable(customGroup).map(UserProjectFilterGroupFilter::getNormal).orElse(null);
        boolean existDefaultEffective = groupRecordList.stream().anyMatch(r -> BooleanUtils.isTrue((Boolean)r.getDefaultEffective()));
        List normalGroup = groupRecordList.stream().map(item -> {
            CardListGroupOption cardListGroupFilterOption = new CardListGroupOption();
            cardListGroupFilterOption.setFilterOptionId(item.getCode());
            cardListGroupFilterOption.setFilterOptionName(this.localeService.getLanguageValue(apiRequest.getLocale(), item.getName()));
            cardListGroupFilterOption.setDefaultEffective(item.getDefaultEffective());
            cardListGroupFilterOption.setSort("asc");
            if (!existDefaultEffective && "noGrouping".equalsIgnoreCase(item.getCode())) {
                cardListGroupFilterOption.setDefaultEffective(Boolean.valueOf(true));
            }
            if (CollectionUtils.isEmpty((Collection)customNormalGroup)) {
                if (existDefaultEffective) {
                    if (BooleanUtils.isTrue((Boolean)item.getDefaultEffective())) {
                        cardListGroupFilterOption.setIsSelect(Boolean.valueOf(true));
                        cardListGroupFilterOption.setSort("asc");
                    }
                } else if ("noGrouping".equalsIgnoreCase(item.getCode())) {
                    cardListGroupFilterOption.setIsSelect(Boolean.valueOf(true));
                    cardListGroupFilterOption.setSort("asc");
                }
                cardListGroupFilterOption.convertOptionConfigs(this.localeService, apiRequest.getLocale(), item.getConfigs(), null);
            } else {
                customNormalGroup.forEach(r -> {
                    if (item.getCode().equals(r.getFilterOptionId())) {
                        cardListGroupFilterOption.setIsSelect(Boolean.valueOf(true));
                        cardListGroupFilterOption.setSort(r.getSort());
                    }
                });
                CardListGroupOptionConfigs customConfigs = customNormalGroup.stream().filter(r -> Objects.nonNull(r.getOptionConfigs())).findFirst().map(CardListGroupOption::getOptionConfigs).orElse(null);
                cardListGroupFilterOption.convertOptionConfigs(this.localeService, apiRequest.getLocale(), item.getConfigs(), customConfigs);
            }
            cardListGroupFilterOption.setType(item.getType());
            return cardListGroupFilterOption;
        }).collect(Collectors.toList());
        CardListGroupFilter cardListGroupFilter = new CardListGroupFilter();
        cardListGroupFilter.setModel(customGroup == null ? GroupFilterModelEnum.NORMAL.getValue() : customGroup.getModel());
        cardListGroupFilter.setFilterOptionList(normalGroup);
        return cardListGroupFilter;
    }

    private List<Card> buildCardList(ApiRequest apiRequest, List<DigiwinEmp> defaultSelectEmpList) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        if (CollectionUtils.isEmpty(defaultSelectEmpList)) {
            return new ArrayList<Card>();
        }
        List teamProjects = this.digiwinAtmcProxyService.selectEmpProject(defaultSelectEmpList, iamUserToken, locale, tenantId);
        if (CollectionUtils.isEmpty((Collection)teamProjects)) {
            return new ArrayList<Card>();
        }
        teamProjects.removeIf(r -> !"PTM".equals(r.getDataFrom()));
        return teamProjects.stream().map(project -> {
            if (this.projectFilterService.isCenterConsoleProject(project, tenantId)) {
                return this.projectService.handleCenterConsoleProject(project, iamUserToken, tenantId, locale, true);
            }
            if (this.projectFilterService.isStandardProject(project, tenantId)) {
                return this.projectService.handleStandardProject(project, iamUserToken, locale, tenantId, true);
            }
            if (this.projectFilterService.isSystemCloudHouseKeeper(project, tenantId)) {
                return this.projectService.handleSystemCloudKeeperProject(project, iamUserToken, tenantId, locale, true);
            }
            return this.projectService.handleCurrentlyNotSupportedProject(project, iamUserToken, locale, tenantId, true);
        }).collect(Collectors.toList());
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}

