/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.notification.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetail;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationRemoveResp;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationSummary;
import com.digiwin.mobile.mobileuibot.notification.model.PushNotification;
import com.digiwin.mobile.mobileuibot.notification.service.NotificationService;
import com.digiwin.mobile.mobileuibot.notification.strategy.NotificationDetailStrategyFactory;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimMessage;
import com.digiwin.mobile.mobileuibot.proxy.aim.model.DigiwinAimNewMessageSummary;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.push.jpush.PushConfig;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.push.jpush.service.PushSupplierEnable;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="notificationService")
public class NotificationServiceImpl
implements NotificationService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationServiceImpl.class);
    public static final Integer MESSAGE_READ = 1;
    public static final Integer MESSAGE_NOT_READ = 0;
    public static final Integer NOTIFICATION_TYPE_SYSTEM = 1;
    public static final String CATEGORY_KEY_SYSTEM = "SYSTEM";
    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;
    @Autowired
    private PushSupplierEnable jPushService;
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Resource(name="defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private NotificationDetailStrategyFactory notificationDetailStrategyFactory;
    @Autowired
    private LocaleService localeService;

    public List<NotificationSummary> listNotificationSummaries(String clientId, String iamUserToken, String locale, Integer pageNum, Integer pageSize) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        List resultSummaries = useMockData == false ? this.doActually(clientId, iamUserToken, locale, pageNum, pageSize) : this.doMockData(locale);
        return resultSummaries;
    }

    @NotNull
    private List<NotificationSummary> doActually(String clientId, String iamUserToken, String locale, Integer pageNum, Integer pageSize) {
        List aimMessageSummaries = null;
        Integer unRead = 0;
        ArrayList<Future> futureList = new ArrayList<Future>();
        unRead = this.digiwinAimProxyService.countMessageUnRead(locale, iamUserToken, Integer.valueOf(0));
        Future futureAimMessageSummaries = this.threadPoolTaskExecutor.submit(() -> this.digiwinAimProxyService.listMessageSummary(locale, iamUserToken, pageNum, pageSize));
        futureList.add(futureAimMessageSummaries);
        try {
            block6: for (Future future : futureList) {
                while (true) {
                    if (future.isDone() && !future.isCancelled()) {
                        Object obj = future.get();
                        if (!(obj instanceof DigiwinAimNewMessageSummary)) continue block6;
                        aimMessageSummaries = ((DigiwinAimNewMessageSummary)obj).getContent();
                        continue block6;
                    }
                    Thread.sleep(1L);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        if (aimMessageSummaries == null) {
            aimMessageSummaries = Collections.emptyList();
        }
        ArrayList<NotificationSummary> resultSummaries = new ArrayList<NotificationSummary>();
        ArrayList<NotificationSummary> tempNotificationSummaries = new ArrayList<NotificationSummary>();
        for (DigiwinAimMessage aimMessageSummary : aimMessageSummaries) {
            tempNotificationSummaries.add(NotificationSummary.create((String)locale, (DigiwinAimMessage)aimMessageSummary, (Integer)unRead, (LocaleService)this.localeService));
        }
        HashMap<String, Integer> categoryIdIndexRecord = new HashMap<String, Integer>();
        for (NotificationSummary tempNotificationSummary : tempNotificationSummaries) {
            String categoryId = tempNotificationSummary.getCategoryId();
            if (!categoryIdIndexRecord.containsKey(categoryId)) {
                categoryIdIndexRecord.put(categoryId, resultSummaries.size());
                resultSummaries.add(tempNotificationSummary);
                continue;
            }
            Integer existedIndex = (Integer)categoryIdIndexRecord.get(categoryId);
            NotificationSummary existedSummary = (NotificationSummary)resultSummaries.get(existedIndex);
            existedSummary.merge(tempNotificationSummary);
        }
        resultSummaries.sort((o1, o2) -> {
            LocalDateTime o2NotificationSendDateTime;
            LocalDateTime o1NotificationSendDateTime = DateTimeUtil.parseUseDefaultPattern((String)o1.getLatestNotification().getPublishTime());
            if (o1NotificationSendDateTime.isBefore(o2NotificationSendDateTime = DateTimeUtil.parseUseDefaultPattern((String)o2.getLatestNotification().getPublishTime()))) {
                return 1;
            }
            if (o1NotificationSendDateTime.isEqual(o2NotificationSendDateTime)) {
                return 0;
            }
            return -1;
        });
        resultSummaries.sort((o1, o2) -> {
            String o1CategoryId = o1.getCategoryId();
            String o2CategoryId = o2.getCategoryId();
            if (o1CategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString()) && !o2CategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString())) {
                return 1;
            }
            if (!o1CategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString()) && o2CategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString())) {
                return -1;
            }
            return 0;
        });
        if (resultSummaries.isEmpty()) {
            resultSummaries.add(NotificationSummary.createAthenaWelcomeSummary((String)locale));
        }
        return resultSummaries;
    }

    private List<NotificationSummary> doMockData(String locale) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = FileUtil.readText((String)"static/appstore-use/notification-sort-list.json");
        List notificationSummaryList = Collections.emptyList();
        if (null != data && !data.isEmpty()) {
            notificationSummaryList = JSONArray.parseArray((String)data, NotificationSummary.class);
        }
        return notificationSummaryList;
    }

    public List<NotificationDetail> listNotificationDetailsByCategoryId(String userId, String clientId, String iamUserToken, String tenantId, String locale, String mobileNotificationCategoryId, String dataId, Integer pageNum, Integer pageSize) throws IOException {
        if (pageNum == null) {
            pageNum = 0;
        }
        if (mobileNotificationCategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString()) || mobileNotificationCategoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString())) {
            return this.notificationDetailStrategyFactory.get("notificationDetailChattingStrategy").listNotificationDetails(userId, clientId, locale, iamUserToken, tenantId, mobileNotificationCategoryId, dataId, pageNum, pageSize);
        }
        return null;
    }

    public Integer pushNotificationToUserId(String outerUserId, String outerTenantId, PushNotification push, String creatorName, List label) {
        logger.error("+++ pushNotificationToUserId,toUserId:" + outerUserId + ";toTenant:" + outerTenantId + ";pushNotification:" + (null == push ? "\u63a8\u9001\u5185\u5bb9\u4e3a\u7a7a" : JsonUtil.javaObjectToJsonString((Object)push)));
        if (push == null) {
            return 0;
        }
        Notification notification = this.buildNotification(outerUserId, outerTenantId, push, creatorName, label);
        PushConfig pushConfig = new PushConfig();
        pushConfig.setType(this.sysEnvConfig.getType());
        pushConfig.setAppkey(this.sysEnvConfig.getJpushAppKey());
        pushConfig.setMasterSecret(this.sysEnvConfig.getJpushMasterSecret());
        pushConfig.setJpushAndroidIntentComponent(this.sysEnvConfig.getJpushAndroidIntentComponent());
        Boolean isSuccess = this.jPushService.pushAlert(notification, pushConfig);
        return isSuccess != false ? 1 : 0;
    }

    private Notification buildNotification(String outerUserId, String outerTenantId, PushNotification push, String creatorName, List label) {
        Notification notification = new Notification();
        String uuid = UUIDUtil.getUuid();
        notification.setNotificationID(uuid);
        notification.setUserId(outerUserId);
        notification.setTenantId(outerTenantId);
        notification.setNotificationTime(new Timestamp(System.currentTimeMillis()));
        notification.setIsRead(MESSAGE_NOT_READ);
        HashMap<String, Object> contentMap = new HashMap<String, Object>(8);
        contentMap.put("content", push.getContent());
        contentMap.put("frompeople", creatorName);
        contentMap.put("label", label);
        contentMap.put("title", push.getTitle());
        if (StringUtil.isNotEmpty((CharSequence)push.getUrl())) {
            String detailUrl = push.getUrl();
            contentMap.put("detailUrl", detailUrl);
        } else {
            contentMap.put("detailUrl", "");
        }
        if (push.getDetail() != null) {
            contentMap.put("detail", push.getDetail());
        }
        if (StringUtil.isNotEmpty((CharSequence)push.getTenantId())) {
            contentMap.put("tenantId", push.getTenantId());
        }
        contentMap.put("apnsProduction", push.getApnsProduction());
        notification.setNotificationContent(JsonUtil.javaObjectToJsonString(contentMap));
        notification.setNotificationType(NOTIFICATION_TYPE_SYSTEM);
        notification.setTitle(push.getTitle());
        notification.setSourceType(CATEGORY_KEY_SYSTEM);
        notification.setContentID(uuid);
        notification.setMobileType(Integer.valueOf(0));
        notification.setApnsProduction(Boolean.valueOf(true));
        return notification;
    }

    public NotificationRemoveResp oneClickRemove() {
        NotificationRemoveResp resp = new NotificationRemoveResp();
        Integer removeNum = this.digiwinAimProxyService.oneClickRemove();
        resp.setRemoveNum(removeNum);
        if (removeNum == null || removeNum == 0) {
            resp.setMessage(this.localeService.getLanguageValue("\u6682\u65e0\u53ef\u6e05\u9664\u7684\u5de5\u4f5c\u63d0\u9192"));
        } else if (removeNum < 1000) {
            resp.setMessage(this.localeService.getLanguageValue("\u6240\u6709\u6d88\u606f\u6e05\u9664\u5b8c\u6210"));
        } else {
            resp.setMessage(this.localeService.getLanguageValue("\u672c\u6b21\u5b8c\u6210\u6e05\u96641000\u6761"));
        }
        return resp;
    }
}

