/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.portal.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileAppColumnResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobileFullBackResp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal"})
public class MobilePortalController {
    @Autowired
    private PortalService portalService;
    @Autowired
    private LocaleService localeService;
    private static final Integer MAX_LENGTH = 8;

    @PostMapping(value={"/info/userAuth/selectUserPortal"})
    public ApiResponse selectUserPortal(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        return ApiResponse.buildOK().setData((Object)this.portalService.selectUserPortal(apiRequsetPortal));
    }

    @PostMapping(value={"/addPortalType"})
    public ApiResponse addPortalType(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (BooleanUtils.isTrue((Boolean)AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return ApiResponse.buildOK();
        }
        Boolean flag = this.portalService.addPortalType(apiRequsetPortal);
        if (flag.booleanValue()) {
            return ApiResponse.buildOK().setData((Object)flag);
        }
        return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u60a8\u6240\u9009\u62e9\u7684\u804c\u80fd\u95e8\u6237\u6743\u9650\u88ab\u6536\u56de\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u95e8\u6237"));
    }

    @PostMapping(value={"/check"})
    public ApiResponse check(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        return ApiResponse.buildOK().setData((Object)this.portalService.check(apiRequsetPortal));
    }

    @PostMapping(value={"/getClassificationList"})
    public ApiResponse getClassificationList(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        apiRequsetPortal.setIsAll(Boolean.valueOf(true));
        ArrayList result = this.portalService.getClassificationList(apiRequsetPortal);
        if (ObjectUtils.isEmpty((Object)result)) {
            result = new ArrayList();
        }
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/saveApplicationColumn"})
    public ApiResponse saveApplicationColumn(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u6dfb\u52a0\u7684\u680f\u76ee\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        if (ObjectUtils.isNotEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getName()) && apiRequsetPortal.getApplicationColumnReq().getName().length() > MAX_LENGTH) {
            return ApiResponse.buildError((String)"\u680f\u76ee\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        JSONObject resp = this.portalService.saveApplicationColumn(apiRequsetPortal);
        if (null != resp && StringUtil.isNotEmpty((CharSequence)resp.getString("error"))) {
            return ApiResponse.buildError((String)resp.getString("error"));
        }
        return ApiResponse.buildOK().setData((Object)resp);
    }

    @PostMapping(value={"/saveApplicationColumnNew"})
    public ApiResponse saveApplicationColumnNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u6dfb\u52a0\u7684\u680f\u76ee\u5185\u5bb9\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        if (ObjectUtils.isNotEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getName()) && apiRequsetPortal.getApplicationColumnReq().getName().length() > MAX_LENGTH) {
            return ApiResponse.buildError((String)"\u680f\u76ee\u540d\u79f0\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        JSONObject resp = this.portalService.saveApplicationColumnNew(apiRequsetPortal);
        if (null != resp && StringUtil.isNotEmpty((CharSequence)resp.getString("error"))) {
            return ApiResponse.buildError((String)resp.getString("error"));
        }
        return ApiResponse.buildOK().setData((Object)resp);
    }

    @PostMapping(value={"/getApplicationColumnList"})
    public ApiResponse getApplicationColumnList(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        ArrayList columnReqs = this.portalService.getApplicationColumnList(apiRequsetPortal);
        if (ObjectUtils.isEmpty((Object)columnReqs)) {
            columnReqs = new ArrayList();
        }
        return ApiResponse.buildOK().setData((Object)columnReqs);
    }

    @PostMapping(value={"/getApplicationColumnListNew"})
    public ApiResponse getApplicationColumnListNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        ArrayList columnReqs = this.portalService.getApplicationColumnListNew(apiRequsetPortal);
        if (ObjectUtils.isEmpty((Object)columnReqs)) {
            columnReqs = new ArrayList();
        }
        return ApiResponse.buildOK().setData((Object)columnReqs);
    }

    @PostMapping(value={"/getApplicationColumnDetail"})
    public ApiResponse getApplicationColumnDetail(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u680f\u76eeid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        MobileAppColumnResp result = this.portalService.getApplicationColumnDetail(apiRequsetPortal);
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/getApplicationColumnDetailNew"})
    public ApiResponse getApplicationColumnDetailNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u680f\u76eeid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        MobileAppColumnResp result = this.portalService.getApplicationColumnDetailNew(apiRequsetPortal);
        return ApiResponse.buildOK().setData((Object)result);
    }

    @PostMapping(value={"/setColumnOrder"})
    public ApiResponse setColumnOrder(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (CollectionUtils.isEmpty((Collection)apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u680f\u76eeid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.setColumnOrder(apiRequsetPortal));
    }

    @PostMapping(value={"/setColumnOrderNew"})
    public ApiResponse setColumnOrderNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (CollectionUtils.isEmpty((Collection)apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u680f\u76eeid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.setColumnOrderNew(apiRequsetPortal));
    }

    @PostMapping(value={"/delColumn"})
    public ApiResponse delColumn(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getColumnIds()) || CollectionUtils.isEmpty((Collection)apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u680f\u76eeid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.delColumn(apiRequsetPortal));
    }

    @PostMapping(value={"/delColumnNew"})
    public ApiResponse delColumnNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getColumnIds()) || CollectionUtils.isEmpty((Collection)apiRequsetPortal.getColumnIds())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u680f\u76eeid\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.delColumnNew(apiRequsetPortal));
    }

    @PostMapping(value={"/updateColumnStatus"})
    public ApiResponse updateColumnStatus(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq()) || ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getId()) || ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getStatus())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.updateColumnStatus(apiRequsetPortal));
    }

    @PostMapping(value={"/updateColumnStatusNew"})
    public ApiResponse updateColumnStatusNew(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq()) || ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getId()) || ObjectUtils.isEmpty((Object)apiRequsetPortal.getApplicationColumnReq().getStatus())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.updateColumnStatusNew(apiRequsetPortal));
    }

    @PostMapping(value={"/getFullCallBackUrl"})
    public ApiResponse getFullCallBackUrl(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (ObjectUtils.isEmpty((Object)apiRequsetPortal.getCustomApplicationId())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u53c2\u6570"));
        }
        MobileFullBackResp fullBackResp = this.portalService.getFullCallBackUrl(apiRequsetPortal);
        if (!fullBackResp.getIsHavePerm().booleanValue()) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u6682\u65e0\u8bbf\u95ee\u6743\u9650"));
        }
        return ApiResponse.buildOK().setData((Object)fullBackResp);
    }

    @PostMapping(value={"/validUserAppAuth"})
    public ApiResponse validUserAppAuth(@RequestBody ApiRequsetPortal apiRequsetPortal) {
        if (CollectionUtils.isEmpty((Collection)apiRequsetPortal.getCustomApplicationIdList())) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(apiRequsetPortal.getLocale(), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        return ApiResponse.buildOK().setData((Object)this.portalService.validUserAppAuth(apiRequsetPortal));
    }

    @PostMapping(value={"/getClassificationListNew"})
    public ApiResponse getClassificationListNew(@RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.portalService.getClassificationListNew(apiRequest));
    }
}

