/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.printer.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.printer.enums.PrinterTemplatePatternEnum;
import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandBuilder;
import com.digiwin.mobile.mobileuibot.printer.factory.PrinterCommandFactory;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommand;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommandByImage;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestTemplate;
import com.digiwin.mobile.mobileuibot.printer.response.CommandVO;
import com.digiwin.mobile.mobileuibot.printer.response.PrintTemplateVO;
import com.digiwin.mobile.mobileuibot.printer.service.AbiReportService;
import com.digiwin.mobile.mobileuibot.printer.service.PrinterService;
import com.digiwin.mobile.mobileuibot.printer.utils.PdfToImageUtils;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrinterServiceImpl
implements PrinterService {
    private static final Logger log = LoggerFactory.getLogger(PrinterServiceImpl.class);
    @Autowired
    private PrinterCommandFactory printerCommandFactory;
    @Autowired
    private AbiReportService abiReportService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    public CommandVO getCommand(ApiRequestCommand request) throws Exception {
        request.setDataId(request.getRawData().getString("printTemplateCode"));
        Class builder = this.printerCommandFactory.getBuilder(request.getCommandType());
        CommandVO commandVO = new CommandVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        commandVO.setCurrentTime(sdf.format(new Date()));
        UiBotModel uibotModel = this.abiReportService.getUibotModel(request);
        commandVO.setFileName(Optional.ofNullable(uibotModel.getRawUiBotPageData()).map(g -> g.get((Object)"UIBOT__activityName")).map(StringUtil::valueOf).orElse(""));
        if (builder == null) {
            log.error("\u65e0\u6cd5\u8bc6\u522b\u7684\u6307\u4ee4\u683c\u5f0f");
            return commandVO;
        }
        String pdfUrl = this.abiReportService.getExportPdfUrl(request, uibotModel);
        log.info("PDF URL\uff1a{}", (Object)pdfUrl);
        if (StringUtils.isEmpty((CharSequence)pdfUrl)) {
            log.error(commandVO.toString());
            return commandVO;
        }
        List imagePaths = PdfToImageUtils.convertPdfUrlToBmp((String)pdfUrl);
        log.info("\u56fe\u7247\u8def\u5f84\uff1a{}", (Object)imagePaths);
        List commands = ((PrinterCommandBuilder)SpringContextHolder.getBean((Class)builder)).buildPrintCommand(imagePaths);
        PdfToImageUtils.deleteFiles((List)imagePaths);
        commandVO.setCommands(commands);
        commandVO.setPdfUrl(pdfUrl);
        return commandVO;
    }

    public CommandVO getCommand2(ApiRequestCommand request) throws Exception {
        Class builder = this.printerCommandFactory.getBuilder(request.getCommandType());
        CommandVO commandVO = new CommandVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        commandVO.setCurrentTime(sdf.format(new Date()));
        commandVO.setFileName(Optional.ofNullable(request.getPrintTemplate()).map(PrintTemplateVO::getName).orElse(""));
        if (builder == null) {
            log.error("\u65e0\u6cd5\u8bc6\u522b\u7684\u6307\u4ee4\u683c\u5f0f");
            return commandVO;
        }
        String pdfUrl = this.abiReportService.getExportPdfUrl(request);
        log.info("PDF URL\uff1a{}", (Object)pdfUrl);
        if (StringUtils.isEmpty((CharSequence)pdfUrl)) {
            log.error(commandVO.toString());
            return commandVO;
        }
        List imagePaths = PdfToImageUtils.convertPdfUrlToBmp((String)pdfUrl);
        log.info("\u56fe\u7247\u8def\u5f84\uff1a{}", (Object)imagePaths);
        List commands = ((PrinterCommandBuilder)SpringContextHolder.getBean((Class)builder)).buildPrintCommand(imagePaths);
        PdfToImageUtils.deleteFiles((List)imagePaths);
        commandVO.setCommands(commands);
        commandVO.setPdfUrl(pdfUrl);
        return commandVO;
    }

    public CommandVO getCommandByImage(ApiRequestCommandByImage request) throws Exception {
        return null;
    }

    public List<PrintTemplateVO> templateList(ApiRequestTemplate request) {
        if (BooleanUtils.isNotTrue((Boolean)request.getRawData().getBoolean("isNewVersion"))) {
            return Lists.newArrayList((Object[])new PrintTemplateVO[]{new PrintTemplateVO()});
        }
        PcUiBotSubmitAction submitAction = (PcUiBotSubmitAction)JsonUtil.objectToJavaObject((Object)request.getRawData().get((Object)"action"), PcUiBotSubmitAction.class);
        if (submitAction == null) {
            return null;
        }
        PcUiBotSubmitExecuteContext executeContext = submitAction.getExecuteContext();
        if (executeContext == null) {
            return null;
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("appCode", executeContext.getApplication());
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pattern", this.buildPattern(executeContext));
        uriVariables.put("targetId", request.getRawData().getString("targetId"));
        uriVariables.put("client", "APP");
        DigiwinAthenaApiRequest athenaApiRequest = DigiwinAthenaApiRequest.builder().requestHead(new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale(), request.getIamUserToken(), request.getTenantId())).uriVariables(uriVariables).build();
        List templateList = this.digiwinAtmcProxyService.getPrintList(athenaApiRequest);
        return templateList.stream().map(PrintTemplateVO::convert).collect(Collectors.toList());
    }

    private String buildPattern(PcUiBotSubmitExecuteContext executeContext) {
        if (executeContext == null) {
            return null;
        }
        if ("task-detail-mobile".equals(executeContext.getPageCode())) {
            return PrinterTemplatePatternEnum.BUSINESS_PERFORM.name();
        }
        if ("project-detail-mobile".equals(executeContext.getPageCode())) {
            return PrinterTemplatePatternEnum.BUSINESS_CHARGE.name();
        }
        return PrinterTemplatePatternEnum.DATA_ENTRY_PERFORM.name();
    }
}

